/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.persister;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.annotations.common.AssertionFailure;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.access.CollectionRegionAccessStrategy;
import org.hibernate.cfg.Configuration;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SubselectFetch;
import org.hibernate.internal.FilterAliasGenerator;
import org.hibernate.internal.StaticFilterAliasGenerator;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.loader.collection.CollectionInitializer;
import org.hibernate.mapping.Collection;
import org.hibernate.ogm.datastore.spi.Association;
import org.hibernate.ogm.datastore.spi.Tuple;
import org.hibernate.ogm.dialect.GridDialect;
import org.hibernate.ogm.grid.AssociationKeyMetadata;
import org.hibernate.ogm.grid.EntityKey;
import org.hibernate.ogm.grid.RowKey;
import org.hibernate.ogm.grid.impl.RowKeyBuilder;
import org.hibernate.ogm.jdbc.TupleAsMapResultSet;
import org.hibernate.ogm.loader.OgmBasicCollectionLoader;
import org.hibernate.ogm.persister.CollectionPhysicalModel;
import org.hibernate.ogm.persister.EntityKeyBuilder;
import org.hibernate.ogm.persister.OgmEntityPersister;
import org.hibernate.ogm.type.GridType;
import org.hibernate.ogm.type.TypeTranslator;
import org.hibernate.ogm.util.impl.AssociationPersister;
import org.hibernate.ogm.util.impl.Log;
import org.hibernate.ogm.util.impl.LoggerFactory;
import org.hibernate.ogm.util.impl.LogicalPhysicalConverterHelper;
import org.hibernate.persister.collection.AbstractCollectionPersister;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;

public class OgmCollectionPersister
extends AbstractCollectionPersister
implements CollectionPhysicalModel {
    private static final Log log = LoggerFactory.make();
    private final GridType keyGridType;
    private final GridType elementGridType;
    private final GridType indexGridType;
    private final GridType identifierGridType;
    private final boolean isInverse;
    private final boolean oneToMany;
    private final GridType gridTypeOfAssociatedId;
    private final AssociationType associationType;
    private final GridDialect gridDialect;
    private final AssociationKeyMetadata associationKeyMetadata;
    private final AssociationKeyMetadata associationKeyMetadataFromElement;
    private final String nodeName;

    public OgmCollectionPersister(Collection collection, CollectionRegionAccessStrategy cacheAccessStrategy, Configuration cfg, SessionFactoryImplementor factory) throws MappingException, CacheException {
        super(collection, cacheAccessStrategy, cfg, factory);
        ServiceRegistryImplementor registry = factory.getServiceRegistry();
        TypeTranslator typeTranslator = (TypeTranslator)registry.getService(TypeTranslator.class);
        this.gridDialect = (GridDialect)registry.getService(GridDialect.class);
        this.keyGridType = typeTranslator.getType(this.getKeyType());
        this.elementGridType = typeTranslator.getType(this.getElementType());
        this.indexGridType = typeTranslator.getType(this.getIndexType());
        this.identifierGridType = typeTranslator.getType(this.getIdentifierType());
        this.isInverse = collection.isInverse();
        this.oneToMany = collection.isOneToMany();
        if (collection.isOneToMany() && this.getElementPersister() != null && this.getElementType().isEntityType()) {
            this.associationType = AssociationType.EMBEDDED_FK_TO_ENTITY;
            Type identifierOrUniqueKeyType = ((EntityType)this.getElementType()).getIdentifierOrUniqueKeyType((Mapping)factory);
            this.gridTypeOfAssociatedId = typeTranslator.getType(identifierOrUniqueKeyType);
        } else {
            if (collection.isOneToMany()) {
                throw new AssertionFailure("Association marked as one to many but has no ManyToOneType: " + collection.getRole());
            }
            if (this.getElementType().isAssociationType() && this.getElementType().isEntityType()) {
                this.associationType = AssociationType.ASSOCIATION_TABLE_TO_ENTITY;
                Type identifierOrUniqueKeyType = ((EntityType)this.getElementType()).getIdentifierOrUniqueKeyType((Mapping)factory);
                this.gridTypeOfAssociatedId = typeTranslator.getType(identifierOrUniqueKeyType);
            } else {
                this.gridTypeOfAssociatedId = null;
                this.associationType = AssociationType.OTHER;
            }
        }
        this.associationKeyMetadata = new AssociationKeyMetadata(this.getTableName(), this.getKeyColumnNames());
        this.associationKeyMetadata.setRowKeyColumnNames(this.getRowKeyColumnNames());
        this.associationKeyMetadataFromElement = new AssociationKeyMetadata(this.getTableName(), this.getElementColumnNames());
        this.associationKeyMetadataFromElement.setRowKeyColumnNames(this.getRowKeyColumnNames());
        this.nodeName = collection.getNodeName();
    }

    public AssociationKeyMetadata getAssociationKeyMetadata() {
        return this.associationKeyMetadata;
    }

    public Object readKey(ResultSet rs, String[] aliases, SessionImplementor session) throws HibernateException, SQLException {
        TupleAsMapResultSet resultset = rs.unwrap(TupleAsMapResultSet.class);
        Tuple keyTuple = resultset.getTuple();
        return this.keyGridType.nullSafeGet(keyTuple, aliases, session, null);
    }

    public Object readElement(ResultSet rs, Object owner, String[] aliases, SessionImplementor session) throws HibernateException, SQLException {
        TupleAsMapResultSet resultset = rs.unwrap(TupleAsMapResultSet.class);
        Tuple keyTuple = resultset.getTuple();
        return this.elementGridType.nullSafeGet(keyTuple, aliases, session, owner);
    }

    public Object readIdentifier(ResultSet rs, String alias, SessionImplementor session) throws HibernateException, SQLException {
        TupleAsMapResultSet resultset = rs.unwrap(TupleAsMapResultSet.class);
        Tuple keyTuple = resultset.getTuple();
        return this.identifierGridType.nullSafeGet(keyTuple, alias, session, null);
    }

    public Object readIndex(ResultSet rs, String[] aliases, SessionImplementor session) throws HibernateException, SQLException {
        TupleAsMapResultSet resultset = rs.unwrap(TupleAsMapResultSet.class);
        Tuple keyTuple = resultset.getTuple();
        return this.indexGridType.nullSafeGet(keyTuple, aliases, session, null);
    }

    protected CollectionInitializer createSubselectInitializer(SubselectFetch subselect, SessionImplementor session) {
        return null;
    }

    protected CollectionInitializer createCollectionInitializer(LoadQueryInfluencers loadQueryInfluencers) throws MappingException {
        return new OgmBasicCollectionLoader(this);
    }

    @Override
    public GridType getKeyGridType() {
        return this.keyGridType;
    }

    @Override
    public GridType getElementGridType() {
        return this.elementGridType;
    }

    public boolean isOneToMany() {
        return this.oneToMany;
    }

    public boolean isManyToMany() {
        return true;
    }

    public boolean isCascadeDeleteEnabled() {
        return false;
    }

    protected String generateDeleteString() {
        return null;
    }

    protected String generateDeleteRowString() {
        return null;
    }

    protected String generateUpdateRowString() {
        return null;
    }

    protected String generateInsertRowString() {
        return null;
    }

    protected int doUpdateRows(Serializable key, PersistentCollection collection, SessionImplementor session) throws HibernateException {
        if (ArrayHelper.isAllFalse((boolean[])this.elementColumnIsSettable)) {
            return 0;
        }
        int count = 0;
        int i = 0;
        Iterator entries = collection.entries((CollectionPersister)this);
        AssociationPersister associationPersister = new AssociationPersister(this.getOwnerEntityPersister().getMappedClass()).hostingEntity(collection.getOwner()).gridDialect(this.gridDialect).key(key).keyGridType(this.getKeyGridType()).associationKeyMetadata(this.associationKeyMetadata).collectionPersister(this).session(session);
        while (entries.hasNext()) {
            Object entry = entries.next();
            if (collection.needsUpdating(entry, i, this.elementType)) {
                RowKey assocEntryKey = this.getTupleKeyForUpdate(key, collection, session, i, entry);
                Tuple assocEntryTuple = associationPersister.getAssociation().get(assocEntryKey);
                if (assocEntryTuple == null) {
                    throw new AssertionFailure("Updating a collection tuple that is not present: table {" + this.getTableName() + "} collectionKey {" + key + "} entry {" + entry + "}");
                }
                this.updateInverseSideOfAssociationNavigation(session, entry, assocEntryTuple, Action.REMOVE, assocEntryKey);
                this.getElementGridType().nullSafeSet(assocEntryTuple, collection.getElement(entry), this.getElementColumnNames(), session);
                associationPersister.getAssociation().put(assocEntryKey, assocEntryTuple);
                this.updateInverseSideOfAssociationNavigation(session, entry, assocEntryTuple, Action.ADD, assocEntryKey);
                ++count;
            }
            ++i;
        }
        associationPersister.flushToCache();
        return count;
    }

    private void completeTuple(RowKeyAndTuple keyAndTuple, PersistentCollection collection, SessionImplementor session, Object entry) {
        Object element = collection.getElement(entry);
        this.getElementGridType().nullSafeSet(keyAndTuple.tuple, element, this.getElementColumnNames(), session);
    }

    private RowKeyAndTuple createAndPutTupleforInsert(Serializable key, PersistentCollection collection, AssociationPersister associationPersister, SessionImplementor session, int i, Object entry) {
        RowKeyBuilder rowKeyBuilder = this.initializeRowKeyBuilder();
        Tuple tuple = new Tuple();
        if (this.hasIdentifier) {
            Object identifier = collection.getIdentifier(entry, i);
            String[] names = new String[]{this.getIdentifierColumnName()};
            this.identifierGridType.nullSafeSet(tuple, identifier, names, session);
        }
        this.getKeyGridType().nullSafeSet(tuple, key, this.getKeyColumnNames(), session);
        if (this.hasIndex) {
            Object index = collection.getIndex(entry, i, (CollectionPersister)this);
            this.indexGridType.nullSafeSet(tuple, this.incrementIndexByBase(index), this.getIndexColumnNames(), session);
        } else {
            Object element = collection.getElement(entry);
            this.getElementGridType().nullSafeSet(tuple, element, this.getElementColumnNames(), session);
        }
        RowKeyAndTuple result = new RowKeyAndTuple();
        result.key = rowKeyBuilder.values(tuple).build();
        Tuple assocEntryTuple = associationPersister.createAndPutAssociationTuple(result.key);
        for (String column : tuple.getColumnNames()) {
            assocEntryTuple.put(column, tuple.get(column));
        }
        result.tuple = assocEntryTuple;
        return result;
    }

    public RowKeyBuilder initializeRowKeyBuilder() {
        RowKeyBuilder builder = new RowKeyBuilder().tableName(this.getTableName());
        if (this.hasIdentifier) {
            builder.addColumns(this.getIdentifierColumnName());
        } else {
            builder.addColumns(this.getKeyColumnNames());
            if (!this.isOneToMany() && this.hasIndex && !this.indexContainsFormula) {
                builder.addColumns(this.getIndexColumnNames());
            } else {
                builder.addColumns(this.getElementColumnNames());
            }
        }
        return builder;
    }

    public String[] getRowKeyColumnNames() {
        return this.initializeRowKeyBuilder().getColumnNames();
    }

    private RowKey getTupleKeyForUpdate(Serializable key, PersistentCollection collection, SessionImplementor session, int i, Object entry) {
        RowKeyBuilder rowKeyBuilder = this.initializeRowKeyBuilder();
        Tuple tuple = new Tuple();
        if (this.hasIdentifier) {
            Object identifier = collection.getIdentifier(entry, i);
            String[] names = new String[]{this.getIdentifierColumnName()};
            this.identifierGridType.nullSafeSet(tuple, identifier, names, session);
        } else {
            this.getKeyGridType().nullSafeSet(tuple, key, this.getKeyColumnNames(), session);
            if (!this.isOneToMany() && this.hasIndex && !this.indexContainsFormula) {
                Object index = collection.getIndex(entry, i, (CollectionPersister)this);
                this.indexGridType.nullSafeSet(tuple, this.incrementIndexByBase(index), this.getIndexColumnNames(), session);
            } else {
                Object snapshotElement = collection.getSnapshotElement(entry, i);
                if (this.elementIsPureFormula) {
                    throw new AssertionFailure("cannot use a formula-based element in the where condition");
                }
                this.getElementGridType().nullSafeSet(tuple, snapshotElement, this.getElementColumnNames(), session);
            }
        }
        return rowKeyBuilder.values(tuple).build();
    }

    private RowKey getTupleKeyForDelete(Serializable key, PersistentCollection collection, SessionImplementor session, Object entry, boolean findByIndex) {
        RowKeyBuilder rowKeyBuilder = this.initializeRowKeyBuilder();
        Tuple tuple = new Tuple();
        if (this.hasIdentifier) {
            Object identifier = entry;
            String[] names = new String[]{this.getIdentifierColumnName()};
            this.identifierGridType.nullSafeSet(tuple, identifier, names, session);
        } else {
            this.getKeyGridType().nullSafeSet(tuple, key, this.getKeyColumnNames(), session);
            if (findByIndex) {
                Object index = entry;
                this.indexGridType.nullSafeSet(tuple, this.incrementIndexByBase(index), this.getIndexColumnNames(), session);
            } else {
                Object snapshotElement = entry;
                if (this.elementIsPureFormula) {
                    throw new AssertionFailure("cannot use a formula-based element in the where condition");
                }
                this.getElementGridType().nullSafeSet(tuple, snapshotElement, this.getElementColumnNames(), session);
            }
        }
        rowKeyBuilder.values(tuple);
        return rowKeyBuilder.build();
    }

    public int getSize(Serializable key, SessionImplementor session) {
        AssociationPersister associationPersister = new AssociationPersister(this.getOwnerEntityPersister().getMappedClass()).key(key).session(session).gridDialect(this.gridDialect).keyGridType(this.getKeyGridType()).associationKeyMetadata(this.associationKeyMetadata).collectionPersister(this);
        Association collectionMetadata = associationPersister.getAssociationOrNull();
        return collectionMetadata == null ? 0 : collectionMetadata.size();
    }

    public FilterAliasGenerator getFilterAliasGenerator(String rootAlias) {
        return new StaticFilterAliasGenerator(rootAlias);
    }

    public void deleteRows(PersistentCollection collection, Serializable id, SessionImplementor session) throws HibernateException {
        if (!this.isInverse && this.isRowDeleteEnabled()) {
            if (log.isDebugEnabled()) {
                log.debug("Deleting rows of collection: " + MessageHelper.collectionInfoString((CollectionPersister)this, (Serializable)id, (SessionFactoryImplementor)this.getFactory()));
            }
            boolean deleteByIndex = !this.isOneToMany() && this.hasIndex && !this.indexContainsFormula;
            AssociationPersister associationPersister = new AssociationPersister(this.getOwnerEntityPersister().getMappedClass()).hostingEntity(collection.getOwner()).gridDialect(this.gridDialect).key(id).keyGridType(this.getKeyGridType()).associationKeyMetadata(this.associationKeyMetadata).collectionPersister(this).session(session);
            Iterator deletes = collection.getDeletes((CollectionPersister)this, !deleteByIndex);
            if (deletes.hasNext()) {
                int count = 0;
                while (deletes.hasNext()) {
                    Object entry = deletes.next();
                    RowKey assocEntryKey = this.getTupleKeyForDelete(id, collection, session, entry, deleteByIndex);
                    Tuple assocEntryTuple = associationPersister.getAssociation().get(assocEntryKey);
                    if (assocEntryTuple == null) {
                        throw new AssertionFailure("Deleting a collection tuple that is not present: table {" + this.getTableName() + "} collectionKey {" + id + "} entry {" + entry + "}");
                    }
                    this.updateInverseSideOfAssociationNavigation(session, entry, assocEntryTuple, Action.REMOVE, assocEntryKey);
                    associationPersister.getAssociation().remove(assocEntryKey);
                    ++count;
                    if (!log.isDebugEnabled()) continue;
                    log.debug("done deleting collection rows: " + count + " deleted");
                }
                associationPersister.flushToCache();
            } else {
                log.debug("no rows to delete");
            }
        }
    }

    public void insertRows(PersistentCollection collection, Serializable id, SessionImplementor session) throws HibernateException {
        if (!this.isInverse && this.isRowInsertEnabled()) {
            if (log.isDebugEnabled()) {
                log.debug("Inserting rows of collection: " + MessageHelper.collectionInfoString((CollectionPersister)this, (Serializable)id, (SessionFactoryImplementor)this.getFactory()));
            }
            AssociationPersister associationPersister = new AssociationPersister(this.getOwnerEntityPersister().getMappedClass()).hostingEntity(collection.getOwner()).gridDialect(this.gridDialect).key(id).keyGridType(this.getKeyGridType()).associationKeyMetadata(this.associationKeyMetadata).collectionPersister(this).session(session);
            collection.preInsert((CollectionPersister)this);
            Iterator entries = collection.entries((CollectionPersister)this);
            int i = 0;
            int count = 0;
            while (entries.hasNext()) {
                Object entry = entries.next();
                if (collection.needsInserting(entry, i, this.elementType)) {
                    RowKeyAndTuple keyAndTuple = this.createAndPutTupleforInsert(id, collection, associationPersister, session, i, entry);
                    this.completeTuple(keyAndTuple, collection, session, entry);
                    this.updateInverseSideOfAssociationNavigation(session, entry, keyAndTuple.tuple, Action.ADD, keyAndTuple.key);
                    collection.afterRowInsert((CollectionPersister)this, entry, i);
                    ++count;
                }
                ++i;
            }
            associationPersister.flushToCache();
            if (log.isDebugEnabled()) {
                log.debug("done inserting rows: " + count + " inserted");
            }
        }
    }

    public void recreate(PersistentCollection collection, Serializable id, SessionImplementor session) throws HibernateException {
        if (!this.isInverse && this.isRowInsertEnabled()) {
            if (log.isDebugEnabled()) {
                log.debug("Inserting collection: " + MessageHelper.collectionInfoString((CollectionPersister)this, (Serializable)id, (SessionFactoryImplementor)this.getFactory()));
            }
            AssociationPersister associationPersister = new AssociationPersister(this.getOwnerEntityPersister().getMappedClass()).hostingEntity(collection.getOwner()).gridDialect(this.gridDialect).key(id).keyGridType(this.getKeyGridType()).associationKeyMetadata(this.associationKeyMetadata).collectionPersister(this).session(session);
            Iterator entries = collection.entries((CollectionPersister)this);
            if (entries.hasNext()) {
                collection.preInsert((CollectionPersister)this);
                int i = 0;
                int count = 0;
                while (entries.hasNext()) {
                    Object entry = entries.next();
                    if (collection.entryExists(entry, i)) {
                        RowKeyAndTuple keyAndTuple = this.createAndPutTupleforInsert(id, collection, associationPersister, session, i, entry);
                        this.completeTuple(keyAndTuple, collection, session, entry);
                        this.updateInverseSideOfAssociationNavigation(session, entry, keyAndTuple.tuple, Action.ADD, keyAndTuple.key);
                        collection.afterRowInsert((CollectionPersister)this, entry, i);
                        ++count;
                    }
                    ++i;
                }
                associationPersister.flushToCache();
                if (log.isDebugEnabled()) {
                    log.debug("done inserting collection: " + count + " rows inserted");
                }
            } else if (log.isDebugEnabled()) {
                log.debug("collection was empty");
            }
        }
    }

    private void updateInverseSideOfAssociationNavigation(SessionImplementor session, Object entity, Tuple tuple, Action action, RowKey rowKey) {
        if (this.associationType == AssociationType.EMBEDDED_FK_TO_ENTITY) {
            Serializable entityId = (Serializable)this.gridTypeOfAssociatedId.nullSafeGet(tuple, this.getElementColumnNames(), session, null);
            OgmEntityPersister persister = (OgmEntityPersister)this.getElementPersister();
            EntityKey entityKey = EntityKeyBuilder.fromPersister(persister, entityId, session);
            Tuple entityTuple = this.gridDialect.getTuple(entityKey, persister.getTupleContext());
            if (entityTuple == null) {
                return;
            }
            if (action == Action.ADD) {
                for (String columnName : tuple.getColumnNames()) {
                    entityTuple.put(columnName, tuple.get(columnName));
                }
            } else if (action == Action.REMOVE) {
                if (this.hasIdentifier) {
                    throw new AssertionFailure("A true OneToMany with an identifier for the collection: " + this.getRole());
                }
                if (this.hasIndex) {
                    this.indexGridType.nullSafeSet(entityTuple, null, this.getIndexColumnNames(), session);
                }
                this.keyGridType.nullSafeSet(entityTuple, null, this.getKeyColumnNames(), session);
            } else {
                throw new AssertionFailure("Unknown action type: " + (Object)((Object)action));
            }
            this.gridDialect.updateTuple(entityTuple, entityKey, persister.getTupleContext());
        } else if (this.associationType == AssociationType.ASSOCIATION_TABLE_TO_ENTITY) {
            Object[] elementColumnNames = this.getElementColumnNames();
            Object[] elementColumnValues = LogicalPhysicalConverterHelper.getColumnValuesFromResultset(tuple, (String[])elementColumnNames);
            Serializable entityId = (Serializable)this.gridTypeOfAssociatedId.nullSafeGet(tuple, this.getElementColumnNames(), session, null);
            AssociationPersister associationPersister = new AssociationPersister(this.getElementPersister().getMappedClass()).gridDialect(this.gridDialect).keyColumnValues(elementColumnValues).session(session).associationKeyMetadata(this.associationKeyMetadataFromElement).collectionPersister(this).key(entityId).inverse();
            if (action == Action.ADD) {
                Tuple assocTuple = associationPersister.createAndPutAssociationTuple(rowKey);
                for (String columnName : tuple.getColumnNames()) {
                    assocTuple.put(columnName, tuple.get(columnName));
                }
                associationPersister.getAssociation().put(rowKey, assocTuple);
            } else if (action == Action.REMOVE) {
                if (rowKey == null) {
                    throw new AssertionFailure("Deleting a collection tuple that is not present: table {" + this.getTableName() + "} key column names {" + Arrays.toString(elementColumnNames) + "} key column values {" + Arrays.toString(elementColumnValues) + "}");
                }
                associationPersister.getAssociation().remove(rowKey);
            } else {
                throw new AssertionFailure("Unknown action type: " + (Object)((Object)action));
            }
            if (associationPersister.hostingEntityRequiresReadAfterUpdate() && entity == null) {
                entity = session.getPersistenceContext().getEntity(session.generateEntityKey(entityId, this.getElementPersister()));
            }
            associationPersister.hostingEntity(entity);
            associationPersister.flushToCache();
        }
    }

    public void remove(Serializable id, SessionImplementor session) throws HibernateException {
        if (!this.isInverse && this.isRowDeleteEnabled()) {
            AssociationPersister associationPersister;
            Association association;
            if (log.isDebugEnabled()) {
                log.debug("Deleting collection: " + MessageHelper.collectionInfoString((CollectionPersister)this, (Serializable)id, (SessionFactoryImplementor)this.getFactory()));
            }
            if ((association = (associationPersister = new AssociationPersister(this.getOwnerEntityPersister().getMappedClass()).gridDialect(this.gridDialect).key(id).keyGridType(this.getKeyGridType()).associationKeyMetadata(this.associationKeyMetadata).collectionPersister(this).session(session)).getAssociationOrNull()) != null) {
                if (this.associationType != AssociationType.OTHER) {
                    for (RowKey assocEntryKey : association.getKeys()) {
                        this.updateInverseSideOfAssociationNavigation(session, null, association.get(assocEntryKey), Action.REMOVE, assocEntryKey);
                    }
                }
                association.clear();
                if (associationPersister.hostingEntityRequiresReadAfterUpdate()) {
                    Object owner = session.getPersistenceContext().getCollectionOwner(id, (CollectionPersister)this);
                    associationPersister.hostingEntity(owner);
                }
                associationPersister.flushToCache();
            }
            if (log.isDebugEnabled()) {
                log.debug("done deleting collection");
            }
        }
    }

    public String selectFragment(Joinable rhs, String rhsAlias, String lhsAlias, String currentEntitySuffix, String currentCollectionSuffix, boolean includeCollectionColumns) {
        return null;
    }

    public String whereJoinFragment(String alias, boolean innerJoin, boolean includeSubclasses) {
        return null;
    }

    public String fromJoinFragment(String alias, boolean innerJoin, boolean includeSubclasses) {
        return null;
    }

    public boolean consumesEntityAlias() {
        return false;
    }

    public boolean consumesCollectionAlias() {
        return false;
    }

    protected void logStaticSQL() {
        if (log.isDebugEnabled()) {
            log.debug("No SQL used when using OGM: " + this.getRole());
        }
    }

    public void postInstantiate() throws MappingException {
    }

    protected CollectionInitializer getAppropriateInitializer(Serializable key, SessionImplementor session) {
        return this.createCollectionInitializer(session.getLoadQueryInfluencers());
    }

    protected void doProcessQueuedOps(PersistentCollection collection, Serializable key, SessionImplementor session) throws HibernateException {
    }

    public String whereJoinFragment(String alias, boolean innerJoin, boolean includeSubclasses, Set<String> treatAsDeclarations) {
        return null;
    }

    public String fromJoinFragment(String alias, boolean innerJoin, boolean includeSubclasses, Set<String> treatAsDeclarations) {
        return null;
    }

    private static enum Action {
        ADD,
        REMOVE;

    }

    private static class RowKeyAndTuple {
        RowKey key;
        Tuple tuple;

        private RowKeyAndTuple() {
        }
    }

    private static enum AssociationType {
        EMBEDDED_FK_TO_ENTITY,
        ASSOCIATION_TABLE_TO_ENTITY,
        OTHER;

    }
}

