/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.type.descriptor;

import org.hibernate.ogm.datastore.spi.Tuple;
import org.hibernate.ogm.type.descriptor.GridValueExtractor;
import org.hibernate.ogm.util.impl.Log;
import org.hibernate.ogm.util.impl.LoggerFactory;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;

public final class BasicGridExtractor<J>
implements GridValueExtractor<J> {
    private static final Log log = LoggerFactory.make();
    private final JavaTypeDescriptor<J> javaTypeDescriptor;
    private final boolean wrap;

    public BasicGridExtractor(JavaTypeDescriptor<J> javaTypeDescriptor, boolean wrap) {
        this.javaTypeDescriptor = javaTypeDescriptor;
        this.wrap = wrap;
    }

    @Override
    public J extract(Tuple resultset, String name) {
        Object result = resultset.get(name);
        if (result == null) {
            log.tracef("found [null] as column [%s]", name);
            return null;
        }
        if (log.isTraceEnabled()) {
            log.tracef("found [%1$s] as column [%2$s]", this.javaTypeDescriptor.extractLoggableRepresentation(result), name);
        }
        return (J)(this.wrap ? this.javaTypeDescriptor.wrap(result, null) : result);
    }
}

