/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.type.impl;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.ogm.dialect.GridDialect;
import org.hibernate.ogm.type.BigDecimalType;
import org.hibernate.ogm.type.BigIntegerType;
import org.hibernate.ogm.type.BooleanType;
import org.hibernate.ogm.type.ByteType;
import org.hibernate.ogm.type.CalendarDateType;
import org.hibernate.ogm.type.CalendarType;
import org.hibernate.ogm.type.ClassType;
import org.hibernate.ogm.type.CollectionType;
import org.hibernate.ogm.type.ComponentType;
import org.hibernate.ogm.type.DateType;
import org.hibernate.ogm.type.DoubleType;
import org.hibernate.ogm.type.EnumType;
import org.hibernate.ogm.type.GridType;
import org.hibernate.ogm.type.IntegerType;
import org.hibernate.ogm.type.LongType;
import org.hibernate.ogm.type.ManyToOneType;
import org.hibernate.ogm.type.OneToOneType;
import org.hibernate.ogm.type.PrimitiveByteArrayType;
import org.hibernate.ogm.type.StringType;
import org.hibernate.ogm.type.TimeType;
import org.hibernate.ogm.type.TimestampType;
import org.hibernate.ogm.type.TypeTranslator;
import org.hibernate.ogm.type.UUIDType;
import org.hibernate.ogm.type.UrlType;
import org.hibernate.type.AbstractStandardBasicType;
import org.hibernate.type.CustomType;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.java.BigDecimalTypeDescriptor;
import org.hibernate.type.descriptor.java.BigIntegerTypeDescriptor;
import org.hibernate.type.descriptor.java.BooleanTypeDescriptor;
import org.hibernate.type.descriptor.java.ByteTypeDescriptor;
import org.hibernate.type.descriptor.java.CalendarDateTypeDescriptor;
import org.hibernate.type.descriptor.java.CalendarTypeDescriptor;
import org.hibernate.type.descriptor.java.ClassTypeDescriptor;
import org.hibernate.type.descriptor.java.DoubleTypeDescriptor;
import org.hibernate.type.descriptor.java.IntegerTypeDescriptor;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.java.JdbcDateTypeDescriptor;
import org.hibernate.type.descriptor.java.JdbcTimeTypeDescriptor;
import org.hibernate.type.descriptor.java.JdbcTimestampTypeDescriptor;
import org.hibernate.type.descriptor.java.LongTypeDescriptor;
import org.hibernate.type.descriptor.java.PrimitiveByteArrayTypeDescriptor;
import org.hibernate.type.descriptor.java.StringTypeDescriptor;
import org.hibernate.type.descriptor.java.UUIDTypeDescriptor;
import org.hibernate.type.descriptor.java.UrlTypeDescriptor;
import org.hibernate.usertype.UserType;

public class TypeTranslatorImpl
implements TypeTranslator {
    private final Map<JavaTypeDescriptor, GridType> typeConverter;
    private final GridDialect dialect;

    public TypeTranslatorImpl(GridDialect dialect) {
        this.dialect = dialect;
        this.typeConverter = new HashMap<JavaTypeDescriptor, GridType>();
        this.typeConverter.put((JavaTypeDescriptor)ClassTypeDescriptor.INSTANCE, ClassType.INSTANCE);
        this.typeConverter.put((JavaTypeDescriptor)LongTypeDescriptor.INSTANCE, LongType.INSTANCE);
        this.typeConverter.put((JavaTypeDescriptor)IntegerTypeDescriptor.INSTANCE, IntegerType.INSTANCE);
        this.typeConverter.put((JavaTypeDescriptor)DoubleTypeDescriptor.INSTANCE, DoubleType.INSTANCE);
        this.typeConverter.put((JavaTypeDescriptor)StringTypeDescriptor.INSTANCE, StringType.INSTANCE);
        this.typeConverter.put((JavaTypeDescriptor)UrlTypeDescriptor.INSTANCE, UrlType.INSTANCE);
        this.typeConverter.put((JavaTypeDescriptor)BigDecimalTypeDescriptor.INSTANCE, BigDecimalType.INSTANCE);
        this.typeConverter.put((JavaTypeDescriptor)BigIntegerTypeDescriptor.INSTANCE, BigIntegerType.INSTANCE);
        this.typeConverter.put((JavaTypeDescriptor)BooleanTypeDescriptor.INSTANCE, BooleanType.INSTANCE);
        this.typeConverter.put((JavaTypeDescriptor)ByteTypeDescriptor.INSTANCE, ByteType.INSTANCE);
        this.typeConverter.put((JavaTypeDescriptor)JdbcDateTypeDescriptor.INSTANCE, DateType.INSTANCE);
        this.typeConverter.put((JavaTypeDescriptor)JdbcTimestampTypeDescriptor.INSTANCE, TimestampType.INSTANCE);
        this.typeConverter.put((JavaTypeDescriptor)JdbcTimeTypeDescriptor.INSTANCE, TimeType.INSTANCE);
        this.typeConverter.put((JavaTypeDescriptor)CalendarDateTypeDescriptor.INSTANCE, CalendarDateType.INSTANCE);
        this.typeConverter.put((JavaTypeDescriptor)CalendarTypeDescriptor.INSTANCE, CalendarType.INSTANCE);
        this.typeConverter.put((JavaTypeDescriptor)PrimitiveByteArrayTypeDescriptor.INSTANCE, PrimitiveByteArrayType.INSTANCE);
        this.typeConverter.put((JavaTypeDescriptor)UUIDTypeDescriptor.INSTANCE, UUIDType.INSTANCE);
    }

    @Override
    public GridType getType(Type type) {
        if (type == null) {
            return null;
        }
        GridType dialectType = this.dialect.overrideType(type);
        if (dialectType != null) {
            return dialectType;
        }
        if (type instanceof AbstractStandardBasicType) {
            AbstractStandardBasicType exposedType = (AbstractStandardBasicType)type;
            GridType gridType = this.typeConverter.get(exposedType.getJavaTypeDescriptor());
            if (gridType == null) {
                throw new HibernateException("Unable to find a GridType for " + exposedType.getClass().getName());
            }
            return gridType;
        }
        if (type instanceof CustomType) {
            CustomType cType = (CustomType)type;
            UserType userType = cType.getUserType();
            if (userType instanceof org.hibernate.type.EnumType) {
                org.hibernate.type.EnumType enumType = (org.hibernate.type.EnumType)userType;
                return new EnumType(cType, enumType);
            }
        } else {
            if (type instanceof org.hibernate.type.ComponentType) {
                org.hibernate.type.ComponentType componentType = (org.hibernate.type.ComponentType)type;
                return new ComponentType(componentType, this);
            }
            if (type instanceof org.hibernate.type.ManyToOneType) {
                org.hibernate.type.ManyToOneType manyToOneType = (org.hibernate.type.ManyToOneType)type;
                return new ManyToOneType(manyToOneType, this);
            }
            if (type instanceof org.hibernate.type.OneToOneType) {
                org.hibernate.type.OneToOneType oneToOneType = (org.hibernate.type.OneToOneType)type;
                return new OneToOneType(oneToOneType, this);
            }
            if (type instanceof org.hibernate.type.CollectionType) {
                return new CollectionType((org.hibernate.type.CollectionType)type);
            }
        }
        throw new HibernateException("Unable to find a GridType for " + type.getClass().getName());
    }
}

