/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j.dialect.impl;

import java.util.HashSet;
import java.util.Set;
import org.hibernate.ogm.datastore.neo4j.dialect.impl.Neo4jTupleSnapshot;
import org.hibernate.ogm.datastore.spi.AssociationSnapshot;
import org.hibernate.ogm.datastore.spi.Tuple;
import org.hibernate.ogm.datastore.spi.TupleSnapshot;
import org.hibernate.ogm.grid.AssociationKey;
import org.hibernate.ogm.grid.RowKey;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;

public final class Neo4jAssociationSnapshot
implements AssociationSnapshot {
    private final Node ownerNode;
    private final RelationshipType relationshipType;
    private final AssociationKey associationKey;

    public Neo4jAssociationSnapshot(Node ownerNode, RelationshipType type, AssociationKey associationKey) {
        this.ownerNode = ownerNode;
        this.relationshipType = type;
        this.associationKey = associationKey;
    }

    public Tuple get(RowKey rowKey) {
        for (Relationship relationship : this.relationships()) {
            if (!this.matches(rowKey, (PropertyContainer)relationship)) continue;
            return new Tuple((TupleSnapshot)new Neo4jTupleSnapshot((PropertyContainer)relationship.getEndNode()));
        }
        return null;
    }

    public boolean containsKey(RowKey rowKey) {
        for (Relationship relationship : this.relationships()) {
            if (!this.matches(rowKey, (PropertyContainer)relationship)) continue;
            return true;
        }
        return false;
    }

    private boolean matches(RowKey key, PropertyContainer container) {
        for (int i = 0; i < key.getColumnNames().length; ++i) {
            if (this.columnValueMatches(key.getColumnNames()[i], key.getColumnValues()[i], container)) continue;
            return false;
        }
        return true;
    }

    private boolean columnValueMatches(String columnName, Object columnValue, PropertyContainer container) {
        if (container.hasProperty(columnName)) {
            return container.getProperty(columnName).equals(columnValue);
        }
        return columnValue == null;
    }

    public int size() {
        int count = 0;
        for (Relationship relationship : this.relationships()) {
            ++count;
        }
        return count;
    }

    private Iterable<Relationship> relationships() {
        return this.ownerNode.getRelationships(Direction.OUTGOING, new RelationshipType[]{this.relationshipType});
    }

    public Set<RowKey> getRowKeys() {
        HashSet<RowKey> rowKeys = new HashSet<RowKey>();
        for (Relationship relationship : this.relationships()) {
            rowKeys.add(this.convert((PropertyContainer)relationship));
        }
        return rowKeys;
    }

    private RowKey convert(PropertyContainer container) {
        String[] columnNames = this.associationKey.getRowKeyColumnNames();
        Object[] values = new Object[columnNames.length];
        for (int i = 0; i < columnNames.length; ++i) {
            String columnName = columnNames[i];
            if (!container.hasProperty(columnName)) continue;
            values[i] = container.getProperty(columnName);
        }
        return new RowKey(this.associationKey.getTable(), columnNames, values);
    }
}

