/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl.path;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.neo4j.graphalgo.CostEvaluator;
import org.neo4j.graphalgo.EstimateEvaluator;
import org.neo4j.graphalgo.PathFinder;
import org.neo4j.graphalgo.WeightedPath;
import org.neo4j.graphalgo.impl.util.PathImpl;
import org.neo4j.graphalgo.impl.util.WeightedPathImpl;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PathExpander;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipExpander;
import org.neo4j.graphdb.traversal.BranchState;
import org.neo4j.graphdb.traversal.TraversalMetadata;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.kernel.StandardExpander;

public class AStar
implements PathFinder<WeightedPath> {
    private final PathExpander<?> expander;
    private final CostEvaluator<Double> lengthEvaluator;
    private final EstimateEvaluator<Double> estimateEvaluator;
    private Metadata lastMetadata;

    public AStar(RelationshipExpander expander, CostEvaluator<Double> lengthEvaluator, EstimateEvaluator<Double> estimateEvaluator) {
        this(StandardExpander.toPathExpander((RelationshipExpander)expander), lengthEvaluator, estimateEvaluator);
    }

    public AStar(PathExpander<?> expander, CostEvaluator<Double> lengthEvaluator, EstimateEvaluator<Double> estimateEvaluator) {
        this.expander = expander;
        this.lengthEvaluator = lengthEvaluator;
        this.estimateEvaluator = estimateEvaluator;
    }

    @Override
    public WeightedPath findSinglePath(Node start, Node end) {
        this.lastMetadata = new Metadata();
        Doer doer = new Doer(start, end);
        while (doer.hasNext()) {
            Node node = (Node)doer.next();
            GraphDatabaseService graphDb = node.getGraphDatabase();
            if (!node.equals(end)) continue;
            double weight = ((Data)doer.score.get(node.getId())).wayLength;
            LinkedList<Relationship> rels = new LinkedList<Relationship>();
            Relationship rel = graphDb.getRelationshipById(((Long)doer.cameFrom.get(node.getId())).longValue());
            while (rel != null) {
                rels.addFirst(rel);
                node = rel.getOtherNode(node);
                Long nextRelId = (Long)doer.cameFrom.get(node.getId());
                rel = nextRelId == null ? null : graphDb.getRelationshipById(nextRelId.longValue());
            }
            Path path = this.toPath(start, rels);
            this.lastMetadata.paths++;
            return new WeightedPathImpl(weight, path);
        }
        return null;
    }

    @Override
    public Iterable<WeightedPath> findAllPaths(Node node, Node end) {
        WeightedPath path = this.findSinglePath(node, end);
        return path != null ? Arrays.asList(path) : Collections.emptyList();
    }

    @Override
    public TraversalMetadata metadata() {
        return this.lastMetadata;
    }

    private Path toPath(Node start, LinkedList<Relationship> rels) {
        PathImpl.Builder builder = new PathImpl.Builder(start);
        for (Relationship rel : rels) {
            builder = builder.push(rel);
        }
        return builder.build();
    }

    private static class Metadata
    implements TraversalMetadata {
        private int rels;
        private int paths;

        private Metadata() {
        }

        public int getNumberOfPathsReturned() {
            return this.paths;
        }

        public int getNumberOfRelationshipsTraversed() {
            return this.rels;
        }
    }

    private class Doer
    extends PrefetchingIterator<Node>
    implements Path {
        private final Node end;
        private Node lastNode;
        private boolean expand;
        private final Set<Long> visitedNodes = new HashSet<Long>();
        private final Set<Node> nextNodesSet = new HashSet<Node>();
        private final TreeMap<Double, Collection<Node>> nextNodes = new TreeMap();
        private final Map<Long, Long> cameFrom = new HashMap<Long, Long>();
        private final Map<Long, Data> score = new HashMap<Long, Data>();
        private final Node start;

        Doer(Node start, Node end) {
            this.start = start;
            this.end = end;
            Data data = new Data();
            data.wayLength = 0.0;
            data.estimate = (Double)AStar.this.estimateEvaluator.getCost(start, end);
            this.addNext(start, data.getFscore());
            this.score.put(start.getId(), data);
        }

        private void addNext(Node node, double fscore) {
            Collection<Node> nodes = this.nextNodes.get(fscore);
            if (nodes == null) {
                nodes = new HashSet<Node>();
                this.nextNodes.put(fscore, nodes);
            }
            nodes.add(node);
            this.nextNodesSet.add(node);
        }

        private Node popLowestScoreNode() {
            Node node;
            Iterator<Map.Entry<Double, Collection<Node>>> itr = this.nextNodes.entrySet().iterator();
            if (!itr.hasNext()) {
                return null;
            }
            Map.Entry<Double, Collection<Node>> entry = itr.next();
            Node node2 = node = entry.getValue().isEmpty() ? null : entry.getValue().iterator().next();
            if (node == null) {
                return null;
            }
            if (node != null) {
                entry.getValue().remove(node);
                this.nextNodesSet.remove(node);
                if (entry.getValue().isEmpty()) {
                    this.nextNodes.remove(entry.getKey());
                }
                this.visitedNodes.add(node.getId());
            }
            return node;
        }

        protected Node fetchNextOrNull() {
            Node node;
            if (!this.expand) {
                this.expand = true;
            } else {
                this.expand();
            }
            this.lastNode = node = this.popLowestScoreNode();
            return node;
        }

        private void expand() {
            for (Relationship rel : AStar.this.expander.expand((Path)this, BranchState.NO_STATE)) {
                AStar.this.lastMetadata.rels++;
                Node node = rel.getOtherNode(this.lastNode);
                if (this.visitedNodes.contains(node.getId())) continue;
                Data lastNodeData = this.score.get(this.lastNode.getId());
                double tentativeGScore = lastNodeData.wayLength + (Double)AStar.this.lengthEvaluator.getCost(rel, Direction.OUTGOING);
                boolean isBetter = false;
                double estimate = (Double)AStar.this.estimateEvaluator.getCost(node, this.end);
                if (!this.nextNodesSet.contains(node)) {
                    this.addNext(node, estimate + tentativeGScore);
                    isBetter = true;
                } else if (tentativeGScore < this.score.get(node.getId()).wayLength) {
                    isBetter = true;
                }
                if (!isBetter) continue;
                this.cameFrom.put(node.getId(), rel.getId());
                Data data = new Data();
                data.wayLength = tentativeGScore;
                data.estimate = estimate;
                this.score.put(node.getId(), data);
            }
        }

        public Node startNode() {
            return this.start;
        }

        public Node endNode() {
            return this.lastNode;
        }

        public Relationship lastRelationship() {
            throw new UnsupportedOperationException();
        }

        public Iterable<Relationship> relationships() {
            throw new UnsupportedOperationException();
        }

        public Iterable<Relationship> reverseRelationships() {
            throw new UnsupportedOperationException();
        }

        public Iterable<Node> nodes() {
            throw new UnsupportedOperationException();
        }

        public Iterable<Node> reverseNodes() {
            throw new UnsupportedOperationException();
        }

        public int length() {
            throw new UnsupportedOperationException();
        }

        public Iterator<PropertyContainer> iterator() {
            throw new UnsupportedOperationException();
        }
    }

    private static class Data {
        private double wayLength;
        private double estimate;

        private Data() {
        }

        double getFscore() {
            return this.wayLength + this.estimate;
        }
    }
}

