/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.distribution;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.infinispan.atomic.DeltaCompositeKey;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.util.InfinispanCollections;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.LocalTxInvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.annotations.Start;
import org.infinispan.interceptors.distribution.BaseDistributionInterceptor;
import org.infinispan.remoting.rpc.ResponseMode;
import org.infinispan.remoting.rpc.RpcOptions;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.jgroups.SuspectException;
import org.infinispan.transaction.LocalTransaction;
import org.infinispan.transaction.LockingMode;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class TxDistributionInterceptor
extends BaseDistributionInterceptor {
    private static Log log = LogFactory.getLog(TxDistributionInterceptor.class);
    private static final boolean trace = log.isTraceEnabled();
    private boolean isPessimisticCache;
    private boolean useClusteredWriteSkewCheck;
    private static final BaseDistributionInterceptor.RecipientGenerator CLEAR_COMMAND_GENERATOR = new BaseDistributionInterceptor.RecipientGenerator(){

        @Override
        public List<Address> generateRecipients() {
            return null;
        }

        @Override
        public Collection<Object> getKeys() {
            return InfinispanCollections.emptySet();
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        try {
            Object object = this.handleTxWriteCommand(ctx, command, new BaseDistributionInterceptor.SingleKeyRecipientGenerator(command.getKey()), false);
            return object;
        }
        finally {
            if (this.ignorePreviousValueOnBackup(command, ctx)) {
                command.setIgnorePreviousValue(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        try {
            Object object = this.handleTxWriteCommand(ctx, command, new BaseDistributionInterceptor.SingleKeyRecipientGenerator(command.getKey()), false);
            return object;
        }
        finally {
            if (this.ignorePreviousValueOnBackup(command, ctx)) {
                command.setIgnorePreviousValue(true);
            }
        }
    }

    @Start
    public void start() {
        this.isPessimisticCache = this.cacheConfiguration.transaction().lockingMode() == LockingMode.PESSIMISTIC;
        this.useClusteredWriteSkewCheck = !this.isPessimisticCache && this.cacheConfiguration.versioning().enabled() && this.cacheConfiguration.locking().writeSkewCheck();
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        if (command.hasFlag(Flag.PUT_FOR_EXTERNAL_READ)) {
            return this.handleNonTxWriteCommand(ctx, command);
        }
        BaseDistributionInterceptor.SingleKeyRecipientGenerator skrg = new BaseDistributionInterceptor.SingleKeyRecipientGenerator(command.getKey());
        Object returnValue = this.handleTxWriteCommand(ctx, command, skrg, command.hasFlag(Flag.PUT_FOR_STATE_TRANSFER));
        if (this.ignorePreviousValueOnBackup(command, ctx)) {
            command.setIgnorePreviousValue(true);
            command.setPutIfAbsent(false);
        }
        return returnValue;
    }

    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        return this.handleTxWriteCommand(ctx, command, new BaseDistributionInterceptor.MultipleKeysRecipientGenerator(command.getMap().keySet()), true);
    }

    @Override
    public Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
        return this.handleTxWriteCommand(ctx, command, CLEAR_COMMAND_GENERATOR, false);
    }

    @Override
    public Object visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
        return this.visitGetCommand(ctx, command, false);
    }

    private Object visitGetCommand(InvocationContext ctx, GetKeyValueCommand command, boolean isGetCacheEntry) throws Throwable {
        try {
            boolean skipRemoteGet;
            Object returnValue = this.invokeNextInterceptor(ctx, command);
            CacheEntry entry = ctx.lookupEntry(command.getKey());
            boolean bl = skipRemoteGet = entry != null && entry.skipRemoteGet();
            if (!skipRemoteGet && returnValue == null && ctx.isOriginLocal()) {
                InternalCacheEntry ice;
                Object key = command.getKey();
                if (this.needsRemoteGet(ctx, command) && (ice = this.remoteGet(ctx, key, false, command)) != null) {
                    returnValue = ice.getValue();
                }
                if (returnValue == null && !ctx.isEntryRemovedInContext(command.getKey())) {
                    returnValue = this.localGet(ctx, key, false, command, isGetCacheEntry);
                }
            }
            return returnValue;
        }
        catch (SuspectException e) {
            return this.visitGetKeyValueCommand(ctx, command);
        }
    }

    protected void lockAndWrap(InvocationContext ctx, Object key, InternalCacheEntry ice, FlagAffectedCommand command) throws InterruptedException {
        boolean skipLocking = this.hasSkipLocking(command);
        long lockTimeout = this.getLockAcquisitionTimeout(command, skipLocking);
        this.lockManager.acquireLock(ctx, key, lockTimeout, skipLocking);
        this.entryFactory.wrapEntryForPut(ctx, key, ice, false, command, false);
    }

    @Override
    public Object visitLockControlCommand(TxInvocationContext ctx, LockControlCommand command) throws Throwable {
        if (ctx.isOriginLocal()) {
            ArrayList<Object> keyToCheckOwners = new ArrayList<Object>(command.getKeys().size());
            for (Object key : command.getKeys()) {
                if (key instanceof DeltaCompositeKey) {
                    keyToCheckOwners.add(((DeltaCompositeKey)key).getDeltaAwareValueKey());
                    continue;
                }
                keyToCheckOwners.add(key);
            }
            List<Address> affectedNodes = this.cdl.getOwners(keyToCheckOwners);
            ((LocalTxInvocationContext)ctx).remoteLocksAcquired(affectedNodes == null ? this.dm.getConsistentHash().getMembers() : affectedNodes);
            log.tracef("Registered remote locks acquired %s", affectedNodes);
            this.rpcManager.invokeRemotely(affectedNodes, (ReplicableCommand)command, this.rpcManager.getDefaultRpcOptions(true, false));
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
        if (this.shouldInvokeRemoteTxCommand(ctx)) {
            this.sendCommitCommand(ctx, command);
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        Object retVal = this.invokeNextInterceptor(ctx, command);
        if (this.shouldInvokeRemoteTxCommand(ctx)) {
            boolean affectsAllNodes = ctx.getCacheTransaction().hasModification(ClearCommand.class);
            List<Address> recipients = affectsAllNodes ? this.dm.getWriteConsistentHash().getMembers() : this.cdl.getOwners(ctx.getAffectedKeys());
            recipients = recipients == null ? this.dm.getWriteConsistentHash().getMembers() : recipients;
            this.prepareOnAffectedNodes(ctx, command, recipients, this.defaultSynchronous);
            ((LocalTxInvocationContext)ctx).remoteLocksAcquired(recipients == null ? this.dm.getWriteConsistentHash().getMembers() : recipients);
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void prepareOnAffectedNodes(TxInvocationContext ctx, PrepareCommand command, Collection<Address> recipients, boolean sync) {
        try {
            RpcOptions rpcOptions = sync && command.isOnePhaseCommit() ? this.rpcManager.getRpcOptionsBuilder(ResponseMode.SYNCHRONOUS_IGNORE_LEAVERS, false).build() : this.rpcManager.getDefaultRpcOptions(sync);
            this.rpcManager.invokeRemotely(recipients, (ReplicableCommand)command, rpcOptions);
        }
        finally {
            TxDistributionInterceptor.transactionRemotelyPrepared(ctx);
        }
    }

    @Override
    public Object visitRollbackCommand(TxInvocationContext ctx, RollbackCommand command) throws Throwable {
        if (this.shouldInvokeRemoteTxCommand(ctx)) {
            this.rpcManager.invokeRemotely(this.getCommitNodes(ctx), (ReplicableCommand)command, this.rpcManager.getDefaultRpcOptions(this.cacheConfiguration.transaction().syncRollbackPhase(), false));
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    private Collection<Address> getCommitNodes(TxInvocationContext ctx) {
        LocalTransaction localTx = (LocalTransaction)ctx.getCacheTransaction();
        List<Address> affectedNodes = this.cdl.getOwners(ctx.getAffectedKeys());
        List<Address> members = this.dm.getConsistentHash().getMembers();
        return localTx.getCommitNodes(affectedNodes, this.rpcManager.getTopologyId(), members);
    }

    private void sendCommitCommand(TxInvocationContext ctx, CommitCommand command) throws TimeoutException, InterruptedException {
        Collection<Address> recipients = this.getCommitNodes(ctx);
        boolean syncCommitPhase = this.cacheConfiguration.transaction().syncCommitPhase();
        RpcOptions rpcOptions = syncCommitPhase ? this.rpcManager.getRpcOptionsBuilder(ResponseMode.SYNCHRONOUS_IGNORE_LEAVERS, false).build() : this.rpcManager.getDefaultRpcOptions(false, false);
        this.rpcManager.invokeRemotely(recipients, (ReplicableCommand)command, rpcOptions);
    }

    private boolean shouldFetchRemoteValuesForWriteSkewCheck(InvocationContext ctx, WriteCommand cmd) {
        if (this.useClusteredWriteSkewCheck && ctx.isInTxScope() && this.dm.isRehashInProgress()) {
            for (Object key : cmd.getAffectedKeys()) {
                if (!this.dm.isAffectedByRehash(key) || this.dataContainer.containsKey(key)) continue;
                return true;
            }
        }
        return false;
    }

    private Object handleTxWriteCommand(InvocationContext ctx, WriteCommand command, BaseDistributionInterceptor.RecipientGenerator recipientGenerator, boolean skipRemoteGet) throws Throwable {
        if (ctx.isOriginLocal() && !skipRemoteGet || command.isConditional() || this.shouldFetchRemoteValuesForWriteSkewCheck(ctx, command)) {
            this.remoteGetBeforeWrite(ctx, command, recipientGenerator);
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    private Object localGet(InvocationContext ctx, Object key, boolean isWrite, FlagAffectedCommand command, boolean isGetCacheEntry) throws Throwable {
        InternalCacheEntry ice = this.dataContainer.get(key);
        if (ice != null) {
            if (isWrite && this.isPessimisticCache && ctx.isInTxScope()) {
                ((TxInvocationContext)ctx).addAffectedKey(key);
            }
            if (!ctx.replaceValue(key, ice)) {
                if (isWrite) {
                    this.lockAndWrap(ctx, key, ice, command);
                } else {
                    ctx.putLookedUpEntry(key, ice);
                }
            }
            return isGetCacheEntry ? ice : ice.getValue();
        }
        return null;
    }

    @Override
    protected void remoteGetBeforeWrite(InvocationContext ctx, WriteCommand command, BaseDistributionInterceptor.RecipientGenerator keygen) throws Throwable {
        if ((this.isNeedReliableReturnValues(command) || command.isConditional()) && !command.isIgnorePreviousValue() || this.shouldFetchRemoteValuesForWriteSkewCheck(ctx, command)) {
            for (Object k : keygen.getKeys()) {
                InternalCacheEntry ice;
                CacheEntry entry = ctx.lookupEntry(k);
                boolean skipRemoteGet = entry != null && entry.skipRemoteGet();
                if (skipRemoteGet || (ice = this.remoteGet(ctx, k, true, command)) != null) continue;
                this.localGet(ctx, k, true, command, false);
            }
        }
    }

    private InternalCacheEntry remoteGet(InvocationContext ctx, Object key, boolean isWrite, FlagAffectedCommand command) throws Throwable {
        if (ctx.isOriginLocal() && !this.isValueAvailableLocally(this.dm.getReadConsistentHash(), key) || this.dm.isAffectedByRehash(key) && !this.dataContainer.containsKey(key)) {
            if (trace) {
                log.tracef("Doing a remote get for key %s", key);
            }
            boolean acquireRemoteLock = false;
            if (ctx.isInTxScope()) {
                TxInvocationContext txContext = (TxInvocationContext)ctx;
                acquireRemoteLock = isWrite && this.isPessimisticCache && !txContext.getAffectedKeys().contains(key);
            }
            InternalCacheEntry ice = this.retrieveFromRemoteSource(key, ctx, acquireRemoteLock, command, isWrite);
            if (acquireRemoteLock) {
                ((TxInvocationContext)ctx).addAffectedKey(key);
            }
            if (ice != null) {
                if (this.useClusteredWriteSkewCheck && ctx.isInTxScope()) {
                    ((TxInvocationContext)ctx).getCacheTransaction().putLookedUpRemoteVersion(key, ice.getMetadata().version());
                }
                if (!ctx.replaceValue(key, ice)) {
                    if (isWrite) {
                        this.lockAndWrap(ctx, key, ice, command);
                    } else {
                        ctx.putLookedUpEntry(key, ice);
                        if (ctx.isInTxScope()) {
                            ((TxInvocationContext)ctx).getCacheTransaction().replaceVersionRead(key, ice.getMetadata().version());
                        }
                    }
                }
                return ice;
            }
        } else if (trace) {
            log.tracef("Not doing a remote get for key %s since entry is mapped to current node (%s), or is in L1.  Owners are %s", key, this.rpcManager.getAddress(), this.dm.locate(key));
        }
        return null;
    }
}

