/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.couchdb.impl;

import java.util.Map;
import org.hibernate.SessionFactory;
import org.hibernate.SessionFactoryObserver;
import org.hibernate.cfg.Configuration;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.integrator.spi.Integrator;
import org.hibernate.metamodel.source.MetadataImplementor;
import org.hibernate.ogm.datastore.couchdb.impl.CouchDBDatastoreProvider;
import org.hibernate.ogm.datastore.couchdb.logging.impl.Log;
import org.hibernate.ogm.datastore.couchdb.logging.impl.LoggerFactory;
import org.hibernate.ogm.datastore.spi.DatastoreProvider;
import org.hibernate.ogm.persister.OgmEntityPersister;
import org.hibernate.ogm.service.impl.ConfigurationService;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.service.spi.SessionFactoryServiceRegistry;

public class CouchDBIntegrator
implements Integrator {
    public void integrate(Configuration configuration, SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
        sessionFactory.addObserver((SessionFactoryObserver)new EntityMappingValidator());
    }

    public void integrate(MetadataImplementor metadata, SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
        sessionFactory.addObserver((SessionFactoryObserver)new EntityMappingValidator());
    }

    public void disintegrate(SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
    }

    private static class EntityMappingValidator
    implements SessionFactoryObserver {
        private static final Log logger = LoggerFactory.getLogger();

        private EntityMappingValidator() {
        }

        public void sessionFactoryCreated(SessionFactory factory) {
            SessionFactoryImplementor sessionFactoryImplementor = (SessionFactoryImplementor)factory;
            if (!this.currentDialectIsCouchDB(sessionFactoryImplementor)) {
                return;
            }
            this.validateEntityMappings(sessionFactoryImplementor);
        }

        private boolean currentDialectIsCouchDB(SessionFactoryImplementor sessionFactoryImplementor) {
            ServiceRegistryImplementor registry = sessionFactoryImplementor.getServiceRegistry();
            return ((ConfigurationService)registry.getService(ConfigurationService.class)).isOgmOn() && registry.getService(DatastoreProvider.class) instanceof CouchDBDatastoreProvider;
        }

        public void sessionFactoryClosed(SessionFactory factory) {
        }

        private void validateEntityMappings(SessionFactoryImplementor factory) {
            for (Map.Entry entityAndPersister : factory.getEntityPersisters().entrySet()) {
                if (this.hasRevisionColumn((OgmEntityPersister)entityAndPersister.getValue())) continue;
                logger.entityShouldHaveRevisionProperty((String)entityAndPersister.getKey());
            }
        }

        private boolean hasRevisionColumn(OgmEntityPersister persister) {
            for (int i = 0; i < persister.getPropertyNames().length; ++i) {
                for (String columnName : persister.getPropertyColumnNames(i)) {
                    if (!columnName.equals("_rev")) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

