/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.util.Arrays;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.kernel.InternalSchemaActions;

public class IndexDefinitionImpl
implements IndexDefinition {
    private final InternalSchemaActions actions;
    private final Label label;
    private final String propertyKey;
    private final boolean constraintIndex;

    public IndexDefinitionImpl(InternalSchemaActions actions, Label label, String propertyKey, boolean constraintIndex) {
        this.actions = actions;
        this.label = label;
        this.propertyKey = propertyKey;
        this.constraintIndex = constraintIndex;
    }

    @Override
    public Label getLabel() {
        return this.label;
    }

    @Override
    public Iterable<String> getPropertyKeys() {
        return Arrays.asList(this.propertyKey);
    }

    @Override
    public void drop() {
        if (this.isConstraintIndex()) {
            throw new IllegalStateException("Constraint indexes cannot be dropped directly, instead drop the owning uniqueness constraint.");
        }
        this.actions.dropIndexDefinitions(this.label, this.propertyKey);
    }

    @Override
    public boolean isConstraintIndex() {
        return this.constraintIndex;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.label.name().hashCode();
        result = 31 * result + this.propertyKey.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IndexDefinitionImpl other = (IndexDefinitionImpl)obj;
        return this.label.name().equals(other.label.name()) && this.propertyKey.equals(other.propertyKey);
    }

    public String toString() {
        return "IndexDefinition[label:" + this.label + ", on:" + this.propertyKey + "]";
    }
}

