/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.schema.ConstraintCreator;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.kernel.InternalSchemaActions;
import org.neo4j.kernel.PropertyConstraintCreator;
import org.neo4j.kernel.api.exceptions.KernelException;

public class PropertyUniqueConstraintCreator
extends PropertyConstraintCreator {
    PropertyUniqueConstraintCreator(InternalSchemaActions actions, Label label, String propertyKeyOrNull) {
        super(actions, label, propertyKeyOrNull);
    }

    @Override
    protected ConstraintCreator doOn(String propertyKey) {
        return new PropertyUniqueConstraintCreator(this.actions, this.label, propertyKey);
    }

    @Override
    public ConstraintCreator unique() {
        throw new IllegalStateException("Already unique");
    }

    @Override
    protected ConstraintDefinition doCreate() {
        try {
            return this.actions.createPropertyUniquenessConstraint(this.label, this.propertyKey);
        }
        catch (KernelException e) {
            String userMessage = this.actions.getUserMessage(e);
            throw new ConstraintViolationException(userMessage, e);
        }
    }
}

