/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.IndexCreator;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.ThisShouldNotHappenError;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.IndexCreatorImpl;
import org.neo4j.kernel.IndexDefinitionImpl;
import org.neo4j.kernel.InternalSchemaActions;
import org.neo4j.kernel.PropertyUniqueConstraintDefinition;
import org.neo4j.kernel.ThreadToStatementContextBridge;
import org.neo4j.kernel.api.StatementContext;
import org.neo4j.kernel.api.constraints.UniquenessConstraint;
import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.exceptions.LabelNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.PropertyKeyIdNotFoundException;
import org.neo4j.kernel.api.exceptions.PropertyKeyNotFoundException;
import org.neo4j.kernel.api.exceptions.schema.AlreadyConstrainedException;
import org.neo4j.kernel.api.exceptions.schema.AlreadyIndexedException;
import org.neo4j.kernel.api.exceptions.schema.SchemaKernelException;
import org.neo4j.kernel.api.exceptions.schema.SchemaRuleNotFoundException;
import org.neo4j.kernel.api.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.operations.KeyNameLookup;
import org.neo4j.kernel.impl.api.ConstraintCreationKernelException;
import org.neo4j.kernel.impl.api.index.IndexDescriptor;

public class SchemaImpl
implements Schema {
    private final ThreadToStatementContextBridge ctxProvider;
    private final InternalSchemaActions actions;

    public SchemaImpl(ThreadToStatementContextBridge ctxProvider) {
        this.ctxProvider = ctxProvider;
        this.actions = new GDBSchemaActions(ctxProvider);
    }

    @Override
    public IndexCreator indexFor(Label label) {
        return new IndexCreatorImpl(this.actions, label);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterable<IndexDefinition> getIndexes(Label label) {
        StatementContext context = this.ctxProvider.getCtxForReading();
        try {
            ArrayList<IndexDefinition> definitions = new ArrayList<IndexDefinition>();
            long labelId = context.labelGetForName(label.name());
            this.addDefinitions(definitions, context, context.indexesGetForLabel(labelId), false);
            this.addDefinitions(definitions, context, context.uniqueIndexesGetForLabel(labelId), true);
            ArrayList<IndexDefinition> arrayList = definitions;
            return arrayList;
        }
        catch (LabelNotFoundKernelException e) {
            List<IndexDefinition> list = Collections.emptyList();
            return list;
        }
        finally {
            context.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterable<IndexDefinition> getIndexes() {
        StatementContext context = this.ctxProvider.getCtxForReading();
        try {
            ArrayList<IndexDefinition> definitions = new ArrayList<IndexDefinition>();
            this.addDefinitions(definitions, context, context.indexesGetAll(), false);
            this.addDefinitions(definitions, context, context.uniqueIndexesGetAll(), true);
            ArrayList<IndexDefinition> arrayList = definitions;
            return arrayList;
        }
        finally {
            context.close();
        }
    }

    private void addDefinitions(List<IndexDefinition> definitions, final StatementContext context, Iterator<IndexDescriptor> indexes, final boolean constraintIndex) {
        IteratorUtil.addToCollection(Iterables.map(new Function<IndexDescriptor, IndexDefinition>(){

            @Override
            public IndexDefinition apply(IndexDescriptor rule) {
                try {
                    Label label = DynamicLabel.label(context.labelGetName(rule.getLabelId()));
                    String propertyKey = context.propertyKeyGetName(rule.getPropertyKeyId());
                    return new IndexDefinitionImpl(SchemaImpl.this.actions, label, propertyKey, constraintIndex);
                }
                catch (LabelNotFoundKernelException e) {
                    throw new RuntimeException(e);
                }
                catch (PropertyKeyIdNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
        }, indexes), definitions);
    }

    @Override
    public void awaitIndexOnline(IndexDefinition index, long duration, TimeUnit unit) {
        long now = System.currentTimeMillis();
        long timeout = now + unit.toMillis(duration);
        do {
            Schema.IndexState state = this.getIndexState(index);
            switch (state) {
                case ONLINE: {
                    return;
                }
                case FAILED: {
                    throw new IllegalStateException("Index entered a FAILED state. Please see database logs.");
                }
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        } while (System.currentTimeMillis() < timeout);
        throw new IllegalStateException("Expected index to come online within a reasonable time.");
    }

    @Override
    public void awaitIndexesOnline(long duration, TimeUnit unit) {
        long millisLeft = TimeUnit.MILLISECONDS.convert(duration, unit);
        ArrayList<IndexDefinition> onlineIndexes = new ArrayList<IndexDefinition>();
        Iterator<IndexDefinition> iter = this.getIndexes().iterator();
        while (iter.hasNext()) {
            if (millisLeft < 0L) {
                throw new IllegalStateException("Expected all indexes to come online within a reasonable time.Indexes brought online: " + onlineIndexes + ". Indexes not guaranteed to be online: " + IteratorUtil.asCollection(iter));
            }
            IndexDefinition index = iter.next();
            long millisBefore = System.currentTimeMillis();
            this.awaitIndexOnline(index, millisLeft, TimeUnit.MILLISECONDS);
            millisLeft -= System.currentTimeMillis() - millisBefore;
            onlineIndexes.add(index);
        }
    }

    @Override
    public Schema.IndexState getIndexState(IndexDefinition index) {
        StatementContext context = this.ctxProvider.getCtxForReading();
        String propertyKey = IteratorUtil.single(index.getPropertyKeys());
        try {
            long labelId = context.labelGetForName(index.getLabel().name());
            long propertyKeyId = context.propertyKeyGetForName(propertyKey);
            InternalIndexState indexState = context.indexGetState(context.indexesGetForLabelAndPropertyKey(labelId, propertyKeyId));
            switch (indexState) {
                case POPULATING: {
                    Schema.IndexState indexState2 = Schema.IndexState.POPULATING;
                    return indexState2;
                }
                case ONLINE: {
                    Schema.IndexState indexState3 = Schema.IndexState.ONLINE;
                    return indexState3;
                }
                case FAILED: {
                    Schema.IndexState indexState4 = Schema.IndexState.FAILED;
                    return indexState4;
                }
            }
            try {
                throw new IllegalArgumentException(String.format("Illegal index state %s", new Object[]{indexState}));
            }
            catch (LabelNotFoundKernelException e) {
                throw new NotFoundException(String.format("Label %s not found", index.getLabel().name()));
            }
            catch (PropertyKeyNotFoundException e) {
                throw new NotFoundException(String.format("Property key %s not found", propertyKey));
            }
            catch (SchemaRuleNotFoundException e) {
                throw new NotFoundException(String.format("No index for label %s on property %s", index.getLabel().name(), propertyKey));
            }
            catch (IndexNotFoundKernelException e) {
                throw new NotFoundException(String.format("No index for label %s on property %s", index.getLabel().name(), propertyKey), e);
            }
        }
        finally {
            context.close();
        }
    }

    private static class GDBSchemaActions
    implements InternalSchemaActions {
        private final ThreadToStatementContextBridge ctxProvider;

        public GDBSchemaActions(ThreadToStatementContextBridge ctxProvider) {
            this.ctxProvider = ctxProvider;
        }

        @Override
        public IndexDefinition createIndexDefinition(Label label, String propertyKey) {
            StatementContext context = this.ctxProvider.getCtxForWriting();
            try {
                long labelId = context.labelGetOrCreateForName(label.name());
                long propertyKeyId = context.propertyKeyGetOrCreateForName(propertyKey);
                context.indexCreate(labelId, propertyKeyId);
                IndexDefinitionImpl indexDefinitionImpl = new IndexDefinitionImpl(this, label, propertyKey, false);
                return indexDefinitionImpl;
            }
            catch (AlreadyIndexedException e) {
                throw new ConstraintViolationException(String.format("There already exists an index for label '%s' on property '%s'.", label.name(), propertyKey), e);
            }
            catch (AlreadyConstrainedException e) {
                throw new ConstraintViolationException(String.format("Label '%s' and property '%s' have a unique constraint defined on them, so an index is already created that matches this.", label.name(), propertyKey), e);
            }
            catch (SchemaKernelException e) {
                throw new ConstraintViolationException(e.getUserMessage(new KeyNameLookup(context)), e);
            }
            finally {
                context.close();
            }
        }

        @Override
        public void dropIndexDefinitions(Label label, String propertyKey) {
            StatementContext context = this.ctxProvider.getCtxForWriting();
            try {
                long labelId = context.labelGetForName(label.name());
                long propertyKeyId = context.propertyKeyGetForName(propertyKey);
                context.indexDrop(context.indexesGetForLabelAndPropertyKey(labelId, propertyKeyId));
            }
            catch (SchemaKernelException e) {
                throw new ConstraintViolationException(String.format("Unable to drop index on label `%s` for property %s.", label.name(), propertyKey), e);
            }
            catch (LabelNotFoundKernelException e) {
                throw new ThisShouldNotHappenError("Mattias", "Label " + label.name() + " should exist here");
            }
            catch (PropertyKeyNotFoundException e) {
                throw new ThisShouldNotHappenError("Mattias", "Property " + propertyKey + " should exist here");
            }
            finally {
                context.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ConstraintDefinition createPropertyUniquenessConstraint(Label label, String propertyKey) throws SchemaKernelException, ConstraintCreationKernelException {
            StatementContext context = this.ctxProvider.getCtxForWriting();
            try {
                long labelId = context.labelGetOrCreateForName(label.name());
                long propertyKeyId = context.propertyKeyGetOrCreateForName(propertyKey);
                context.uniquenessConstraintCreate(labelId, propertyKeyId);
                PropertyUniqueConstraintDefinition propertyUniqueConstraintDefinition = new PropertyUniqueConstraintDefinition(this, label, propertyKey);
                return propertyUniqueConstraintDefinition;
            }
            finally {
                context.close();
            }
        }

        @Override
        public void dropPropertyUniquenessConstraint(Label label, String propertyKey) {
            StatementContext context = this.ctxProvider.getCtxForWriting();
            try {
                long labelId = context.labelGetOrCreateForName(label.name());
                long propertyKeyId = context.propertyKeyGetOrCreateForName(propertyKey);
                UniquenessConstraint constraint = new UniquenessConstraint(labelId, propertyKeyId);
                context.constraintDrop(constraint);
            }
            catch (SchemaKernelException e) {
                throw new ThisShouldNotHappenError("Mattias", "Unable to drop property unique constraint");
            }
            finally {
                context.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getUserMessage(KernelException e) {
            StatementContext context = this.ctxProvider.getCtxForWriting();
            try {
                String string = e.getUserMessage(new KeyNameLookup(context));
                return string;
            }
            finally {
                context.close();
            }
        }
    }
}

