/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.properties;

import org.neo4j.kernel.api.properties.FullSizeProperty;

final class DoubleProperty
extends FullSizeProperty {
    private final double value;

    DoubleProperty(long propertyKeyId, double value) {
        super(propertyKeyId);
        this.value = value;
    }

    @Override
    public Double value() {
        return this.value;
    }

    @Override
    int valueHash() {
        long temp = Double.doubleToLongBits(this.value);
        return (int)(temp ^ temp >>> 32);
    }

    @Override
    boolean hasEqualValue(FullSizeProperty that) {
        return Double.compare(this.value, ((DoubleProperty)that).value) == 0;
    }
}

