/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Iterator;
import org.neo4j.helpers.Function;
import org.neo4j.kernel.api.StatementContext;
import org.neo4j.kernel.api.constraints.UniquenessConstraint;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.exceptions.schema.DropIndexFailureException;
import org.neo4j.kernel.api.exceptions.schema.SchemaKernelException;
import org.neo4j.kernel.impl.api.CompositeStatementContext;
import org.neo4j.kernel.impl.api.ConstraintCreationKernelException;
import org.neo4j.kernel.impl.api.LockHolder;
import org.neo4j.kernel.impl.api.index.IndexDescriptor;

public class LockingStatementContext
extends CompositeStatementContext {
    private final LockHolder lockHolder;
    private final StatementContext delegate;

    public LockingStatementContext(StatementContext actual, LockHolder lockHolder) {
        super(actual);
        this.lockHolder = lockHolder;
        this.delegate = actual;
    }

    @Override
    public boolean nodeAddLabel(long nodeId, long labelId) throws EntityNotFoundException {
        this.lockHolder.acquireNodeWriteLock(nodeId);
        return this.delegate.nodeAddLabel(nodeId, labelId);
    }

    @Override
    public boolean nodeRemoveLabel(long nodeId, long labelId) throws EntityNotFoundException {
        this.lockHolder.acquireNodeWriteLock(nodeId);
        return this.delegate.nodeRemoveLabel(nodeId, labelId);
    }

    @Override
    public IndexDescriptor indexCreate(long labelId, long propertyKey) throws SchemaKernelException {
        this.lockHolder.acquireSchemaWriteLock();
        return this.delegate.indexCreate(labelId, propertyKey);
    }

    @Override
    public IndexDescriptor uniqueIndexCreate(long labelId, long propertyKey) throws SchemaKernelException {
        this.lockHolder.acquireSchemaWriteLock();
        return this.delegate.uniqueIndexCreate(labelId, propertyKey);
    }

    @Override
    public void indexDrop(IndexDescriptor descriptor) throws DropIndexFailureException {
        this.lockHolder.acquireSchemaWriteLock();
        this.delegate.indexDrop(descriptor);
    }

    @Override
    public void uniqueIndexDrop(IndexDescriptor descriptor) throws DropIndexFailureException {
        this.lockHolder.acquireSchemaWriteLock();
        this.delegate.uniqueIndexDrop(descriptor);
    }

    @Override
    public <K, V> V schemaStateGetOrCreate(K key, Function<K, V> creator) {
        this.lockHolder.acquireSchemaReadLock();
        return this.delegate.schemaStateGetOrCreate(key, creator);
    }

    @Override
    public <K> boolean schemaStateContains(K key) {
        this.lockHolder.acquireSchemaReadLock();
        return super.schemaStateContains(key);
    }

    @Override
    public Iterator<IndexDescriptor> indexesGetForLabel(long labelId) {
        this.lockHolder.acquireSchemaReadLock();
        return this.delegate.indexesGetForLabel(labelId);
    }

    @Override
    public Iterator<IndexDescriptor> indexesGetAll() {
        this.lockHolder.acquireSchemaReadLock();
        return this.delegate.indexesGetAll();
    }

    @Override
    public Iterator<IndexDescriptor> uniqueIndexesGetForLabel(long labelId) {
        this.lockHolder.acquireSchemaReadLock();
        return this.delegate.uniqueIndexesGetForLabel(labelId);
    }

    @Override
    public Iterator<IndexDescriptor> uniqueIndexesGetAll() {
        this.lockHolder.acquireSchemaReadLock();
        return this.delegate.uniqueIndexesGetAll();
    }

    @Override
    public void nodeDelete(long nodeId) {
        this.lockHolder.acquireNodeWriteLock(nodeId);
        this.delegate.nodeDelete(nodeId);
    }

    @Override
    public UniquenessConstraint uniquenessConstraintCreate(long labelId, long propertyKeyId) throws SchemaKernelException, ConstraintCreationKernelException {
        this.lockHolder.acquireSchemaWriteLock();
        return this.delegate.uniquenessConstraintCreate(labelId, propertyKeyId);
    }

    @Override
    public Iterator<UniquenessConstraint> constraintsGetForLabelAndPropertyKey(long labelId, long propertyKeyId) {
        this.lockHolder.acquireSchemaReadLock();
        return this.delegate.constraintsGetForLabelAndPropertyKey(labelId, propertyKeyId);
    }

    @Override
    public Iterator<UniquenessConstraint> constraintsGetForLabel(long labelId) {
        this.lockHolder.acquireSchemaReadLock();
        return this.delegate.constraintsGetForLabel(labelId);
    }

    @Override
    public Iterator<UniquenessConstraint> constraintsGetAll() {
        this.lockHolder.acquireSchemaReadLock();
        return this.delegate.constraintsGetAll();
    }

    @Override
    public void constraintDrop(UniquenessConstraint constraint) {
        this.lockHolder.acquireSchemaWriteLock();
        this.delegate.constraintDrop(constraint);
    }
}

