/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.impl.api.state.NodeState;
import org.neo4j.kernel.impl.api.state.TxState;
import org.neo4j.kernel.impl.cache.EntityWithSize;
import org.neo4j.kernel.impl.cache.LockStripedCache;
import org.neo4j.kernel.impl.cache.SoftLruCache;

public class PersistenceCache {
    private final LockStripedCache<CachedNodeEntity> nodeCache;

    public PersistenceCache(LockStripedCache.Loader<CachedNodeEntity> nodeLoader) {
        this.nodeCache = new LockStripedCache<CachedNodeEntity>(new SoftLruCache("Kernel API label cache"), 32, nodeLoader);
    }

    public Set<Long> getLabels(long nodeId) throws EntityNotFoundException {
        CachedNodeEntity node = this.nodeCache.get(nodeId);
        if (node != null) {
            return node.getLabels();
        }
        throw new EntityNotFoundException("node", nodeId);
    }

    public void apply(TxState state) {
        for (NodeState stateEntity : state.getNodeStates()) {
            CachedNodeEntity entity = this.nodeCache.getIfCached(stateEntity.getId());
            if (entity == null) continue;
            entity.addLabels(stateEntity.getLabelDiffSets().getAdded());
            entity.removeLabels(stateEntity.getLabelDiffSets().getRemoved());
        }
    }

    public void evictNode(long nodeId) {
        this.nodeCache.remove(nodeId);
    }

    public static class CachedNodeEntity
    implements EntityWithSize {
        private final long id;
        private final Set<Long> labels = new CopyOnWriteArraySet<Long>();

        public CachedNodeEntity(long id) {
            this.id = id;
        }

        public void addLabels(Set<Long> additionalLabels) {
            this.labels.addAll(additionalLabels);
        }

        public void removeLabels(Set<Long> removedLabels) {
            this.labels.removeAll(removedLabels);
        }

        @Override
        public long getId() {
            return this.id;
        }

        @Override
        public void setRegisteredSize(int size) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getRegisteredSize() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            throw new UnsupportedOperationException();
        }

        public Set<Long> getLabels() {
            return this.labels;
        }
    }
}

