/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import org.neo4j.kernel.impl.api.DiffSets;
import org.neo4j.kernel.impl.api.state.OldTxStateBridge;
import org.neo4j.kernel.impl.core.NodeImpl;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.core.TransactionState;
import org.neo4j.kernel.impl.core.WritableTransactionState;
import org.neo4j.kernel.impl.nioneo.store.PropertyData;
import org.neo4j.kernel.impl.util.ArrayMap;

public class OldTxStateBridgeImpl
implements OldTxStateBridge {
    private final NodeManager nodeManager;
    private final TransactionState state;

    public OldTxStateBridgeImpl(NodeManager nodeManager, TransactionState transactionState) {
        this.nodeManager = nodeManager;
        this.state = transactionState;
    }

    @Override
    public DiffSets<Long> getNodesWithChangedProperty(long propertyKey, Object value) {
        DiffSets<Long> diff = new DiffSets<Long>();
        Iterable<WritableTransactionState.CowNodeElement> changedNodes = this.state.getChangedNodes();
        for (WritableTransactionState.CowNodeElement changedNode : changedNodes) {
            ArrayMap propAddMap;
            ArrayMap propRmMap = changedNode.getPropertyRemoveMap(false);
            if (propRmMap != null) {
                for (PropertyData propertyData : propRmMap.values()) {
                    if ((long)propertyData.getIndex() != propertyKey || !propertyData.getValue().equals(value)) continue;
                    diff.remove(changedNode.getId());
                }
            }
            if (changedNode.isDeleted() || (propAddMap = changedNode.getPropertyAddMap(false)) == null) continue;
            for (PropertyData propertyData : propAddMap.values()) {
                if ((long)propertyData.getIndex() != propertyKey) continue;
                if (propertyData.getValue().equals(value)) {
                    diff.add(changedNode.getId());
                    continue;
                }
                diff.remove(changedNode.getId());
            }
        }
        return diff;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteNode(long nodeId) {
        NodeImpl node = this.nodeManager.getNodeForProxy(nodeId, null);
        boolean success = false;
        try {
            ArrayMap<Integer, PropertyData> skipMap = this.state.getOrCreateCowPropertyRemoveMap(node);
            ArrayMap<Integer, PropertyData> removedProps = this.nodeManager.deleteNode(node, this.state);
            if (removedProps.size() > 0) {
                for (Integer index : removedProps.keySet()) {
                    skipMap.put(index, removedProps.get(index));
                }
            }
            success = true;
        }
        finally {
            if (!success) {
                this.nodeManager.setRollbackOnly();
            }
        }
    }

    @Override
    public boolean nodeIsAddedInThisTx(long nodeId) {
        return this.state.getCreatedNodes().contains(nodeId);
    }

    @Override
    public boolean hasChanges() {
        return this.state.hasChanges();
    }
}

