/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import javax.transaction.SystemException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.index.Index;
import org.neo4j.helpers.Pair;
import org.neo4j.helpers.Predicate;
import org.neo4j.helpers.ThisShouldNotHappenError;
import org.neo4j.helpers.Triplet;
import org.neo4j.helpers.collection.CombiningIterator;
import org.neo4j.helpers.collection.FilteringIterator;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.IteratorWrapper;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.kernel.PropertyTracker;
import org.neo4j.kernel.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.cache.Cache;
import org.neo4j.kernel.impl.cache.CacheProvider;
import org.neo4j.kernel.impl.cache.LockStripedCache;
import org.neo4j.kernel.impl.core.GraphProperties;
import org.neo4j.kernel.impl.core.IndexLock;
import org.neo4j.kernel.impl.core.LabelTokenHolder;
import org.neo4j.kernel.impl.core.LockElement;
import org.neo4j.kernel.impl.core.NodeImpl;
import org.neo4j.kernel.impl.core.NodeProxy;
import org.neo4j.kernel.impl.core.Primitive;
import org.neo4j.kernel.impl.core.PropertyKeyTokenHolder;
import org.neo4j.kernel.impl.core.RelationshipImpl;
import org.neo4j.kernel.impl.core.RelationshipProxy;
import org.neo4j.kernel.impl.core.RelationshipTypeTokenHolder;
import org.neo4j.kernel.impl.core.Token;
import org.neo4j.kernel.impl.core.TokenNotFoundException;
import org.neo4j.kernel.impl.core.TransactionState;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyData;
import org.neo4j.kernel.impl.nioneo.store.Record;
import org.neo4j.kernel.impl.nioneo.store.RelationshipRecord;
import org.neo4j.kernel.impl.persistence.EntityIdGenerator;
import org.neo4j.kernel.impl.persistence.PersistenceManager;
import org.neo4j.kernel.impl.transaction.AbstractTransactionManager;
import org.neo4j.kernel.impl.transaction.LockType;
import org.neo4j.kernel.impl.transaction.XaDataSourceManager;
import org.neo4j.kernel.impl.transaction.xaframework.XaDataSource;
import org.neo4j.kernel.impl.util.ArrayMap;
import org.neo4j.kernel.impl.util.RelIdArray;
import org.neo4j.kernel.impl.util.RelIdArrayWithLoops;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.lifecycle.Lifecycle;

public class NodeManager
implements Lifecycle {
    private long referenceNodeId = 0L;
    private final StringLogger logger;
    private final GraphDatabaseService graphDbService;
    private final LockStripedCache<NodeImpl> nodeCache;
    private final LockStripedCache<RelationshipImpl> relCache;
    private final CacheProvider cacheProvider;
    private final AbstractTransactionManager transactionManager;
    private final PropertyKeyTokenHolder propertyKeyTokenHolder;
    private final LabelTokenHolder labelTokenHolder;
    private final RelationshipTypeTokenHolder relTypeHolder;
    private final PersistenceManager persistenceManager;
    private final EntityIdGenerator idGenerator;
    private final XaDataSourceManager xaDsm;
    private final ThreadToStatementContextBridge statementCtxProvider;
    private final NodeProxy.NodeLookup nodeLookup;
    private final RelationshipProxy.RelationshipLookups relationshipLookups;
    private final List<PropertyTracker<Node>> nodePropertyTrackers;
    private final List<PropertyTracker<Relationship>> relationshipPropertyTrackers;
    private static final int LOCK_STRIPE_COUNT = 32;
    private final ReentrantLock[] loadLocks = new ReentrantLock[32];
    private GraphProperties graphProperties;
    private final LockStripedCache.Loader<NodeImpl> nodeLoader = new LockStripedCache.Loader<NodeImpl>(){

        @Override
        public NodeImpl loadById(long id) {
            NodeRecord record = NodeManager.this.persistenceManager.loadLightNode(id);
            if (record == null) {
                return null;
            }
            return new NodeImpl(id, record.getCommittedNextRel(), record.getCommittedNextProp());
        }
    };
    private final LockStripedCache.Loader<RelationshipImpl> relLoader = new LockStripedCache.Loader<RelationshipImpl>(){

        @Override
        public RelationshipImpl loadById(long id) {
            RelationshipRecord data = NodeManager.this.persistenceManager.loadLightRelationship(id);
            if (data == null) {
                return null;
            }
            int typeId = data.getType();
            long startNodeId = data.getFirstNode();
            long endNodeId = data.getSecondNode();
            return NodeManager.this.newRelationshipImpl(id, startNodeId, endNodeId, typeId, false);
        }
    };

    public NodeManager(StringLogger logger, GraphDatabaseService graphDb, AbstractTransactionManager transactionManager, PersistenceManager persistenceManager, EntityIdGenerator idGenerator, RelationshipTypeTokenHolder relationshipTypeTokenHolder, CacheProvider cacheProvider, PropertyKeyTokenHolder propertyKeyTokenHolder, LabelTokenHolder labelTokenHolder, NodeProxy.NodeLookup nodeLookup, RelationshipProxy.RelationshipLookups relationshipLookups, Cache<NodeImpl> nodeCache, Cache<RelationshipImpl> relCache, XaDataSourceManager xaDsm, ThreadToStatementContextBridge statementCtxProvider) {
        this.logger = logger;
        this.graphDbService = graphDb;
        this.transactionManager = transactionManager;
        this.propertyKeyTokenHolder = propertyKeyTokenHolder;
        this.persistenceManager = persistenceManager;
        this.idGenerator = idGenerator;
        this.labelTokenHolder = labelTokenHolder;
        this.nodeLookup = nodeLookup;
        this.relationshipLookups = relationshipLookups;
        this.relTypeHolder = relationshipTypeTokenHolder;
        this.cacheProvider = cacheProvider;
        this.statementCtxProvider = statementCtxProvider;
        this.nodeCache = new LockStripedCache<NodeImpl>(nodeCache, 32, this.nodeLoader);
        this.relCache = new LockStripedCache<RelationshipImpl>(relCache, 32, this.relLoader);
        this.xaDsm = xaDsm;
        for (int i = 0; i < this.loadLocks.length; ++i) {
            this.loadLocks[i] = new ReentrantLock();
        }
        this.nodePropertyTrackers = new LinkedList<PropertyTracker<Node>>();
        this.relationshipPropertyTrackers = new LinkedList<PropertyTracker<Relationship>>();
        this.graphProperties = this.instantiateGraphProperties();
    }

    public GraphDatabaseService getGraphDbService() {
        return this.graphDbService;
    }

    public CacheProvider getCacheType() {
        return this.cacheProvider;
    }

    @Override
    public void init() {
    }

    @Override
    public void start() {
        for (XaDataSource ds : this.xaDsm.getAllRegisteredDataSources()) {
            if (!ds.getName().equals("nioneodb")) continue;
            this.addRawRelationshipTypes(this.persistenceManager.loadAllRelationshipTypeTokens());
            this.addPropertyKeyTokens(this.persistenceManager.loadAllPropertyKeyTokens());
            this.addLabelTokens(this.persistenceManager.loadAllLabelTokens());
        }
    }

    @Override
    public void stop() {
        this.clearCache();
    }

    @Override
    public void shutdown() {
        this.nodeCache.printStatistics();
        this.relCache.printStatistics();
        this.nodeCache.clear();
        this.relCache.clear();
    }

    public Node createNode() {
        return this.createNode(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node createNode(Label[] labels) {
        long id = this.idGenerator.nextId(Node.class);
        NodeImpl node = new NodeImpl(id, Record.NO_NEXT_RELATIONSHIP.intValue(), Record.NO_NEXT_PROPERTY.intValue(), true);
        NodeProxy proxy = new NodeProxy(id, this.nodeLookup, this.statementCtxProvider);
        TransactionState transactionState = this.getTransactionState();
        transactionState.acquireWriteLock(proxy);
        boolean success = false;
        try {
            this.persistenceManager.nodeCreate(id);
            transactionState.createNode(id);
            if (labels != null) {
                for (Label label : labels) {
                    proxy.addLabel(label);
                }
            }
            this.nodeCache.put(node);
            success = true;
            NodeProxy nodeProxy = proxy;
            return nodeProxy;
        }
        finally {
            if (!success) {
                this.setRollbackOnly();
            }
        }
    }

    public NodeProxy newNodeProxyById(long id) {
        return new NodeProxy(id, this.nodeLookup, this.statementCtxProvider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Relationship createRelationship(Node startNodeProxy, NodeImpl startNode, Node endNode, RelationshipType type) {
        if (startNode == null || endNode == null || type == null) {
            throw new IllegalArgumentException("Null parameter, startNode=" + startNode + ", endNode=" + endNode + ", type=" + type);
        }
        int typeId = this.relTypeHolder.getOrCreateId(type.name());
        long startNodeId = startNode.getId();
        long endNodeId = endNode.getId();
        NodeImpl secondNode = this.getLightNode(endNodeId);
        if (secondNode == null) {
            this.setRollbackOnly();
            throw new NotFoundException("Second node[" + endNode.getId() + "] deleted");
        }
        long id = this.idGenerator.nextId(Relationship.class);
        RelationshipImpl rel = this.newRelationshipImpl(id, startNodeId, endNodeId, typeId, true);
        RelationshipProxy proxy = new RelationshipProxy(id, this.relationshipLookups, this.statementCtxProvider);
        TransactionState tx = this.getTransactionState();
        tx.acquireWriteLock(proxy);
        boolean success = false;
        try {
            tx.acquireWriteLock(startNodeProxy);
            tx.acquireWriteLock(endNode);
            this.persistenceManager.relationshipCreate(id, typeId, startNodeId, endNodeId);
            if (startNodeId == endNodeId) {
                tx.getOrCreateCowRelationshipAddMap(startNode, typeId).add(id, RelIdArray.DirectionWrapper.BOTH);
            } else {
                tx.getOrCreateCowRelationshipAddMap(startNode, typeId).add(id, RelIdArray.DirectionWrapper.OUTGOING);
                tx.getOrCreateCowRelationshipAddMap(secondNode, typeId).add(id, RelIdArray.DirectionWrapper.INCOMING);
            }
            this.relCache.put(rel);
            success = true;
            RelationshipProxy relationshipProxy = proxy;
            return relationshipProxy;
        }
        finally {
            if (!success) {
                this.setRollbackOnly();
            }
        }
    }

    private RelationshipImpl newRelationshipImpl(long id, long startNodeId, long endNodeId, int typeId, boolean newRel) {
        return new RelationshipImpl(id, startNodeId, endNodeId, typeId, newRel);
    }

    private ReentrantLock lockId(long id) {
        int stripe = (int)(id / 32768L) % 32;
        if (stripe < 0) {
            stripe *= -1;
        }
        ReentrantLock lock = this.loadLocks[stripe];
        lock.lock();
        return lock;
    }

    public Node getNodeByIdOrNull(long nodeId) {
        NodeImpl node = this.getLightNode(nodeId);
        return node != null ? new NodeProxy(nodeId, this.nodeLookup, this.statementCtxProvider) : null;
    }

    public Node getNodeById(long nodeId) throws NotFoundException {
        Node node = this.getNodeByIdOrNull(nodeId);
        if (node == null) {
            throw new NotFoundException(String.format("Node %d not found", nodeId));
        }
        return node;
    }

    NodeImpl getLightNode(long nodeId) {
        return this.nodeCache.get(nodeId);
    }

    public RelationshipProxy newRelationshipProxyById(long id) {
        return new RelationshipProxy(id, this.relationshipLookups, this.statementCtxProvider);
    }

    public Iterator<Node> getAllNodes() {
        PrefetchingIterator<Node> committedNodes = new PrefetchingIterator<Node>(){
            private long highId;
            private long currentId;
            {
                this.highId = NodeManager.this.getHighestPossibleIdInUse(Node.class);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            @Override
            protected Node fetchNextOrNull() {
                while (true) lbl-1000:
                // 4 sources

                {
                    if (this.currentId <= this.highId) {
                        try {
                            node = NodeManager.this.getNodeByIdOrNull(this.currentId);
                            if (node == null) ** GOTO lbl-1000
                            var2_3 = node;
                            return var2_3;
                        }
                        finally {
                            ++this.currentId;
                        }
                        continue;
                    }
                    newHighId = NodeManager.this.getHighestPossibleIdInUse(Node.class);
                    if (newHighId <= this.highId) break;
                    this.highId = newHighId;
                }
                return null;
            }
        };
        final TransactionState txState = this.getTransactionState();
        if (!txState.hasChanges()) {
            return committedNodes;
        }
        final HashSet<Long> createdNodes = new HashSet<Long>(txState.getCreatedNodes());
        if (!createdNodes.isEmpty()) {
            committedNodes = new FilteringIterator<Node>(committedNodes, new Predicate<Node>(){

                @Override
                public boolean accept(Node node) {
                    return !createdNodes.contains(node.getId());
                }
            });
        }
        FilteringIterator<Node> filteredRemovedNodes = new FilteringIterator<Node>(committedNodes, new Predicate<Node>(){

            @Override
            public boolean accept(Node node) {
                return !txState.nodeIsDeleted(node.getId());
            }
        });
        return new CombiningIterator<Node>(Arrays.asList(filteredRemovedNodes, new IteratorWrapper<Node, Long>(createdNodes.iterator()){

            @Override
            protected Node underlyingObjectToObject(Long id) {
                return NodeManager.this.getNodeById(id);
            }
        }));
    }

    public NodeImpl getNodeForProxy(long nodeId, LockType lock) {
        NodeImpl node;
        if (lock != null) {
            lock.acquire(this.getTransactionState(), new NodeProxy(nodeId, this.nodeLookup, this.statementCtxProvider));
        }
        if ((node = this.getLightNode(nodeId)) == null) {
            throw new NotFoundException(String.format("Node %d not found", nodeId));
        }
        return node;
    }

    public Node getReferenceNode() throws NotFoundException {
        if (this.referenceNodeId == -1L) {
            throw new NotFoundException("No reference node set");
        }
        return this.getNodeById(this.referenceNodeId);
    }

    public void setReferenceNodeId(long nodeId) {
        this.referenceNodeId = nodeId;
    }

    protected Relationship getRelationshipByIdOrNull(long relId) {
        RelationshipImpl relationship = this.relCache.get(relId);
        return relationship != null ? new RelationshipProxy(relId, this.relationshipLookups, this.statementCtxProvider) : null;
    }

    public Relationship getRelationshipById(long id) throws NotFoundException {
        Relationship relationship = this.getRelationshipByIdOrNull(id);
        if (relationship == null) {
            throw new NotFoundException(String.format("Relationship %d not found", id));
        }
        return relationship;
    }

    public Iterator<Relationship> getAllRelationships() {
        PrefetchingIterator<Relationship> committedRelationships = new PrefetchingIterator<Relationship>(){
            private long highId;
            private long currentId;
            {
                this.highId = NodeManager.this.getHighestPossibleIdInUse(Relationship.class);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            @Override
            protected Relationship fetchNextOrNull() {
                while (true) lbl-1000:
                // 4 sources

                {
                    if (this.currentId <= this.highId) {
                        try {
                            relationship = NodeManager.this.getRelationshipByIdOrNull(this.currentId);
                            if (relationship == null) ** GOTO lbl-1000
                            var2_3 = relationship;
                            return var2_3;
                        }
                        finally {
                            ++this.currentId;
                        }
                        continue;
                    }
                    newHighId = NodeManager.this.getHighestPossibleIdInUse(Node.class);
                    if (newHighId <= this.highId) break;
                    this.highId = newHighId;
                }
                return null;
            }
        };
        final TransactionState txState = this.getTransactionState();
        if (!txState.hasChanges()) {
            return committedRelationships;
        }
        final HashSet<Long> createdRelationships = new HashSet<Long>(txState.getCreatedRelationships());
        if (!createdRelationships.isEmpty()) {
            committedRelationships = new FilteringIterator<Relationship>(committedRelationships, new Predicate<Relationship>(){

                @Override
                public boolean accept(Relationship relationship) {
                    return !createdRelationships.contains(relationship.getId());
                }
            });
        }
        FilteringIterator<Relationship> filteredRemovedRelationships = new FilteringIterator<Relationship>(committedRelationships, new Predicate<Relationship>(){

            @Override
            public boolean accept(Relationship relationship) {
                return !txState.relationshipIsDeleted(relationship.getId());
            }
        });
        return new CombiningIterator<Relationship>(Arrays.asList(filteredRemovedRelationships, new IteratorWrapper<Relationship, Long>(createdRelationships.iterator()){

            @Override
            protected Relationship underlyingObjectToObject(Long id) {
                return NodeManager.this.getRelationshipById(id);
            }
        }));
    }

    RelationshipType getRelationshipTypeById(int id) throws TokenNotFoundException {
        return (RelationshipType)this.relTypeHolder.getTokenById(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RelationshipImpl getRelationshipForProxy(long relId, LockType lock) {
        RelationshipImpl relationship;
        if (lock != null) {
            lock.acquire(this.getTransactionState(), new RelationshipProxy(relId, this.relationshipLookups, this.statementCtxProvider));
        }
        if ((relationship = this.relCache.get(relId)) != null) {
            return relationship;
        }
        ReentrantLock loadLock = this.lockId(relId);
        try {
            relationship = this.relCache.get(relId);
            if (relationship != null) {
                RelationshipImpl relationshipImpl = relationship;
                return relationshipImpl;
            }
            RelationshipRecord data = this.persistenceManager.loadLightRelationship(relId);
            if (data == null) {
                throw new NotFoundException(String.format("Relationship %d not found", relId));
            }
            int typeId = data.getType();
            relationship = this.newRelationshipImpl(relId, data.getFirstNode(), data.getSecondNode(), typeId, false);
            this.relCache.put(relationship);
            RelationshipImpl relationshipImpl = relationship;
            return relationshipImpl;
        }
        finally {
            loadLock.unlock();
        }
    }

    public void removeNodeFromCache(long nodeId) {
        this.nodeCache.remove(nodeId);
    }

    public void removeRelationshipFromCache(long id) {
        this.relCache.remove(id);
    }

    public void patchDeletedRelationshipNodes(long relId, long firstNodeId, long firstNodeNextRelId, long secondNodeId, long secondNodeNextRelId) {
        this.invalidateNode(firstNodeId, relId, firstNodeNextRelId);
        this.invalidateNode(secondNodeId, relId, secondNodeNextRelId);
    }

    private void invalidateNode(long nodeId, long relIdDeleted, long nextRelId) {
        NodeImpl node = this.nodeCache.getIfCached(nodeId);
        if (node != null && node.getRelChainPosition() == relIdDeleted) {
            node.setRelChainPosition(nextRelId);
        }
    }

    Object loadPropertyValue(PropertyData property) {
        return this.persistenceManager.loadPropertyValue(property);
    }

    long getRelationshipChainPosition(NodeImpl node) {
        return this.persistenceManager.getRelationshipChainPosition(node.getId());
    }

    Triplet<ArrayMap<Integer, RelIdArray>, List<RelationshipImpl>, Long> getMoreRelationships(NodeImpl node) {
        boolean hasLoops;
        long nodeId = node.getId();
        long position = node.getRelChainPosition();
        Pair<Map<RelIdArray.DirectionWrapper, Iterable<RelationshipRecord>>, Long> rels = this.persistenceManager.getMoreRelationships(nodeId, position);
        ArrayMap<Integer, RelIdArray> newRelationshipMap = new ArrayMap<Integer, RelIdArray>();
        ArrayList<RelationshipImpl> relsList = new ArrayList<RelationshipImpl>(150);
        Iterable<RelationshipRecord> loops = rels.first().get((Object)RelIdArray.DirectionWrapper.BOTH);
        boolean bl = hasLoops = loops != null;
        if (hasLoops) {
            this.receiveRelationships(loops, newRelationshipMap, relsList, RelIdArray.DirectionWrapper.BOTH, true);
        }
        this.receiveRelationships(rels.first().get((Object)RelIdArray.DirectionWrapper.OUTGOING), newRelationshipMap, relsList, RelIdArray.DirectionWrapper.OUTGOING, hasLoops);
        this.receiveRelationships(rels.first().get((Object)RelIdArray.DirectionWrapper.INCOMING), newRelationshipMap, relsList, RelIdArray.DirectionWrapper.INCOMING, hasLoops);
        return Triplet.of(newRelationshipMap, relsList, rels.other());
    }

    private void receiveRelationships(Iterable<RelationshipRecord> rels, ArrayMap<Integer, RelIdArray> newRelationshipMap, List<RelationshipImpl> relsList, RelIdArray.DirectionWrapper dir, boolean hasLoops) {
        for (RelationshipRecord rel : rels) {
            int typeId;
            long relId = rel.getId();
            RelationshipImpl relImpl = this.relCache.get(relId);
            if (relImpl == null) {
                typeId = rel.getType();
                relImpl = this.newRelationshipImpl(relId, rel.getFirstNode(), rel.getSecondNode(), typeId, false);
                relsList.add(relImpl);
            } else {
                typeId = relImpl.getTypeId();
            }
            RelIdArray relationshipSet = newRelationshipMap.get(typeId);
            if (relationshipSet == null) {
                relationshipSet = hasLoops ? new RelIdArrayWithLoops(typeId) : new RelIdArray(typeId);
                newRelationshipMap.put(typeId, relationshipSet);
            }
            relationshipSet.add(relId, dir);
        }
    }

    void putAllInRelCache(Collection<RelationshipImpl> relationships) {
        this.relCache.putAll((Collection)relationships);
    }

    ArrayMap<Integer, PropertyData> loadGraphProperties(boolean light) {
        return this.persistenceManager.graphLoadProperties(light);
    }

    ArrayMap<Integer, PropertyData> loadProperties(NodeImpl node, boolean light) {
        return this.persistenceManager.loadNodeProperties(node.getId(), light);
    }

    ArrayMap<Integer, PropertyData> loadProperties(RelationshipImpl relationship, boolean light) {
        return this.persistenceManager.loadRelProperties(relationship.getId(), light);
    }

    public void clearCache() {
        this.nodeCache.clear();
        this.relCache.clear();
        this.graphProperties = this.instantiateGraphProperties();
    }

    public Iterable<? extends Cache<?>> caches() {
        return Arrays.asList(this.nodeCache, this.relCache);
    }

    public void setRollbackOnly() {
        try {
            this.transactionManager.setRollbackOnly();
        }
        catch (IllegalStateException e) {
            this.logger.debug("Failed to set transaction rollback only", e);
        }
        catch (SystemException se) {
            this.logger.error("Failed to set transaction rollback only", se);
        }
    }

    public <T extends PropertyContainer> T indexPutIfAbsent(Index<T> index, T entity, String key, Object value) {
        PropertyContainer existing = (PropertyContainer)index.get(key, value).getSingle();
        if (existing != null) {
            return (T)existing;
        }
        IndexLock lock = new IndexLock(index.getName(), key);
        TransactionState state = this.getTransactionState();
        LockElement writeLock = state.acquireWriteLock(lock);
        existing = (PropertyContainer)index.get(key, value).getSingle();
        if (existing != null) {
            writeLock.release();
            return (T)existing;
        }
        index.add(entity, key, value);
        return null;
    }

    public long getHighestPossibleIdInUse(Class<?> clazz) {
        return this.idGenerator.getHighestPossibleIdInUse(clazz);
    }

    public long getNumberOfIdsInUse(Class<?> clazz) {
        return this.idGenerator.getNumberOfIdsInUse(clazz);
    }

    public void removeRelationshipTypeFromCache(int id) {
        this.relTypeHolder.removeToken(id);
    }

    void addPropertyKeyTokens(Token[] propertyKeyTokens) {
        this.propertyKeyTokenHolder.addTokens(propertyKeyTokens);
    }

    void addLabelTokens(Token[] labelTokens) {
        this.labelTokenHolder.addTokens(labelTokens);
    }

    Token getPropertyKeyToken(int keyId) throws TokenNotFoundException {
        return this.propertyKeyTokenHolder.getTokenById(keyId);
    }

    Token getPropertyKeyTokenOrNull(int keyId) {
        return this.propertyKeyTokenHolder.getTokenByIdOrNull(keyId);
    }

    Token getPropertyKeyTokenOrNull(String key) {
        return this.propertyKeyTokenHolder.getTokenByNameOrNull(key);
    }

    int getOrCreatePropertyKeyId(String key) {
        return this.propertyKeyTokenHolder.getOrCreateId(key);
    }

    int getRelationshipTypeIdFor(RelationshipType type) throws TokenNotFoundException {
        return this.relTypeHolder.getIdByName(type.name());
    }

    void addRawRelationshipTypes(Token[] relTypes) {
        this.relTypeHolder.addTokens(relTypes);
    }

    public Iterable<RelationshipType> getRelationshipTypes() {
        return Iterables.cast(this.relTypeHolder.getAllTokens());
    }

    private <T extends PropertyContainer> void deleteFromTrackers(Primitive primitive, List<PropertyTracker<T>> trackers) {
        if (!trackers.isEmpty()) {
            Iterable<String> propertyKeys = primitive.getPropertyKeys(this);
            PropertyContainer proxy = primitive.asProxy(this);
            for (String key : propertyKeys) {
                Object value = primitive.getProperty(this, ((Token)this.propertyKeyTokenHolder.getTokenByNameOrNull(key)).id());
                for (PropertyTracker<PropertyContainer> propertyTracker : trackers) {
                    propertyTracker.propertyRemoved(proxy, key, value);
                }
            }
        }
    }

    public ArrayMap<Integer, PropertyData> deleteNode(NodeImpl node, TransactionState tx) {
        this.deleteFromTrackers(node, this.nodePropertyTrackers);
        tx.deleteNode(node.getId());
        return this.persistenceManager.nodeDelete(node.getId());
    }

    PropertyData nodeAddProperty(NodeImpl node, Token index, Object value) {
        if (!this.nodePropertyTrackers.isEmpty()) {
            for (PropertyTracker<Node> nodePropertyTracker : this.nodePropertyTrackers) {
                nodePropertyTracker.propertyAdded(this.getNodeById(node.getId()), index.name(), value);
            }
        }
        return this.persistenceManager.nodeAddProperty(node.getId(), index, value);
    }

    PropertyData nodeChangeProperty(NodeImpl node, PropertyData property, Object value, TransactionState tx) {
        if (!this.nodePropertyTrackers.isEmpty()) {
            for (PropertyTracker<Node> nodePropertyTracker : this.nodePropertyTrackers) {
                nodePropertyTracker.propertyChanged(this.getNodeById(node.getId()), this.getPropertyKeyTokenOrNull(property.getIndex()).name(), property.getValue(), value);
            }
        }
        return this.persistenceManager.nodeChangeProperty(node.getId(), property, value);
    }

    void nodeRemoveProperty(NodeImpl node, PropertyData property, TransactionState tx) {
        if (!this.nodePropertyTrackers.isEmpty()) {
            for (PropertyTracker<Node> nodePropertyTracker : this.nodePropertyTrackers) {
                nodePropertyTracker.propertyRemoved(this.getNodeById(node.getId()), this.getPropertyKeyTokenOrNull(property.getIndex()).name(), property.getValue());
            }
        }
        this.persistenceManager.nodeRemoveProperty(node.getId(), property);
    }

    PropertyData graphAddProperty(Token index, Object value) {
        return this.persistenceManager.graphAddProperty(index, value);
    }

    PropertyData graphChangeProperty(PropertyData property, Object value) {
        return this.persistenceManager.graphChangeProperty(property, value);
    }

    void graphRemoveProperty(PropertyData property) {
        this.persistenceManager.graphRemoveProperty(property);
    }

    ArrayMap<Integer, PropertyData> deleteRelationship(RelationshipImpl rel, TransactionState tx) {
        this.deleteFromTrackers(rel, this.relationshipPropertyTrackers);
        tx.deleteRelationship(rel.getId());
        return this.persistenceManager.relDelete(rel.getId());
    }

    PropertyData relAddProperty(RelationshipImpl rel, Token index, Object value) {
        if (!this.relationshipPropertyTrackers.isEmpty()) {
            for (PropertyTracker<Relationship> relPropertyTracker : this.relationshipPropertyTrackers) {
                relPropertyTracker.propertyAdded(this.getRelationshipById(rel.getId()), index.name(), value);
            }
        }
        return this.persistenceManager.relAddProperty(rel.getId(), index, value);
    }

    PropertyData relChangeProperty(RelationshipImpl rel, PropertyData property, Object value, TransactionState tx) {
        if (!this.relationshipPropertyTrackers.isEmpty()) {
            for (PropertyTracker<Relationship> relPropertyTracker : this.relationshipPropertyTrackers) {
                relPropertyTracker.propertyChanged(this.getRelationshipById(rel.getId()), this.getPropertyKeyTokenOrNull(property.getIndex()).name(), property.getValue(), value);
            }
        }
        return this.persistenceManager.relChangeProperty(rel.getId(), property, value);
    }

    void relRemoveProperty(RelationshipImpl rel, PropertyData property, TransactionState tx) {
        if (!this.relationshipPropertyTrackers.isEmpty()) {
            for (PropertyTracker<Relationship> relPropertyTracker : this.relationshipPropertyTrackers) {
                relPropertyTracker.propertyRemoved(this.getRelationshipById(rel.getId()), this.getPropertyKeyTokenOrNull(property.getIndex()).name(), property.getValue());
            }
        }
        this.persistenceManager.relRemoveProperty(rel.getId(), property);
    }

    public NodeImpl getNodeIfCached(long nodeId) {
        return this.nodeCache.getIfCached(nodeId);
    }

    public RelationshipImpl getRelIfCached(long nodeId) {
        return this.relCache.getIfCached(nodeId);
    }

    public void addRelationshipTypeToken(Token type) {
        this.relTypeHolder.addTokens(type);
    }

    public void addLabelToken(Token type) {
        this.labelTokenHolder.addTokens(type);
    }

    public void addPropertyKeyToken(Token index) {
        this.propertyKeyTokenHolder.addTokens(index);
    }

    public String getKeyForProperty(PropertyData property) {
        try {
            return ((Token)this.propertyKeyTokenHolder.getTokenById(property.getIndex())).name();
        }
        catch (TokenNotFoundException e) {
            throw new ThisShouldNotHappenError("Mattias", "The key should exist at this point");
        }
    }

    public RelationshipTypeTokenHolder getRelationshipTypeHolder() {
        return this.relTypeHolder;
    }

    public void addNodePropertyTracker(PropertyTracker<Node> nodePropertyTracker) {
        this.nodePropertyTrackers.add(nodePropertyTracker);
    }

    public void removeNodePropertyTracker(PropertyTracker<Node> nodePropertyTracker) {
        this.nodePropertyTrackers.remove(nodePropertyTracker);
    }

    public void addRelationshipPropertyTracker(PropertyTracker<Relationship> relationshipPropertyTracker) {
        this.relationshipPropertyTrackers.add(relationshipPropertyTracker);
    }

    public void removeRelationshipPropertyTracker(PropertyTracker<Relationship> relationshipPropertyTracker) {
        this.relationshipPropertyTrackers.remove(relationshipPropertyTracker);
    }

    public boolean isDeleted(PropertyContainer entity) {
        if (entity instanceof Node) {
            return this.isDeleted((Node)entity);
        }
        if (entity instanceof Relationship) {
            return this.isDeleted((Relationship)entity);
        }
        throw new IllegalArgumentException("Unknown entity type: " + entity + ", " + entity.getClass());
    }

    public boolean isDeleted(Node resource) {
        return this.getTransactionState().nodeIsDeleted(resource.getId());
    }

    public boolean isDeleted(Relationship resource) {
        return this.getTransactionState().relationshipIsDeleted(resource.getId());
    }

    private GraphProperties instantiateGraphProperties() {
        return new GraphProperties(this);
    }

    public GraphProperties getGraphProperties() {
        return this.graphProperties;
    }

    public void removeGraphPropertiesFromCache() {
        this.graphProperties = this.instantiateGraphProperties();
    }

    void updateCacheSize(NodeImpl node, int newSize) {
        this.nodeCache.updateSize(node, newSize);
    }

    void updateCacheSize(RelationshipImpl rel, int newSize) {
        this.relCache.updateSize(rel, newSize);
    }

    public TransactionState getTransactionState() {
        return this.transactionManager.getTransactionState();
    }
}

