/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.graphdb.event.TransactionData;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.impl.core.LockElement;
import org.neo4j.kernel.impl.core.NodeImpl;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.core.NodeProxy;
import org.neo4j.kernel.impl.core.Primitive;
import org.neo4j.kernel.impl.core.RelationshipImpl;
import org.neo4j.kernel.impl.core.RelationshipProxy;
import org.neo4j.kernel.impl.core.TransactionDataImpl;
import org.neo4j.kernel.impl.core.TransactionState;
import org.neo4j.kernel.impl.nioneo.store.PropertyData;
import org.neo4j.kernel.impl.nioneo.store.Record;
import org.neo4j.kernel.impl.transaction.LockManager;
import org.neo4j.kernel.impl.transaction.LockType;
import org.neo4j.kernel.impl.transaction.TxHook;
import org.neo4j.kernel.impl.transaction.xaframework.TxIdGenerator;
import org.neo4j.kernel.impl.util.ArrayMap;
import org.neo4j.kernel.impl.util.RelIdArray;
import org.neo4j.kernel.impl.util.RelIdArrayWithLoops;
import org.neo4j.kernel.impl.util.RelIdIterator;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.logging.Logging;

public class WritableTransactionState
implements TransactionState {
    private final LockManager lockManager;
    private final NodeManager nodeManager;
    private final StringLogger log;
    private final Transaction tx;
    private final TxHook txHook;
    private final TxIdGenerator txIdGenerator;
    private List<LockElement> lockElements;
    private PrimitiveElement primitiveElement;

    public WritableTransactionState(LockManager lockManager, NodeManager nodeManager, Logging logging, Transaction tx, TxHook txHook, TxIdGenerator txIdGenerator) {
        this.lockManager = lockManager;
        this.nodeManager = nodeManager;
        this.tx = tx;
        this.txHook = txHook;
        this.txIdGenerator = txIdGenerator;
        this.log = logging.getMessagesLog(this.getClass());
    }

    @Override
    public LockElement acquireWriteLock(Object resource) {
        this.lockManager.getWriteLock(resource, this.tx);
        LockElement lock = new LockElement(resource, this.tx, LockType.WRITE, this.lockManager);
        this.addLockToTransaction(lock);
        return lock;
    }

    @Override
    public LockElement acquireReadLock(Object resource) {
        this.lockManager.getReadLock(resource, this.tx);
        LockElement lock = new LockElement(resource, this.tx, LockType.READ, this.lockManager);
        this.addLockToTransaction(lock);
        return lock;
    }

    private void addLockToTransaction(LockElement lock) {
        boolean firstLock = false;
        if (this.lockElements == null) {
            this.lockElements = new ArrayList<LockElement>();
            firstLock = true;
        }
        this.lockElements.add(lock);
        if (firstLock) {
            try {
                this.tx.registerSynchronization((Synchronization)new ReadOnlyTxReleaser());
            }
            catch (Exception e) {
                throw new TransactionFailureException("Failed to register lock release synchronization hook", e);
            }
        }
    }

    @Override
    public ArrayMap<Integer, Collection<Long>> getCowRelationshipRemoveMap(NodeImpl node) {
        ArrayMap cowElements;
        CowNodeElement element;
        if (this.primitiveElement != null && (element = (CowNodeElement)(cowElements = this.primitiveElement.nodes).get(node.getId())) != null) {
            return element.relationshipRemoveMap;
        }
        return null;
    }

    @Override
    public Collection<Long> getOrCreateCowRelationshipRemoveMap(NodeImpl node, int type) {
        return this.getPrimitiveElement(true).nodeElement(node.getId(), true).getRelationshipRemoveMap(type, true);
    }

    @Override
    public void setFirstIds(long nodeId, long firstRel, long firstProp) {
        CowNodeElement nodeElement = this.getPrimitiveElement(true).nodeElement(nodeId, true);
        nodeElement.firstRel = firstRel;
        nodeElement.firstProp = firstProp;
    }

    @Override
    public ArrayMap<Integer, RelIdArray> getCowRelationshipAddMap(NodeImpl node) {
        PrimitiveElement primitiveElement = this.getPrimitiveElement(false);
        if (primitiveElement == null) {
            return null;
        }
        CowNodeElement element = primitiveElement.nodeElement(node.getId(), false);
        return element != null ? element.relationshipAddMap : null;
    }

    @Override
    public RelIdArray getOrCreateCowRelationshipAddMap(NodeImpl node, int type) {
        return this.getPrimitiveElement(true).nodeElement(node.getId(), true).getRelationshipAddMap(type, true);
    }

    @Override
    public void commit() {
        this.releaseLocks();
    }

    @Override
    public void commitCows() {
        this.releaseCows(3);
    }

    @Override
    public void rollback() {
        this.releaseCows(4);
        this.releaseLocks();
    }

    @Override
    public boolean hasLocks() {
        return this.lockElements != null && !this.lockElements.isEmpty();
    }

    private void releaseLocks() {
        if (this.lockElements != null) {
            ArrayList<LockElement> releaseFailures = null;
            Exception releaseException = null;
            for (LockElement lockElement : this.lockElements) {
                try {
                    lockElement.releaseIfAcquired();
                }
                catch (Exception e) {
                    releaseException = e;
                    if (releaseFailures == null) {
                        releaseFailures = new ArrayList<LockElement>();
                    }
                    releaseFailures.add(lockElement);
                }
            }
            if (releaseException != null) {
                this.log.warn("Unable to release locks: " + releaseFailures + ". Example of exception:" + releaseException);
            }
        }
    }

    private void releaseCows(int param) {
        if (this.primitiveElement == null) {
            return;
        }
        ArrayMap cowNodeElements = this.primitiveElement.nodes;
        Set nodeEntrySet = cowNodeElements.entrySet();
        for (Map.Entry entry : nodeEntrySet) {
            NodeImpl node = this.nodeManager.getNodeIfCached((Long)entry.getKey());
            if (node == null) continue;
            CowNodeElement nodeElement = (CowNodeElement)entry.getValue();
            if (param == 3) {
                node.commitRelationshipMaps(nodeElement.relationshipAddMap, nodeElement.relationshipRemoveMap, nodeElement.firstRel, this.nodeManager);
                node.commitPropertyMaps(nodeElement.propertyAddMap, nodeElement.propertyRemoveMap, nodeElement.firstProp, this.nodeManager);
            } else if (param != 4) {
                throw new TransactionFailureException("Unknown transaction status: " + param);
            }
            int sizeAfter = node.size();
            this.nodeManager.updateCacheSize(node, sizeAfter);
        }
        ArrayMap cowRelElements = this.primitiveElement.relationships;
        Set relEntrySet = cowRelElements.entrySet();
        for (Map.Entry entry : relEntrySet) {
            RelationshipImpl rel = this.nodeManager.getRelIfCached((Long)entry.getKey());
            if (rel == null) continue;
            CowRelElement relElement = (CowRelElement)entry.getValue();
            if (param == 3) {
                rel.commitPropertyMaps(relElement.propertyAddMap, relElement.propertyRemoveMap, Record.NO_NEXT_PROPERTY.intValue(), this.nodeManager);
            } else if (param != 4) {
                throw new TransactionFailureException("Unknown transaction status: " + param);
            }
            int sizeAfter = rel.size();
            this.nodeManager.updateCacheSize(rel, sizeAfter);
        }
        if (this.primitiveElement.graph != null && param == 3) {
            this.nodeManager.getGraphProperties().commitPropertyMaps(this.primitiveElement.graph.getPropertyAddMap(false), this.primitiveElement.graph.getPropertyRemoveMap(false), Record.NO_NEXT_PROPERTY.intValue(), this.nodeManager);
        }
    }

    @Override
    public ArrayMap<Integer, PropertyData> getCowPropertyRemoveMap(Primitive primitive) {
        if (this.primitiveElement == null) {
            return null;
        }
        CowEntityElement element = primitive.getEntityElement(this.primitiveElement, false);
        return element != null ? element.getPropertyRemoveMap(false) : null;
    }

    @Override
    public ArrayMap<Integer, PropertyData> getCowPropertyAddMap(Primitive primitive) {
        if (this.primitiveElement == null) {
            return null;
        }
        CowEntityElement element = primitive.getEntityElement(this.primitiveElement, false);
        return element != null ? element.getPropertyAddMap(false) : null;
    }

    private PrimitiveElement getPrimitiveElement(boolean create) {
        if (this.primitiveElement == null && create) {
            this.primitiveElement = new PrimitiveElement();
        }
        return this.primitiveElement;
    }

    @Override
    public ArrayMap<Integer, PropertyData> getOrCreateCowPropertyAddMap(Primitive primitive) {
        return primitive.getEntityElement(this.getPrimitiveElement(true), true).getPropertyAddMap(true);
    }

    @Override
    public ArrayMap<Integer, PropertyData> getOrCreateCowPropertyRemoveMap(Primitive primitive) {
        return primitive.getEntityElement(this.getPrimitiveElement(true), true).getPropertyRemoveMap(true);
    }

    @Override
    public void createNode(long id) {
        this.getPrimitiveElement(true).createdNodes.add(id);
    }

    @Override
    public void createRelationship(long id) {
        this.getPrimitiveElement(true).createdRelationships.add(id);
    }

    @Override
    public void deleteNode(long id) {
        PrimitiveElement element = this.getPrimitiveElement(true);
        element.nodeElement(id, true).setDeleted();
        element.createdNodes.remove(id);
    }

    @Override
    public void deleteRelationship(long id) {
        PrimitiveElement element = this.getPrimitiveElement(true);
        element.relationshipElement(id, true).setDeleted();
        element.createdRelationships.remove(id);
    }

    @Override
    public TransactionData getTransactionData() {
        TransactionDataImpl result = new TransactionDataImpl();
        this.populateCreatedNodes(this.primitiveElement, result);
        if (this.primitiveElement == null) {
            return result;
        }
        this.populateNodeRelEvent(this.primitiveElement, result);
        this.populateRelationshipPropertyEvents(this.primitiveElement, result);
        return result;
    }

    private void populateRelationshipPropertyEvents(PrimitiveElement element, TransactionDataImpl result) {
        Iterator i$ = element.relationships.keySet().iterator();
        while (i$.hasNext()) {
            Object oldValue;
            String key;
            long relId = (Long)i$.next();
            CowRelElement relElement = (CowRelElement)element.relationships.get(relId);
            RelationshipProxy rel = this.nodeManager.newRelationshipProxyById(relId);
            RelationshipImpl relImpl = this.nodeManager.getRelationshipForProxy(relId, null);
            if (relElement.isDeleted() && this.primitiveElement.createdRelationships.contains(relId)) continue;
            if (relElement.propertyAddMap != null && !relElement.isDeleted()) {
                for (PropertyData data : relElement.propertyAddMap.values()) {
                    key = this.nodeManager.getKeyForProperty(data);
                    oldValue = relImpl.getCommittedPropertyValue(this.nodeManager, key);
                    Object newValue = data.getValue();
                    result.assignedProperty(rel, key, newValue, oldValue);
                }
            }
            if (relElement.propertyRemoveMap == null) continue;
            for (PropertyData data : relElement.propertyRemoveMap.values()) {
                key = this.nodeManager.getKeyForProperty(data);
                oldValue = data.getValue();
                if (oldValue != null && !relElement.isDeleted()) {
                    relImpl.getCommittedPropertyValue(this.nodeManager, key);
                }
                result.removedProperty(rel, key, oldValue);
            }
        }
    }

    private void populateNodeRelEvent(PrimitiveElement element, TransactionDataImpl result) {
        Iterator i$ = element.nodes.keySet().iterator();
        while (i$.hasNext()) {
            Object oldValue;
            String key;
            long nodeId = (Long)i$.next();
            CowNodeElement nodeElement = (CowNodeElement)element.nodes.get(nodeId);
            NodeProxy node = this.nodeManager.newNodeProxyById(nodeId);
            NodeImpl nodeImpl = this.nodeManager.getNodeForProxy(nodeId, null);
            if (nodeElement.isDeleted()) {
                if (this.primitiveElement.createdNodes.contains(nodeId)) continue;
                result.deleted(node);
            }
            if (nodeElement.relationshipAddMap != null && !nodeElement.isDeleted()) {
                for (Integer type : nodeElement.relationshipAddMap.keySet()) {
                    RelIdArray createdRels = (RelIdArray)nodeElement.relationshipAddMap.get(type);
                    this.populateNodeRelEvent(element, result, nodeId, createdRels);
                }
            }
            if (nodeElement.relationshipRemoveMap != null) {
                for (Integer type : nodeElement.relationshipRemoveMap.keySet()) {
                    Collection deletedRels = (Collection)nodeElement.relationshipRemoveMap.get(type);
                    Iterator i$2 = deletedRels.iterator();
                    while (i$2.hasNext()) {
                        RelationshipProxy rel;
                        long relId = (Long)i$2.next();
                        if (this.primitiveElement.createdRelationships.contains(relId) || (rel = this.nodeManager.newRelationshipProxyById(relId)).getStartNode().getId() != nodeId) continue;
                        result.deleted(this.nodeManager.newRelationshipProxyById(relId));
                    }
                }
            }
            if (nodeElement.propertyAddMap != null && !nodeElement.isDeleted()) {
                for (PropertyData data : nodeElement.propertyAddMap.values()) {
                    key = this.nodeManager.getKeyForProperty(data);
                    oldValue = nodeImpl.getCommittedPropertyValue(this.nodeManager, key);
                    Object newValue = data.getValue();
                    result.assignedProperty(node, key, newValue, oldValue);
                }
            }
            if (nodeElement.propertyRemoveMap == null) continue;
            for (PropertyData data : nodeElement.propertyRemoveMap.values()) {
                key = this.nodeManager.getKeyForProperty(data);
                oldValue = data.getValue();
                if (oldValue == null && !nodeElement.isDeleted()) {
                    nodeImpl.getCommittedPropertyValue(this.nodeManager, key);
                }
                result.removedProperty(node, key, oldValue);
            }
        }
    }

    private void populateNodeRelEvent(PrimitiveElement element, TransactionDataImpl result, long nodeId, RelIdArray createdRels) {
        RelIdIterator iterator = createdRels.iterator(RelIdArray.DirectionWrapper.BOTH);
        while (iterator.hasNext()) {
            RelationshipProxy rel;
            long relId = iterator.next();
            CowRelElement relElement = (CowRelElement)element.relationships.get(relId);
            if (relElement != null && relElement.isDeleted() || (rel = this.nodeManager.newRelationshipProxyById(relId)).getStartNode().getId() != nodeId) continue;
            result.created(this.nodeManager.newRelationshipProxyById(relId));
        }
    }

    private void populateCreatedNodes(PrimitiveElement element, TransactionDataImpl result) {
        for (Long nodeId : this.getCreatedNodes()) {
            CowNodeElement nodeElement;
            if (element != null && (nodeElement = (CowNodeElement)element.nodes.get(nodeId)) != null && nodeElement.isDeleted()) continue;
            result.created(this.nodeManager.newNodeProxyById(nodeId));
        }
    }

    @Override
    public Set<Long> getCreatedNodes() {
        return this.primitiveElement != null ? this.primitiveElement.createdNodes : Collections.emptySet();
    }

    @Override
    public Set<Long> getCreatedRelationships() {
        return this.primitiveElement != null ? this.primitiveElement.createdRelationships : Collections.emptySet();
    }

    @Override
    public Iterable<CowNodeElement> getChangedNodes() {
        if (this.primitiveElement == null) {
            return Iterables.empty();
        }
        return this.primitiveElement.nodes.values();
    }

    @Override
    public boolean nodeIsDeleted(long nodeId) {
        if (this.primitiveElement == null) {
            return false;
        }
        CowNodeElement nodeElement = this.primitiveElement.nodeElement(nodeId, false);
        return nodeElement != null && nodeElement.isDeleted();
    }

    @Override
    public boolean relationshipIsDeleted(long relationshipId) {
        if (this.primitiveElement == null) {
            return false;
        }
        CowRelElement relationshipElement = this.primitiveElement.relationshipElement(relationshipId, false);
        return relationshipElement != null && relationshipElement.isDeleted();
    }

    @Override
    public boolean hasChanges() {
        return this.primitiveElement != null || this.lockElements != null;
    }

    @Override
    public void setRollbackOnly() {
        try {
            this.tx.setRollbackOnly();
        }
        catch (IllegalStateException e) {
            this.log.warn("Failed to set transaction rollback only", e);
        }
        catch (SystemException se) {
            this.log.warn("Failed to set transaction rollback only", se);
        }
    }

    @Override
    public TxHook getTxHook() {
        return this.txHook;
    }

    @Override
    public TxIdGenerator getTxIdGenerator() {
        return this.txIdGenerator;
    }

    private class ReadOnlyTxReleaser
    implements Synchronization {
        private ReadOnlyTxReleaser() {
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            WritableTransactionState.this.releaseLocks();
        }
    }

    public static class CowGraphElement
    extends CowEntityElement {
        CowGraphElement() {
            super(-1L);
        }

        public String toString() {
            return "Graph";
        }
    }

    public static class CowRelElement
    extends CowEntityElement {
        CowRelElement(long id) {
            super(id);
        }

        public String toString() {
            return "Relationship[" + this.id + "]";
        }
    }

    public static class CowNodeElement
    extends CowEntityElement {
        private long firstRel = Record.NO_NEXT_RELATIONSHIP.intValue();
        private long firstProp = Record.NO_NEXT_PROPERTY.intValue();
        private ArrayMap<Integer, RelIdArray> relationshipAddMap;
        private ArrayMap<Integer, Collection<Long>> relationshipRemoveMap;

        CowNodeElement(long id) {
            super(id);
        }

        public ArrayMap<Integer, RelIdArray> getRelationshipAddMap(boolean create) {
            if (this.relationshipAddMap == null && create) {
                this.relationshipAddMap = new ArrayMap();
            }
            return this.relationshipAddMap;
        }

        public RelIdArray getRelationshipAddMap(int type, boolean create) {
            ArrayMap<Integer, RelIdArray> map = this.getRelationshipAddMap(create);
            if (map == null) {
                return null;
            }
            RelIdArray result = map.get(type);
            if (result == null && create) {
                result = new RelIdArrayWithLoops(type);
                map.put(type, result);
            }
            return result;
        }

        public ArrayMap<Integer, Collection<Long>> getRelationshipRemoveMap(boolean create) {
            if (this.relationshipRemoveMap == null && create) {
                this.relationshipRemoveMap = new ArrayMap();
            }
            return this.relationshipRemoveMap;
        }

        public Collection<Long> getRelationshipRemoveMap(int type, boolean create) {
            ArrayMap<Integer, Collection<Long>> map = this.getRelationshipRemoveMap(create);
            if (map == null) {
                return null;
            }
            Collection<Long> result = map.get(type);
            if (result == null && create) {
                result = new HashSet<Long>();
                map.put(type, result);
            }
            return result;
        }

        public String toString() {
            return "Node[" + this.id + "]";
        }
    }

    static class CowEntityElement {
        protected long id;
        protected boolean deleted;
        protected ArrayMap<Integer, PropertyData> propertyAddMap;
        protected ArrayMap<Integer, PropertyData> propertyRemoveMap;

        CowEntityElement(long id) {
            this.id = id;
        }

        public long getId() {
            return this.id;
        }

        public ArrayMap<Integer, PropertyData> getPropertyAddMap(boolean create) {
            this.assertNotDeleted();
            if (this.propertyAddMap == null && create) {
                this.propertyAddMap = new ArrayMap();
            }
            return this.propertyAddMap;
        }

        private void assertNotDeleted() {
            if (this.isDeleted()) {
                throw new IllegalStateException(this + " has been deleted in this tx");
            }
        }

        public boolean isDeleted() {
            return this.deleted;
        }

        public void setDeleted() {
            this.deleted = true;
        }

        public ArrayMap<Integer, PropertyData> getPropertyRemoveMap(boolean create) {
            if (this.propertyRemoveMap == null && create) {
                this.propertyRemoveMap = new ArrayMap();
            }
            return this.propertyRemoveMap;
        }
    }

    public static class PrimitiveElement {
        private final ArrayMap<Long, CowNodeElement> nodes = new ArrayMap();
        private final ArrayMap<Long, CowRelElement> relationships = new ArrayMap();
        private final Set<Long> createdNodes = new HashSet<Long>();
        private final Set<Long> createdRelationships = new HashSet<Long>();
        private CowGraphElement graph;

        PrimitiveElement() {
        }

        public CowNodeElement nodeElement(long id, boolean create) {
            CowNodeElement result = this.nodes.get(id);
            if (result == null && create) {
                result = new CowNodeElement(id);
                this.nodes.put(id, result);
            }
            return result;
        }

        public CowRelElement relationshipElement(long id, boolean create) {
            CowRelElement result = this.relationships.get(id);
            if (result == null && create) {
                result = new CowRelElement(id);
                this.relationships.put(id, result);
            }
            return result;
        }

        public CowGraphElement graphElement(boolean create) {
            if (this.graph == null && create) {
                this.graph = new CowGraphElement();
            }
            return this.graph;
        }
    }
}

