/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.neo4j.kernel.impl.nioneo.store.Buffer;
import org.neo4j.kernel.impl.nioneo.store.InvalidRecordException;
import org.neo4j.kernel.impl.nioneo.store.LockableWindow;
import org.neo4j.kernel.impl.nioneo.store.OperationType;
import org.neo4j.kernel.impl.nioneo.store.UnderlyingStorageException;

class PersistenceRow
extends LockableWindow {
    private State bufferState = State.EMPTY;
    private int recordSize = -1;
    private final long position;
    private final Buffer buffer;

    PersistenceRow(long position, int recordSize, FileChannel channel) {
        super(channel);
        assert (position >= 0L) : "Illegal position[" + position + "]";
        assert (recordSize > 0) : "Illegal recordSize[" + recordSize + "]";
        assert (channel != null) : "Null file channel";
        this.position = position;
        this.recordSize = recordSize;
        this.buffer = new Buffer(this, ByteBuffer.allocate(recordSize));
        this.markAsInUse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void lock(OperationType operationType) {
        super.lock(operationType);
        boolean success = false;
        try {
            this.bufferState = this.bufferState.transition(operationType, this);
            success = true;
        }
        finally {
            if (!success) {
                this.unLock();
            }
        }
    }

    public boolean isDirty() {
        return this.bufferState == State.DIRTY;
    }

    @Override
    public Buffer getBuffer() {
        return this.buffer;
    }

    @Override
    public int getRecordSize() {
        return this.recordSize;
    }

    @Override
    public Buffer getOffsettedBuffer(long id) {
        if (id != this.buffer.position()) {
            throw new InvalidRecordException("Id[" + id + "] not equal to buffer position[" + this.buffer.position() + "]");
        }
        return this.buffer;
    }

    @Override
    public long position() {
        return this.position;
    }

    void readFullWindow() {
        try {
            ByteBuffer byteBuffer = this.buffer.getBuffer();
            byteBuffer.clear();
            this.getFileChannel().read(byteBuffer, this.position * (long)this.recordSize);
            byteBuffer.clear();
        }
        catch (IOException e) {
            throw new UnderlyingStorageException("Unable to load position[" + this.position + "] @[" + this.position * (long)this.recordSize + "]", e);
        }
    }

    private void writeContents() {
        if (this.isDirty()) {
            ByteBuffer byteBuffer = this.buffer.getBuffer().duplicate();
            byteBuffer.clear();
            try {
                int written = 0;
                while (byteBuffer.hasRemaining()) {
                    int writtenThisTime = this.getFileChannel().write(byteBuffer, this.position * (long)this.recordSize + (long)written);
                    if (writtenThisTime == 0) {
                        throw new IOException("Unable to write to disk, reported bytes written was 0");
                    }
                    written += writtenThisTime;
                }
            }
            catch (IOException e) {
                throw new UnderlyingStorageException("Unable to write record[" + this.position + "] @[" + this.position * (long)this.recordSize + "]", e);
            }
        }
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public void force() {
        this.writeContents();
    }

    public boolean equals(Object o) {
        if (!(o instanceof PersistenceRow)) {
            return false;
        }
        return this.position() == ((PersistenceRow)o).position();
    }

    public int hashCode() {
        return (int)this.position;
    }

    public String toString() {
        return "PersistenceRow[" + this.position + "]";
    }

    @Override
    public synchronized void close() {
        this.buffer.close();
        this.closed = true;
    }

    public void reset() {
        this.buffer.reset();
    }

    private static enum State {
        EMPTY{

            @Override
            State transition(OperationType operationType, PersistenceRow persistenceRow) {
                switch (operationType) {
                    case READ: {
                        persistenceRow.readFullWindow();
                        return CLEAN;
                    }
                    case WRITE: {
                        return DIRTY;
                    }
                }
                throw new IllegalStateException("Unknown operation type: " + (Object)((Object)operationType));
            }
        }
        ,
        CLEAN{

            @Override
            State transition(OperationType operationType, PersistenceRow persistenceRow) {
                switch (operationType) {
                    case READ: {
                        return CLEAN;
                    }
                    case WRITE: {
                        return DIRTY;
                    }
                }
                throw new IllegalStateException("Unknown operation type: " + (Object)((Object)operationType));
            }
        }
        ,
        DIRTY{

            @Override
            State transition(OperationType operationType, PersistenceRow persistenceRow) {
                return DIRTY;
            }
        };


        abstract State transition(OperationType var1, PersistenceRow var2);
    }
}

