/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.xaframework;

import java.io.File;
import org.neo4j.kernel.TransactionInterceptorProviders;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.transaction.AbstractTransactionManager;
import org.neo4j.kernel.impl.transaction.TransactionStateFactory;
import org.neo4j.kernel.impl.transaction.xaframework.InterceptingXaLogicalLog;
import org.neo4j.kernel.impl.transaction.xaframework.LogBufferFactory;
import org.neo4j.kernel.impl.transaction.xaframework.LogPruneStrategy;
import org.neo4j.kernel.impl.transaction.xaframework.RecoveryVerifier;
import org.neo4j.kernel.impl.transaction.xaframework.TxIdGenerator;
import org.neo4j.kernel.impl.transaction.xaframework.XaCommandFactory;
import org.neo4j.kernel.impl.transaction.xaframework.XaContainer;
import org.neo4j.kernel.impl.transaction.xaframework.XaDataSource;
import org.neo4j.kernel.impl.transaction.xaframework.XaLogicalLog;
import org.neo4j.kernel.impl.transaction.xaframework.XaResourceManager;
import org.neo4j.kernel.impl.transaction.xaframework.XaTransactionFactory;
import org.neo4j.kernel.logging.Logging;

public class XaFactory {
    private final TxIdGenerator txIdGenerator;
    private final AbstractTransactionManager txManager;
    private final LogBufferFactory logBufferFactory;
    private final FileSystemAbstraction fileSystemAbstraction;
    private final Logging logging;
    private final RecoveryVerifier recoveryVerifier;
    private final LogPruneStrategy pruneStrategy;

    public XaFactory(TxIdGenerator txIdGenerator, AbstractTransactionManager txManager, LogBufferFactory logBufferFactory, FileSystemAbstraction fileSystemAbstraction, Logging logging, RecoveryVerifier recoveryVerifier, LogPruneStrategy pruneStrategy) {
        this.txIdGenerator = txIdGenerator;
        this.txManager = txManager;
        this.logBufferFactory = logBufferFactory;
        this.fileSystemAbstraction = fileSystemAbstraction;
        this.logging = logging;
        this.recoveryVerifier = recoveryVerifier;
        this.pruneStrategy = pruneStrategy;
    }

    public XaContainer newXaContainer(XaDataSource xaDataSource, File logicalLog, XaCommandFactory cf, XaTransactionFactory tf, TransactionStateFactory stateFactory, TransactionInterceptorProviders providers) {
        if (logicalLog == null || cf == null || tf == null) {
            throw new IllegalArgumentException("Null parameter, LogicalLog[" + logicalLog + "] CommandFactory[" + cf + "TransactionFactory[" + tf + "]");
        }
        XaResourceManager rm = new XaResourceManager(xaDataSource, tf, this.txIdGenerator, this.txManager, this.recoveryVerifier, logicalLog.getName());
        XaLogicalLog log = providers.shouldInterceptDeserialized() && providers.hasAnyInterceptorConfigured() ? new InterceptingXaLogicalLog(logicalLog, rm, cf, tf, providers, this.logBufferFactory, this.fileSystemAbstraction, this.logging, this.pruneStrategy, stateFactory) : new XaLogicalLog(logicalLog, rm, cf, tf, this.logBufferFactory, this.fileSystemAbstraction, this.logging, this.pruneStrategy, stateFactory);
        rm.setLogicalLog(log);
        tf.setLogicalLog(log);
        return new XaContainer(rm, log);
    }
}

