/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.mongodb.query.parsing.impl;

import com.mongodb.DBObject;
import java.util.Map;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.engine.query.spi.ParameterMetadata;
import org.hibernate.engine.query.spi.sql.NativeSQLQueryReturn;
import org.hibernate.engine.query.spi.sql.NativeSQLQuerySpecification;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.hql.QueryParser;
import org.hibernate.hql.ast.spi.AstProcessingChain;
import org.hibernate.hql.ast.spi.EntityNamesResolver;
import org.hibernate.ogm.OgmSession;
import org.hibernate.ogm.datastore.mongodb.logging.impl.Log;
import org.hibernate.ogm.datastore.mongodb.logging.impl.LoggerFactory;
import org.hibernate.ogm.datastore.mongodb.query.impl.DBObjectQuerySpecification;
import org.hibernate.ogm.datastore.mongodb.query.parsing.impl.MongoDBProcessingChain;
import org.hibernate.ogm.datastore.mongodb.query.parsing.impl.MongoDBQueryParsingResult;
import org.hibernate.ogm.jpa.impl.NoSQLQueryImpl;
import org.hibernate.ogm.persister.OgmEntityPersister;
import org.hibernate.ogm.service.impl.BaseQueryParserService;
import org.hibernate.ogm.service.impl.SessionFactoryEntityNamesResolver;

public class MongoDBBasedQueryParserService
extends BaseQueryParserService {
    private static final Log log = LoggerFactory.getLogger();
    private volatile SessionFactoryEntityNamesResolver entityNamesResolver;

    public Query getParsedQueryExecutor(OgmSession session, String queryString, Map<String, Object> namedParameters) {
        QueryParser queryParser = new QueryParser();
        MongoDBProcessingChain processingChain = this.createProcessingChain((Session)session, this.unwrap(namedParameters));
        MongoDBQueryParsingResult result = (MongoDBQueryParsingResult)queryParser.parseQuery(queryString, (AstProcessingChain)processingChain);
        log.createdQuery(queryString, result);
        SessionImplementor sessionImplementor = (SessionImplementor)session;
        String tableName = ((OgmEntityPersister)sessionImplementor.getFactory().getEntityPersister(result.getEntityType().getName())).getTableName();
        DBObjectQuery query = new DBObjectQuery(tableName, result.getQuery(), result.getProjection(), result.getOrderBy(), sessionImplementor, new ParameterMetadata(null, null));
        if (result.getProjection() != null) {
            for (String field : result.getProjection().keySet()) {
                query.addScalar(field);
            }
        } else {
            query.addEntity(result.getEntityType());
        }
        return query;
    }

    private MongoDBProcessingChain createProcessingChain(Session session, Map<String, Object> namedParameters) {
        EntityNamesResolver entityNamesResolver = this.getDefinedEntityNames(session.getSessionFactory());
        return new MongoDBProcessingChain((SessionFactoryImplementor)session.getSessionFactory(), entityNamesResolver, namedParameters);
    }

    private EntityNamesResolver getDefinedEntityNames(SessionFactory sessionFactory) {
        if (this.entityNamesResolver == null) {
            this.entityNamesResolver = new SessionFactoryEntityNamesResolver(sessionFactory);
        }
        return this.entityNamesResolver;
    }

    private static class DBObjectQuery
    extends NoSQLQueryImpl {
        private final String collectionName;
        private final DBObject query;
        private final DBObject projection;
        private final DBObject orderBy;

        public DBObjectQuery(String collectionName, DBObject query, DBObject projection, DBObject orderBy, SessionImplementor session, ParameterMetadata parameterMetadata) {
            super(query.toString(), session, parameterMetadata);
            this.collectionName = collectionName;
            this.query = query;
            this.projection = projection;
            this.orderBy = orderBy;
        }

        protected NativeSQLQuerySpecification generateQuerySpecification(Map namedParams) {
            return new DBObjectQuerySpecification(this.collectionName, this.query, this.projection, this.orderBy, this.getQueryReturns().toArray(new NativeSQLQueryReturn[this.getQueryReturns().size()]), this.getSynchronizedQuerySpaces());
        }
    }
}

