/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.hibernatecore.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.LockOptions;
import org.hibernate.engine.spi.QueryParameters;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.loader.custom.CustomLoader;
import org.hibernate.loader.custom.CustomQuery;
import org.hibernate.loader.custom.Return;
import org.hibernate.loader.custom.RootReturn;
import org.hibernate.ogm.datastore.spi.Tuple;
import org.hibernate.ogm.dialect.GridDialect;
import org.hibernate.ogm.grid.EntityKeyMetadata;
import org.hibernate.ogm.loader.OgmLoader;
import org.hibernate.ogm.loader.OgmLoadingContext;
import org.hibernate.ogm.loader.nativeloader.BackendCustomQuery;
import org.hibernate.ogm.persister.OgmEntityPersister;
import org.hibernate.ogm.util.ClosableIterator;
import org.hibernate.persister.entity.Loadable;
import org.hibernate.service.Service;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.type.Type;

public class BackendCustomLoader
extends CustomLoader {
    private final BackendCustomQuery customQuery;

    public BackendCustomLoader(BackendCustomQuery customQuery, SessionFactoryImplementor factory) {
        super((CustomQuery)customQuery, factory);
        this.customQuery = customQuery;
    }

    private boolean isEntityQuery() {
        for (Return queryReturn : this.customQuery.getCustomQueryReturns()) {
            if (!(queryReturn instanceof RootReturn)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<?> list(SessionImplementor session, QueryParameters queryParameters, Set querySpaces, Type[] resultTypes) throws HibernateException {
        ClosableIterator<Tuple> tuples = this.executeQuery(session, this.service(session, GridDialect.class), queryParameters, resultTypes);
        try {
            if (this.isEntityQuery()) {
                List<Object> list = this.listOfEntities(session, resultTypes, tuples);
                return list;
            }
            List<Object> list = this.listOfArrays(tuples);
            return list;
        }
        finally {
            tuples.close();
        }
    }

    private List<Object> listOfEntities(SessionImplementor session, Type[] resultTypes, ClosableIterator<Tuple> tuples) {
        ArrayList<Object> results = new ArrayList<Object>();
        Class returnedClass = resultTypes[0].getReturnedClass();
        while (tuples.hasNext()) {
            Tuple tuple = (Tuple)tuples.next();
            OgmLoader loader = this.createLoader(session, returnedClass);
            results.add(this.entity(session, tuple, loader));
        }
        return results;
    }

    private List<Object> listOfArrays(Iterator<Tuple> tuples) {
        ArrayList<Object> results = new ArrayList<Object>();
        while (tuples.hasNext()) {
            Tuple tuple = tuples.next();
            Object[] entry = new Object[tuple.getColumnNames().size()];
            int i = 0;
            for (String column : tuple.getColumnNames()) {
                entry[i++] = tuple.get(column);
            }
            results.add(entry);
        }
        return results;
    }

    private ClosableIterator<Tuple> executeQuery(SessionImplementor session, GridDialect dialect, QueryParameters queryParameters, Type[] resultTypes) {
        Loadable[] entityPersisters = this.getEntityPersisters();
        EntityKeyMetadata[] metadatas = new EntityKeyMetadata[entityPersisters.length];
        for (int i = 0; i < metadatas.length; ++i) {
            metadatas[i] = this.metadata(session.getFactory(), resultTypes[i]);
        }
        return dialect.executeBackendQuery(this.customQuery, queryParameters, metadatas);
    }

    private <T extends Service> T service(SessionImplementor session, Class<T> serviceRole) {
        return (T)this.serviceRegistry(session).getService(serviceRole);
    }

    private ServiceRegistryImplementor serviceRegistry(SessionImplementor session) {
        return session.getFactory().getServiceRegistry();
    }

    private <T> T entity(SessionImplementor session, Tuple tuple, OgmLoader loader) {
        OgmLoadingContext ogmLoadingContext = new OgmLoadingContext();
        ogmLoadingContext.setTuples(Arrays.asList(tuple));
        List<Object> entities = loader.loadEntities(session, LockOptions.NONE, ogmLoadingContext);
        return (T)entities.get(0);
    }

    private OgmLoader createLoader(SessionImplementor session, Class<?> entityClass) {
        OgmEntityPersister persister = (OgmEntityPersister)session.getFactory().getEntityPersister(entityClass.getName());
        OgmLoader loader = new OgmLoader(new OgmEntityPersister[]{persister});
        return loader;
    }

    private EntityKeyMetadata metadata(SessionFactoryImplementor sessionFactory, Type resultType) {
        OgmEntityPersister persister = (OgmEntityPersister)sessionFactory.getEntityPersister(resultType.getName());
        return new EntityKeyMetadata(persister.getTableName(), persister.getRootTableIdentifierColumnNames());
    }
}

