/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.hibernatecore.impl;

import java.sql.Connection;
import org.hibernate.ConnectionReleaseMode;
import org.hibernate.Interceptor;
import org.hibernate.Session;
import org.hibernate.SessionBuilder;
import org.hibernate.SessionEventListener;
import org.hibernate.engine.spi.SessionBuilderImplementor;
import org.hibernate.engine.spi.SessionOwner;
import org.hibernate.event.spi.EventSource;
import org.hibernate.ogm.OgmSessionFactory;
import org.hibernate.ogm.hibernatecore.impl.OgmSessionImpl;

public class OgmSessionBuilderDelegator
implements SessionBuilderImplementor {
    private final SessionBuilderImplementor builder;
    private final OgmSessionFactory factory;

    public OgmSessionBuilderDelegator(SessionBuilderImplementor sessionBuilder, OgmSessionFactory factory) {
        this.builder = sessionBuilder;
        this.factory = factory;
    }

    public Session openSession() {
        Session session = this.builder.openSession();
        return new OgmSessionImpl(this.factory, (EventSource)session);
    }

    public SessionBuilder interceptor(Interceptor interceptor) {
        this.builder.interceptor(interceptor);
        return this;
    }

    public SessionBuilder noInterceptor() {
        this.builder.noInterceptor();
        return this;
    }

    public SessionBuilder connection(Connection connection) {
        this.builder.connection(connection);
        return this;
    }

    public SessionBuilder connectionReleaseMode(ConnectionReleaseMode connectionReleaseMode) {
        this.builder.connectionReleaseMode(connectionReleaseMode);
        return this;
    }

    public SessionBuilder autoJoinTransactions(boolean autoJoinTransactions) {
        this.builder.autoJoinTransactions(autoJoinTransactions);
        return this;
    }

    @Deprecated
    public SessionBuilder autoClose(boolean autoClose) {
        this.builder.autoClose(autoClose);
        return this;
    }

    public SessionBuilder flushBeforeCompletion(boolean flushBeforeCompletion) {
        this.builder.flushBeforeCompletion(flushBeforeCompletion);
        return this;
    }

    public SessionBuilder tenantIdentifier(String tenantIdentifier) {
        this.builder.tenantIdentifier(tenantIdentifier);
        return this;
    }

    public SessionBuilder owner(SessionOwner sessionOwner) {
        this.builder.owner(sessionOwner);
        return this;
    }

    public SessionBuilder eventListeners(SessionEventListener ... listeners) {
        this.builder.eventListeners(listeners);
        return this;
    }

    public SessionBuilder clearEventListeners() {
        this.builder.clearEventListeners();
        return this;
    }
}

