/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.loader.nativeloader;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.engine.query.spi.sql.NativeSQLQuerySpecification;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.loader.custom.CustomQuery;
import org.hibernate.loader.custom.Return;
import org.hibernate.loader.custom.sql.SQLQueryReturnProcessor;
import org.hibernate.ogm.util.impl.Log;
import org.hibernate.ogm.util.impl.LoggerFactory;

public class BackendCustomQuery
implements CustomQuery {
    private static final Log LOG = LoggerFactory.make();
    private final NativeSQLQuerySpecification spec;
    private final Set<String> querySpaces;
    private final List<Return> customQueryReturns;

    public BackendCustomQuery(NativeSQLQuerySpecification spec, SessionFactoryImplementor factory) throws HibernateException {
        LOG.tracev("Starting processing of NoSQL query [{0}]", spec.getQueryString());
        this.spec = spec;
        SQLQueryReturnProcessor processor = new SQLQueryReturnProcessor(spec.getQueryReturns(), factory);
        processor.process();
        this.customQueryReturns = Collections.unmodifiableList(processor.generateCustomReturns(false));
        if (spec.getQuerySpaces() != null) {
            Set spaces = spec.getQuerySpaces();
            this.querySpaces = Collections.unmodifiableSet(spaces);
        } else {
            this.querySpaces = Collections.emptySet();
        }
    }

    public String getSQL() {
        return this.spec.getQueryString();
    }

    public Set<String> getQuerySpaces() {
        return this.querySpaces;
    }

    public Map<?, ?> getNamedParameterBindPoints() {
        return Collections.emptyMap();
    }

    public List<Return> getCustomQueryReturns() {
        return this.customQueryReturns;
    }

    public NativeSQLQuerySpecification getSpec() {
        return this.spec;
    }
}

