/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.massindex.batchindexing;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.LockOptions;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.ogm.datastore.spi.Tuple;
import org.hibernate.ogm.loader.OgmLoader;
import org.hibernate.ogm.loader.OgmLoadingContext;
import org.hibernate.ogm.massindex.batchindexing.Helper;
import org.hibernate.ogm.massindex.batchindexing.SessionAwareRunnable;
import org.hibernate.ogm.persister.OgmEntityPersister;
import org.hibernate.search.backend.AddLuceneWork;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.impl.batch.BatchBackend;
import org.hibernate.search.batchindexing.MassIndexerProgressMonitor;
import org.hibernate.search.bridge.spi.ConversionContext;
import org.hibernate.search.bridge.util.impl.ContextualExceptionBridgeHelper;
import org.hibernate.search.engine.impl.HibernateSessionLoadingInitializer;
import org.hibernate.search.engine.spi.DocumentBuilderIndexedEntity;
import org.hibernate.search.engine.spi.EntityIndexBinder;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.hibernate.search.exception.ErrorHandler;
import org.hibernate.search.indexes.interceptor.EntityIndexingInterceptor;
import org.hibernate.search.indexes.interceptor.IndexingOverride;
import org.hibernate.search.spi.InstanceInitializer;
import org.hibernate.search.util.impl.HibernateHelper;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class TupleIndexer
implements SessionAwareRunnable {
    private static final Log log = LoggerFactory.make();
    private final SessionFactoryImplementor sessionFactory;
    private final Map<Class<?>, EntityIndexBinder> entityIndexBinders;
    private final MassIndexerProgressMonitor monitor;
    private final CacheMode cacheMode;
    private final BatchBackend backend;
    private final ErrorHandler errorHandler;
    private final Class<?> indexedType;

    public TupleIndexer(Class<?> indexedType, MassIndexerProgressMonitor monitor, SessionFactoryImplementor sessionFactory, SearchFactoryImplementor searchFactory, CacheMode cacheMode, BatchBackend backend, ErrorHandler errorHandler) {
        this.indexedType = indexedType;
        this.monitor = monitor;
        this.sessionFactory = sessionFactory;
        this.cacheMode = cacheMode;
        this.backend = backend;
        this.errorHandler = errorHandler;
        this.entityIndexBinders = searchFactory.getIndexBindingForEntity();
    }

    private void index(Session session, Object entity) {
        try {
            HibernateSessionLoadingInitializer sessionInitializer = new HibernateSessionLoadingInitializer((SessionImplementor)session);
            ContextualExceptionBridgeHelper contextualBridge = new ContextualExceptionBridgeHelper();
            session.buildLockRequest(LockOptions.NONE).lock(entity);
            this.index(entity, session, (InstanceInitializer)sessionInitializer, (ConversionContext)contextualBridge);
            this.monitor.documentsBuilt(1);
            session.clear();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private void index(Object entity, Session session, InstanceInitializer sessionInitializer, ConversionContext conversionContext) throws InterruptedException {
        EntityIndexingInterceptor interceptor;
        Class clazz = HibernateHelper.getClass((Object)entity);
        EntityIndexBinder entityIndexBinding = this.entityIndexBinders.get(clazz);
        if (entityIndexBinding != null && this.isNotSkippable(interceptor = entityIndexBinding.getEntityIndexingInterceptor(), entity)) {
            Serializable id = session.getIdentifier(entity);
            AddLuceneWork addWork = this.createAddLuceneWork(entity, sessionInitializer, conversionContext, id, clazz, entityIndexBinding);
            this.backend.enqueueAsyncWork((LuceneWork)addWork);
        }
    }

    private AddLuceneWork createAddLuceneWork(Object entity, InstanceInitializer sessionInitializer, ConversionContext conversionContext, Serializable id, Class<?> clazz, EntityIndexBinder entityIndexBinding) {
        DocumentBuilderIndexedEntity docBuilder = entityIndexBinding.getDocumentBuilder();
        String idInString = this.idInString(conversionContext, id, clazz, docBuilder);
        return docBuilder.createAddWork(clazz, entity, id, idInString, sessionInitializer, conversionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String idInString(ConversionContext conversionContext, Serializable id, Class<?> clazz, DocumentBuilderIndexedEntity docBuilder) {
        conversionContext.pushProperty(docBuilder.getIdKeywordName());
        try {
            String idInString;
            String string = idInString = conversionContext.setClass(clazz).twoWayConversionContext(docBuilder.getIdBridge()).objectToString((Object)id);
            return string;
        }
        finally {
            conversionContext.popProperty();
        }
    }

    private boolean isNotSkippable(EntityIndexingInterceptor interceptor, Object entity) {
        if (interceptor == null) {
            return true;
        }
        return !this.isSkippable(interceptor.onAdd(entity));
    }

    private boolean isSkippable(IndexingOverride indexingOverride) {
        switch (indexingOverride) {
            case REMOVE: 
            case SKIP: {
                return true;
            }
        }
        return false;
    }

    private Transaction beginTransaction(Session session) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Transaction transaction = Helper.getTransactionAndMarkForJoin(session);
        transaction.begin();
        return transaction;
    }

    private Session openSession(Session upperSession) {
        Session session = upperSession;
        if (upperSession == null) {
            session = this.sessionFactory.openSession();
        }
        session.setFlushMode(FlushMode.MANUAL);
        session.setCacheMode(this.cacheMode);
        session.setDefaultReadOnly(true);
        return session;
    }

    private void close(Session upperSession, Session session) {
        if (upperSession == null) {
            session.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(Session upperSession, Tuple tuple) {
        Session session = this.openSession(upperSession);
        try {
            Transaction transaction = this.beginTransaction(session);
            this.index(session, this.entity(session, tuple));
            transaction.commit();
        }
        catch (Throwable e) {
            this.errorHandler.handleException(log.massIndexerUnexpectedErrorMessage(), e);
        }
        finally {
            this.close(upperSession, session);
            log.debug((Object)"finished");
        }
    }

    private Object entity(Session session, Tuple tuple) {
        OgmEntityPersister persister = (OgmEntityPersister)this.sessionFactory.getEntityPersister(this.indexedType.getName());
        OgmLoader loader = new OgmLoader(new OgmEntityPersister[]{persister});
        ArrayList<Tuple> tuples = new ArrayList<Tuple>();
        tuples.add(tuple);
        OgmLoadingContext ogmLoadingContext = new OgmLoadingContext();
        ogmLoadingContext.setTuples(tuples);
        List<Object> entities = loader.loadEntities((SessionImplementor)session, LockOptions.NONE, ogmLoadingContext);
        return entities.get(0);
    }
}

