/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.options.navigation.impl;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.ogm.options.navigation.impl.OptionsContextImpl;
import org.hibernate.ogm.options.navigation.impl.PropertyKey;
import org.hibernate.ogm.options.navigation.source.impl.OptionValueSource;
import org.hibernate.ogm.options.navigation.source.impl.OptionValueSources;
import org.hibernate.ogm.options.spi.OptionsContext;
import org.hibernate.ogm.options.spi.OptionsService;
import org.hibernate.ogm.util.configurationreader.impl.ConfigurationPropertyReader;
import org.hibernate.service.spi.Configurable;
import org.hibernate.service.spi.ServiceRegistryAwareService;
import org.hibernate.service.spi.ServiceRegistryImplementor;

public class OptionsServiceImpl
implements OptionsService,
Configurable,
ServiceRegistryAwareService {
    private OptionsService.OptionsServiceContext sessionFactoryOptions;
    private ServiceRegistryImplementor registry;

    public void injectServices(ServiceRegistryImplementor serviceRegistry) {
        this.registry = serviceRegistry;
    }

    public void configure(Map configurationValues) {
        ClassLoaderService classLoaderService = (ClassLoaderService)this.registry.getService(ClassLoaderService.class);
        ConfigurationPropertyReader propertyReader = new ConfigurationPropertyReader(configurationValues, classLoaderService);
        this.sessionFactoryOptions = new OptionsServiceContextImpl(OptionValueSources.getDefaultSources(propertyReader));
    }

    @Override
    public OptionsService.OptionsServiceContext context() {
        return this.sessionFactoryOptions;
    }

    @Override
    public OptionsService.OptionsServiceContext context(SessionImplementor session) {
        throw new UnsupportedOperationException("OGM-343 Session specific options are not currently supported");
    }

    private static class OptionsServiceContextImpl
    implements OptionsService.OptionsServiceContext {
        private final List<OptionValueSource> sources;
        private final OptionsContext globalOptions;
        private final ConcurrentMap<Class<?>, OptionsContext> entityContexts;
        private final ConcurrentMap<PropertyKey, OptionsContext> propertyContexts;

        public OptionsServiceContextImpl(List<OptionValueSource> sources) {
            this.sources = sources;
            this.globalOptions = OptionsContextImpl.forGlobal(sources);
            this.entityContexts = new ConcurrentHashMap();
            this.propertyContexts = new ConcurrentHashMap<PropertyKey, OptionsContext>();
        }

        @Override
        public OptionsContext getGlobalOptions() {
            return this.globalOptions;
        }

        @Override
        public OptionsContext getEntityOptions(Class<?> entityType) {
            OptionsContext entityOptions = (OptionsContext)this.entityContexts.get(entityType);
            if (entityOptions == null) {
                entityOptions = this.getAndCacheEntityOptions(entityType);
            }
            return entityOptions;
        }

        @Override
        public OptionsContext getPropertyOptions(Class<?> entityType, String propertyName) {
            PropertyKey key = new PropertyKey(entityType, propertyName);
            OptionsContext propertyOptions = (OptionsContext)this.propertyContexts.get(key);
            if (propertyOptions == null) {
                propertyOptions = this.getAndCachePropertyOptions(key);
            }
            return propertyOptions;
        }

        private OptionsContext getAndCacheEntityOptions(Class<?> entityType) {
            OptionsContext entityOptions = OptionsContextImpl.forEntity(this.sources, entityType);
            OptionsContext cachedOptions = this.entityContexts.putIfAbsent(entityType, entityOptions);
            if (cachedOptions != null) {
                entityOptions = cachedOptions;
            }
            return entityOptions;
        }

        private OptionsContext getAndCachePropertyOptions(PropertyKey key) {
            OptionsContext propertyOptions = OptionsContextImpl.forProperty(this.sources, key.getEntity(), key.getProperty());
            OptionsContext cachedOptions = this.propertyContexts.putIfAbsent(key, propertyOptions);
            if (cachedOptions != null) {
                propertyOptions = cachedOptions;
            }
            return propertyOptions;
        }
    }
}

