/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.util.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class CollectionHelper {
    private CollectionHelper() {
    }

    public static <T> Set<T> asSet(T ... ts) {
        if (ts == null) {
            return null;
        }
        if (ts.length == 0) {
            return Collections.emptySet();
        }
        HashSet set = new HashSet(ts.length);
        Collections.addAll(set, ts);
        return Collections.unmodifiableSet(set);
    }

    public static <K, V> HashMap<K, V> newHashMap() {
        return new HashMap();
    }

    public static <K, V> HashMap<K, V> newHashMap(int initialCapacity) {
        return new HashMap(initialCapacity);
    }

    public static <K, V> HashMap<K, V> newHashMap(Map<? extends K, ? extends V> other) {
        return new HashMap<K, V>(other);
    }

    public static <K, V> ConcurrentHashMap<K, V> newConcurrentHashMap() {
        return new ConcurrentHashMap();
    }

    public static <K, V> ConcurrentHashMap<K, V> newConcurrentHashMap(int initialCapacity) {
        return new ConcurrentHashMap(initialCapacity);
    }

    public static <K, V> ConcurrentHashMap<K, V> newConcurrentHashMap(Map<? extends K, ? extends V> other) {
        return new ConcurrentHashMap<K, V>(other);
    }
}

