/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ext.udc.impl;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import org.neo4j.ext.udc.UdcSettings;
import org.neo4j.ext.udc.impl.UdcKernelExtension;
import org.neo4j.kernel.KernelData;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.impl.transaction.XaDataSourceManager;
import org.neo4j.kernel.lifecycle.Lifecycle;

public class UdcKernelExtensionFactory
extends KernelExtensionFactory<Dependencies> {
    static final String KEY = "kernel udc";

    public UdcKernelExtensionFactory() {
        super(KEY);
    }

    public Class getSettingsClass() {
        return UdcSettings.class;
    }

    public Lifecycle newKernelExtension(Dependencies dependencies) throws Throwable {
        return new UdcKernelExtension(this.loadConfig(dependencies.getConfig()), dependencies.getXaDataSourceManager(), dependencies.getKernelData(), new Timer("Neo4j UDC Timer", true));
    }

    private Config loadConfig(Config config) {
        Properties udcProps = this.loadUdcProperties();
        HashMap<String, String> configParams = new HashMap<String, String>(config.getParams());
        for (Map.Entry<Object, Object> entry : udcProps.entrySet()) {
            configParams.put((String)entry.getKey(), (String)entry.getValue());
        }
        return new Config(configParams);
    }

    private Properties loadUdcProperties() {
        Properties sysProps = new Properties();
        try {
            InputStream resource = ((Object)((Object)this)).getClass().getResourceAsStream("/org/neo4j/ext/udc/udc.properties");
            if (resource != null) {
                sysProps.load(resource);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sysProps;
    }

    public static interface Dependencies {
        public Config getConfig();

        public XaDataSourceManager getXaDataSourceManager();

        public KernelData getKernelData();
    }
}

