/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.properties;

import java.util.Arrays;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.impl.cache.SizeOfs;

class ShortArrayProperty
extends DefinedProperty {
    private final short[] value;

    ShortArrayProperty(int propertyKeyId, short[] value) {
        super(propertyKeyId);
        assert (value != null);
        this.value = value;
    }

    public short[] value() {
        return (short[])this.value.clone();
    }

    @Override
    public boolean valueEquals(Object value) {
        if (value instanceof short[]) {
            return Arrays.equals(this.value, (short[])value);
        }
        return this.valueCompare(value, this.value);
    }

    @Override
    int valueHash() {
        return Arrays.hashCode(this.value);
    }

    @Override
    boolean hasEqualValue(DefinedProperty that) {
        return Arrays.equals(this.value, ((ShortArrayProperty)that).value);
    }

    @Override
    public int sizeOfObjectInBytesIncludingOverhead() {
        return SizeOfs.withObjectOverhead(SizeOfs.withReference(SizeOfs.sizeOfArray(this.value)));
    }
}

