/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j.impl;

import java.util.Map;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.ogm.datastore.neo4j.Neo4jDialect;
import org.hibernate.ogm.datastore.neo4j.dialect.impl.Neo4jSequenceGenerator;
import org.hibernate.ogm.datastore.neo4j.impl.Neo4jGraphDatabaseServiceFactoryProvider;
import org.hibernate.ogm.datastore.neo4j.spi.GraphDatabaseServiceFactory;
import org.hibernate.ogm.datastore.spi.DatastoreProvider;
import org.hibernate.ogm.dialect.GridDialect;
import org.hibernate.ogm.service.impl.LuceneBasedQueryParserService;
import org.hibernate.ogm.service.impl.QueryParserService;
import org.hibernate.service.spi.Configurable;
import org.hibernate.service.spi.ServiceRegistryAwareService;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.service.spi.Startable;
import org.hibernate.service.spi.Stoppable;
import org.neo4j.graphdb.GraphDatabaseService;

public class Neo4jDatastoreProvider
implements DatastoreProvider,
Startable,
Stoppable,
Configurable,
ServiceRegistryAwareService {
    private GraphDatabaseService neo4jDb;
    private GraphDatabaseServiceFactory graphDbFactory;
    private ServiceRegistryImplementor registry;
    private Neo4jSequenceGenerator sequenceGenerator;

    public void injectServices(ServiceRegistryImplementor serviceRegistry) {
        this.registry = serviceRegistry;
    }

    public Class<? extends QueryParserService> getDefaultQueryParserServiceType() {
        return LuceneBasedQueryParserService.class;
    }

    public void configure(Map cfg) {
        this.graphDbFactory = new Neo4jGraphDatabaseServiceFactoryProvider().load(cfg, (ClassLoaderService)this.registry.getService(ClassLoaderService.class));
    }

    public void stop() {
        this.neo4jDb.shutdown();
    }

    public void start() {
        this.neo4jDb = this.graphDbFactory.create();
        this.sequenceGenerator = new Neo4jSequenceGenerator(this.neo4jDb);
        this.graphDbFactory = null;
    }

    public Class<? extends GridDialect> getDefaultDialect() {
        return Neo4jDialect.class;
    }

    public GraphDatabaseService getDataBase() {
        return this.neo4jDb;
    }

    public Neo4jSequenceGenerator getSequenceGenerator() {
        return this.sequenceGenerator;
    }
}

