/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.mongodb.query.parsing.impl;

import com.mongodb.DBObject;
import java.util.List;
import org.hibernate.hql.ast.spi.predicate.ComparisonPredicate;
import org.hibernate.hql.ast.spi.predicate.ConjunctionPredicate;
import org.hibernate.hql.ast.spi.predicate.DisjunctionPredicate;
import org.hibernate.hql.ast.spi.predicate.InPredicate;
import org.hibernate.hql.ast.spi.predicate.IsNullPredicate;
import org.hibernate.hql.ast.spi.predicate.LikePredicate;
import org.hibernate.hql.ast.spi.predicate.NegationPredicate;
import org.hibernate.hql.ast.spi.predicate.PredicateFactory;
import org.hibernate.hql.ast.spi.predicate.RangePredicate;
import org.hibernate.hql.ast.spi.predicate.RootPredicate;
import org.hibernate.ogm.datastore.mongodb.query.parsing.impl.MongoDBPropertyHelper;
import org.hibernate.ogm.datastore.mongodb.query.parsing.predicate.impl.MongoDBComparisonPredicate;
import org.hibernate.ogm.datastore.mongodb.query.parsing.predicate.impl.MongoDBConjunctionPredicate;
import org.hibernate.ogm.datastore.mongodb.query.parsing.predicate.impl.MongoDBDisjunctionPredicate;
import org.hibernate.ogm.datastore.mongodb.query.parsing.predicate.impl.MongoDBInPredicate;
import org.hibernate.ogm.datastore.mongodb.query.parsing.predicate.impl.MongoDBIsNullPredicate;
import org.hibernate.ogm.datastore.mongodb.query.parsing.predicate.impl.MongoDBLikePredicate;
import org.hibernate.ogm.datastore.mongodb.query.parsing.predicate.impl.MongoDBNegationPredicate;
import org.hibernate.ogm.datastore.mongodb.query.parsing.predicate.impl.MongoDBRangePredicate;
import org.hibernate.ogm.datastore.mongodb.query.parsing.predicate.impl.MongoDBRootPredicate;

public class MongoDBPredicateFactory
implements PredicateFactory<DBObject> {
    private final MongoDBPropertyHelper propertyHelper;

    public MongoDBPredicateFactory(MongoDBPropertyHelper propertyHelper) {
        this.propertyHelper = propertyHelper;
    }

    public RootPredicate<DBObject> getRootPredicate(String entityType) {
        return new MongoDBRootPredicate();
    }

    public ComparisonPredicate<DBObject> getComparisonPredicate(String entityType, ComparisonPredicate.Type comparisonType, List<String> propertyPath, Object value) {
        String columnName = this.propertyHelper.getColumnName(entityType, propertyPath.get(propertyPath.size() - 1));
        return new MongoDBComparisonPredicate(columnName, comparisonType, value);
    }

    public RangePredicate<DBObject> getRangePredicate(String entityType, List<String> propertyPath, Object lowerValue, Object upperValue) {
        String columnName = this.propertyHelper.getColumnName(entityType, propertyPath.get(propertyPath.size() - 1));
        return new MongoDBRangePredicate(columnName, lowerValue, upperValue);
    }

    public NegationPredicate<DBObject> getNegationPredicate() {
        return new MongoDBNegationPredicate();
    }

    public DisjunctionPredicate<DBObject> getDisjunctionPredicate() {
        return new MongoDBDisjunctionPredicate();
    }

    public ConjunctionPredicate<DBObject> getConjunctionPredicate() {
        return new MongoDBConjunctionPredicate();
    }

    public InPredicate<DBObject> getInPredicate(String entityType, List<String> propertyPath, List<Object> typedElements) {
        String columnName = this.propertyHelper.getColumnName(entityType, propertyPath.get(propertyPath.size() - 1));
        return new MongoDBInPredicate(columnName, typedElements);
    }

    public IsNullPredicate<DBObject> getIsNullPredicate(String entityType, List<String> propertyPath) {
        String columnName = this.propertyHelper.getColumnName(entityType, propertyPath.get(propertyPath.size() - 1));
        return new MongoDBIsNullPredicate(columnName);
    }

    public LikePredicate<DBObject> getLikePredicate(String entityType, List<String> propertyPath, String patternValue, Character escapeCharacter) {
        String columnName = this.propertyHelper.getColumnName(entityType, propertyPath.get(propertyPath.size() - 1));
        return new MongoDBLikePredicate(columnName, patternValue, escapeCharacter);
    }
}

