/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index;

import java.io.IOException;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.SearcherManager;
import org.neo4j.index.impl.lucene.Hits;
import org.neo4j.kernel.api.impl.index.HitsPrimitiveLongIterator;
import org.neo4j.kernel.api.impl.index.LuceneDocumentStructure;
import org.neo4j.kernel.api.index.IndexReader;
import org.neo4j.kernel.impl.util.PrimitiveLongIterator;

class LuceneIndexAccessorReader
implements IndexReader {
    private final IndexSearcher searcher;
    private final LuceneDocumentStructure documentLogic;
    private final SearcherManager searcherManager;

    LuceneIndexAccessorReader(SearcherManager searcherManager, LuceneDocumentStructure documentLogic) {
        this.searcherManager = searcherManager;
        this.searcher = (IndexSearcher)searcherManager.acquire();
        this.documentLogic = documentLogic;
    }

    public PrimitiveLongIterator lookup(Object value) {
        try {
            Hits hits = new Hits(this.searcher, this.documentLogic.newQuery(value), null);
            return new HitsPrimitiveLongIterator(hits, this.documentLogic);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void close() {
        try {
            this.searcherManager.release((Object)this.searcher);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

