/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.loader.nativeloader;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.loader.custom.CustomQuery;
import org.hibernate.loader.custom.Return;
import org.hibernate.loader.custom.RootReturn;
import org.hibernate.loader.custom.sql.SQLQueryReturnProcessor;
import org.hibernate.ogm.grid.EntityKeyMetadata;
import org.hibernate.ogm.persister.OgmEntityPersister;
import org.hibernate.ogm.query.spi.NativeNoSqlQuerySpecification;
import org.hibernate.ogm.util.impl.Log;
import org.hibernate.ogm.util.impl.LoggerFactory;

public class BackendCustomQuery
implements CustomQuery {
    private static final Log LOG = LoggerFactory.make();
    private final String queryString;
    private final Object queryObject;
    private final SessionFactoryImplementor sessionFactory;
    private final Set<String> querySpaces;
    private final List<Return> customQueryReturns;

    public BackendCustomQuery(NativeNoSqlQuerySpecification spec, SessionFactoryImplementor factory) throws HibernateException {
        LOG.tracev("Starting processing of NoSQL query [{0}]", spec.getQueryString());
        this.queryString = spec.getQueryString();
        this.queryObject = spec.getQueryObject();
        this.sessionFactory = factory;
        SQLQueryReturnProcessor processor = new SQLQueryReturnProcessor(spec.getQueryReturns(), factory);
        processor.process();
        this.customQueryReturns = Collections.unmodifiableList(processor.generateCustomReturns(false));
        if (spec.getQuerySpaces() != null) {
            Set spaces = spec.getQuerySpaces();
            this.querySpaces = Collections.unmodifiableSet(spaces);
        } else {
            this.querySpaces = Collections.emptySet();
        }
    }

    @Deprecated
    public String getSQL() {
        return this.getQueryString();
    }

    public String getQueryString() {
        return this.queryString;
    }

    public Object getQueryObject() {
        return this.queryObject;
    }

    public Set<String> getQuerySpaces() {
        return this.querySpaces;
    }

    public Map<?, ?> getNamedParameterBindPoints() {
        return Collections.emptyMap();
    }

    public List<Return> getCustomQueryReturns() {
        return this.customQueryReturns;
    }

    public EntityKeyMetadata getSingleEntityKeyMetadataOrNull() {
        EntityKeyMetadata metadata = null;
        for (Return queryReturn : this.getCustomQueryReturns()) {
            if (!(queryReturn instanceof RootReturn)) continue;
            if (metadata != null) {
                return null;
            }
            RootReturn rootReturn = (RootReturn)queryReturn;
            OgmEntityPersister persister = (OgmEntityPersister)this.sessionFactory.getEntityPersister(rootReturn.getEntityName());
            metadata = new EntityKeyMetadata(persister.getTableName(), persister.getRootTableIdentifierColumnNames());
        }
        return metadata;
    }
}

