/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j.dialect.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.internal.util.collections.BoundedConcurrentHashMap;
import org.hibernate.ogm.datastore.neo4j.dialect.impl.NodeLabel;
import org.hibernate.ogm.grid.RowKey;
import org.hibernate.ogm.id.impl.OgmSequenceGenerator;
import org.hibernate.ogm.id.impl.OgmTableGenerator;
import org.neo4j.cypher.javacompat.ExecutionEngine;
import org.neo4j.cypher.javacompat.ExecutionResult;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Lock;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.ConstraintType;

public class Neo4jSequenceGenerator {
    private static final String SEQUENCE_NAME_PROPERTY = "sequence_name";
    private static final String CURRENT_VALUE_PROPERTY = "current_value";
    private static final String INITIAL_VALUE_QUERY_PARAM = "initialValue";
    private static final String SEQUENCE_NAME_QUERY_PARAM = "sequenceName";
    private final BoundedConcurrentHashMap<String, String> queryCache;
    private final GraphDatabaseService neo4jDb;
    private final ExecutionEngine engine;

    public Neo4jSequenceGenerator(GraphDatabaseService neo4jDb, int sequenceCacheMaxSize) {
        this.neo4jDb = neo4jDb;
        this.engine = new ExecutionEngine(neo4jDb);
        this.queryCache = new BoundedConcurrentHashMap(sequenceCacheMaxSize, 20, BoundedConcurrentHashMap.Eviction.LIRS);
    }

    public void createSequences(Set<IdentifierGenerator> identifierGenerators) {
        this.addUniqueConstraints(identifierGenerators);
        this.addSequences(identifierGenerators);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addUniqueConstraints(Set<IdentifierGenerator> identifierGenerators) {
        Transaction tx = null;
        try {
            tx = this.neo4jDb.beginTx();
            for (IdentifierGenerator identifierGenerator : identifierGenerators) {
                this.addUniqueConstraint(identifierGenerator);
            }
            tx.success();
        }
        finally {
            tx.close();
        }
    }

    private void addUniqueConstraint(IdentifierGenerator identifierGenerator) {
        if (identifierGenerator instanceof OgmSequenceGenerator) {
            OgmSequenceGenerator sequenceGenerator = (OgmSequenceGenerator)identifierGenerator;
            this.addUniqueConstraint(sequenceGenerator.generatorKey());
        } else if (identifierGenerator instanceof OgmTableGenerator) {
            OgmTableGenerator sequenceGenerator = (OgmTableGenerator)identifierGenerator;
            this.addUniqueConstraint(sequenceGenerator.generatorKey());
        }
    }

    private void addUniqueConstraint(Object generatorKey) {
        Label generatorKeyLabel = this.generatorKeyLabel(generatorKey);
        if (this.isMissingUniqueConstraint(generatorKeyLabel)) {
            this.neo4jDb.schema().constraintFor(generatorKeyLabel).assertPropertyIsUnique(SEQUENCE_NAME_PROPERTY).create();
        }
    }

    private boolean isMissingUniqueConstraint(Label generatorKeyLabel) {
        Iterable constraints = this.neo4jDb.schema().getConstraints(generatorKeyLabel);
        for (ConstraintDefinition constraint : constraints) {
            if (!constraint.isConstraintType(ConstraintType.UNIQUENESS)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSequences(Set<IdentifierGenerator> identifierGenerators) {
        Transaction tx = null;
        try {
            tx = this.neo4jDb.beginTx();
            for (IdentifierGenerator generator : identifierGenerators) {
                this.addSequence(generator);
            }
            tx.success();
        }
        finally {
            tx.close();
        }
    }

    private void addSequence(IdentifierGenerator identifierGenerator) {
        if (identifierGenerator instanceof OgmSequenceGenerator) {
            OgmSequenceGenerator sequenceGenerator = (OgmSequenceGenerator)identifierGenerator;
            this.addSequence(sequenceGenerator.generatorKey(), sequenceGenerator.getSegmentValue(), sequenceGenerator.getInitialValue());
        } else if (identifierGenerator instanceof OgmTableGenerator) {
            OgmTableGenerator sequenceGenerator = (OgmTableGenerator)identifierGenerator;
            this.addSequence(sequenceGenerator.generatorKey(), sequenceGenerator.getSegmentValue(), sequenceGenerator.getInitialValue());
        }
    }

    private void addSequence(Object generatorKey, String sequenceName, int initialValue) {
        Label generatorKeyLabel = this.generatorKeyLabel(generatorKey);
        String query = "MERGE (n" + this.labels(generatorKeyLabel.name(), NodeLabel.SEQUENCE.name()) + " { " + SEQUENCE_NAME_PROPERTY + ": {" + SEQUENCE_NAME_QUERY_PARAM + "}} ) ON CREATE SET n." + CURRENT_VALUE_PROPERTY + " = {" + INITIAL_VALUE_QUERY_PARAM + "} RETURN n";
        this.engine.execute(query, this.params(sequenceName, initialValue));
    }

    private Label generatorKeyLabel(Object generatorKey) {
        return DynamicLabel.label((String)generatorKey.toString());
    }

    private Map<String, Object> params(String sequenceName, int initialValue) {
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put(INITIAL_VALUE_QUERY_PARAM, initialValue);
        params.put(SEQUENCE_NAME_QUERY_PARAM, sequenceName);
        return params;
    }

    public int nextValue(RowKey rowKey, int increment) {
        return this.sequence(rowKey, increment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int sequence(RowKey rowKey, int increment) {
        Transaction tx = this.neo4jDb.beginTx();
        Lock lock = null;
        try {
            Node sequence = this.getSequence(rowKey);
            lock = tx.acquireWriteLock((PropertyContainer)sequence);
            int nextValue = this.updateSequenceValue(sequence, increment);
            tx.success();
            lock.release();
            int n = nextValue;
            return n;
        }
        finally {
            tx.close();
        }
    }

    private Node getSequence(RowKey rowKey) {
        String updateSequenceQuery = this.getQuery(rowKey);
        ExecutionResult result = this.engine.execute(updateSequenceQuery, Collections.singletonMap(SEQUENCE_NAME_QUERY_PARAM, this.sequenceName(rowKey)));
        ResourceIterator column = result.columnAs("n");
        Node node = null;
        if (column.hasNext()) {
            node = (Node)column.next();
        }
        column.close();
        return node;
    }

    private String getQuery(RowKey rowKey) {
        String query = (String)this.queryCache.get((Object)rowKey.getTable());
        if (query == null) {
            query = "MATCH (n" + this.labels(rowKey.getTable(), NodeLabel.SEQUENCE.name()) + ") WHERE n." + SEQUENCE_NAME_PROPERTY + " = {" + SEQUENCE_NAME_QUERY_PARAM + "} RETURN n";
            String cached = (String)this.queryCache.putIfAbsent((Object)rowKey.getTable(), (Object)query);
            if (cached != null) {
                query = cached;
            }
        }
        return query;
    }

    private String labels(String ... labels) {
        StringBuilder builder = new StringBuilder();
        for (String label : labels) {
            builder.append(":`");
            builder.append(label);
            builder.append("`");
        }
        return builder.toString();
    }

    private String sequenceName(RowKey key) {
        return (String)key.getColumnValues()[0];
    }

    private int updateSequenceValue(Node sequence, int increment) {
        int currentValue = (Integer)sequence.getProperty(CURRENT_VALUE_PROPERTY);
        int updatedValue = currentValue + increment;
        sequence.setProperty(CURRENT_VALUE_PROPERTY, (Object)updatedValue);
        return currentValue;
    }
}

