/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j.impl;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hibernate.SessionFactory;
import org.hibernate.SessionFactoryObserver;
import org.hibernate.cfg.Configuration;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.integrator.spi.Integrator;
import org.hibernate.metamodel.source.MetadataImplementor;
import org.hibernate.ogm.datastore.neo4j.impl.Neo4jDatastoreProvider;
import org.hibernate.ogm.datastore.spi.DatastoreProvider;
import org.hibernate.ogm.service.impl.ConfigurationService;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.service.spi.SessionFactoryServiceRegistry;

public class Neo4jIntegrator
implements Integrator {
    public void integrate(Configuration configuration, SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
        this.addNeo4jObserverIfRequired(sessionFactory);
    }

    public void integrate(MetadataImplementor metadata, SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
        this.addNeo4jObserverIfRequired(sessionFactory);
    }

    public void disintegrate(SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
    }

    private void addNeo4jObserverIfRequired(SessionFactoryImplementor sessionFactory) {
        if (this.currentDialectIsNeo4j(sessionFactory)) {
            sessionFactory.addObserver((SessionFactoryObserver)new SequenceCreator());
        }
    }

    private boolean currentDialectIsNeo4j(SessionFactoryImplementor sessionFactoryImplementor) {
        ServiceRegistryImplementor registry = sessionFactoryImplementor.getServiceRegistry();
        return ((ConfigurationService)registry.getService(ConfigurationService.class)).isOgmOn() && registry.getService(DatastoreProvider.class) instanceof Neo4jDatastoreProvider;
    }

    private static class SequenceCreator
    implements SessionFactoryObserver {
        private SequenceCreator() {
        }

        public void sessionFactoryCreated(SessionFactory factory) {
            SessionFactoryImplementor sessionFactoryImplementor = (SessionFactoryImplementor)factory;
            ServiceRegistryImplementor registry = sessionFactoryImplementor.getServiceRegistry();
            Neo4jDatastoreProvider provider = (Neo4jDatastoreProvider)registry.getService(DatastoreProvider.class);
            Set<IdentifierGenerator> sequences = this.sequences(sessionFactoryImplementor, provider);
            provider.getSequenceGenerator().createSequences(sequences);
        }

        private Set<IdentifierGenerator> sequences(SessionFactoryImplementor sessionFactoryImplementor, Neo4jDatastoreProvider provider) {
            Map entityPersisters = sessionFactoryImplementor.getEntityPersisters();
            HashSet<IdentifierGenerator> generators = new HashSet<IdentifierGenerator>(entityPersisters.size());
            for (EntityPersister persister : entityPersisters.values()) {
                generators.add(persister.getIdentifierGenerator());
            }
            return generators;
        }

        public void sessionFactoryClosed(SessionFactory factory) {
        }
    }
}

