/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.couchdb.dialect.backend.json.impl;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.hibernate.ogm.datastore.couchdb.dialect.backend.json.impl.Document;
import org.hibernate.ogm.datastore.couchdb.util.impl.Identifier;
import org.hibernate.ogm.datastore.spi.Tuple;
import org.hibernate.ogm.grid.EntityKey;

@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
@JsonTypeName(value="entity")
public class EntityDocument
extends Document {
    public static final String TYPE_NAME = "entity";
    private static final String TABLE_FIELD_NAME = "$table";
    private static final String PATH_SEPARATOR = ".";
    private static final Pattern PATH_SPLIT_PATTERN = Pattern.compile(Pattern.quote("."));
    private String table;
    private final Map<String, Object> properties = new HashMap<String, Object>();

    EntityDocument() {
    }

    public EntityDocument(EntityKey key) {
        this(key, null, null);
    }

    public EntityDocument(EntityKey key, String revision, Tuple tuple) {
        super(Identifier.createEntityId(key), revision);
        this.table = key.getTable();
        if (tuple != null) {
            for (String columnName : tuple.getColumnNames()) {
                if (columnName == "_rev") continue;
                this.properties.put(columnName, tuple.get(columnName));
            }
        }
    }

    @JsonProperty(value="$table")
    public String getTable() {
        return this.table;
    }

    @JsonProperty(value="$table")
    public void setTable(String table) {
        this.table = table;
    }

    @JsonIgnore
    public Map<String, Object> getProperties() {
        HashMap<String, Object> props = new HashMap<String, Object>(this.properties);
        if (this.getRevision() != null) {
            props.put("_rev", this.getRevision());
        }
        return props;
    }

    @JsonAnyGetter
    public Map<String, Object> getPropertiesAsHierarchy() {
        HashMap<String, Object> hierarchicalProperties = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
            String columnName = entry.getKey();
            if (this.isEmbeddedProperty(columnName)) {
                this.putEmbeddedProperty(hierarchicalProperties, columnName, entry.getValue());
                continue;
            }
            hierarchicalProperties.put(columnName, entry.getValue());
        }
        return hierarchicalProperties;
    }

    private void putEmbeddedProperty(Map<String, Object> root, String name, Object value) {
        String[] pathElements = PATH_SPLIT_PATTERN.split(name);
        HashMap<String, Object> owner = root;
        for (int i = 0; i < pathElements.length - 1; ++i) {
            String element = pathElements[i];
            HashMap<String, Object> nextOwner = (HashMap<String, Object>)owner.get(element);
            if (nextOwner == null) {
                nextOwner = new HashMap<String, Object>();
                owner.put(element, nextOwner);
            }
            owner = nextOwner;
        }
        owner.put(pathElements[pathElements.length - 1], value);
    }

    private boolean isEmbeddedProperty(String columnName) {
        return columnName.contains(PATH_SEPARATOR);
    }

    @JsonAnySetter
    public void set(String name, Object value) {
        if (value instanceof Map) {
            this.setMapValue(name, (Map)value);
        }
        this.properties.put(name, value);
    }

    private void setMapValue(String name, Map<String, Object> value) {
        for (Map.Entry<String, Object> entry : value.entrySet()) {
            this.set(name + PATH_SEPARATOR + entry.getKey(), entry.getValue());
        }
    }

    public List<Map<String, Object>> getAssociation(String name) {
        List<Map<String, Object>> association = (List<Map<String, Object>>)this.properties.get(name);
        return association != null ? association : Collections.emptyList();
    }

    @JsonIgnore
    public void setAssociation(String name, List<Map<String, Object>> rows) {
        this.properties.put(name, rows);
    }

    @JsonIgnore
    public void removeAssociation(String name) {
        this.properties.remove(name);
    }
}

