/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.couchdb.dialect.model.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.hibernate.ogm.datastore.spi.TupleSnapshot;
import org.hibernate.ogm.grid.EntityKey;

public class CouchDBTupleSnapshot
implements TupleSnapshot {
    private final Map<String, Object> properties;
    private final boolean createdOnInsert;

    public CouchDBTupleSnapshot(EntityKey key) {
        this.createdOnInsert = true;
        this.properties = new HashMap<String, Object>();
        for (int i = 0; i < key.getColumnNames().length; ++i) {
            this.properties.put(key.getColumnNames()[i], key.getColumnValues()[i]);
        }
    }

    public CouchDBTupleSnapshot(Map<String, Object> properties) {
        this.createdOnInsert = false;
        this.properties = properties;
    }

    public Object get(String column) {
        return this.properties.get(column);
    }

    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    public Set<String> getColumnNames() {
        return this.properties.keySet();
    }

    public boolean isCreatedOnInsert() {
        return this.createdOnInsert;
    }
}

