/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.neo4j.helpers.Predicate;
import org.neo4j.helpers.PrimitiveLongPredicate;
import org.neo4j.helpers.ThisShouldNotHappenError;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.constraints.UniquenessConstraint;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.exceptions.LabelNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.PropertyKeyIdNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.RelationshipTypeIdNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.TransactionalException;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.schema.ConstraintVerificationFailedKernelException;
import org.neo4j.kernel.api.exceptions.schema.CreateConstraintFailureException;
import org.neo4j.kernel.api.exceptions.schema.DropIndexFailureException;
import org.neo4j.kernel.api.exceptions.schema.IllegalTokenNameException;
import org.neo4j.kernel.api.exceptions.schema.IndexBrokenKernelException;
import org.neo4j.kernel.api.exceptions.schema.SchemaRuleNotFoundException;
import org.neo4j.kernel.api.exceptions.schema.TooManyLabelsException;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.api.properties.PropertyKeyIdIterator;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.LegacyPropertyTrackers;
import org.neo4j.kernel.impl.api.operations.EntityOperations;
import org.neo4j.kernel.impl.api.operations.KeyReadOperations;
import org.neo4j.kernel.impl.api.operations.KeyWriteOperations;
import org.neo4j.kernel.impl.api.operations.SchemaReadOperations;
import org.neo4j.kernel.impl.api.operations.SchemaWriteOperations;
import org.neo4j.kernel.impl.api.state.ConstraintIndexCreator;
import org.neo4j.kernel.impl.api.state.TxState;
import org.neo4j.kernel.impl.api.store.StoreReadLayer;
import org.neo4j.kernel.impl.core.Token;
import org.neo4j.kernel.impl.nioneo.store.SchemaStorage;
import org.neo4j.kernel.impl.util.DiffSets;
import org.neo4j.kernel.impl.util.PrimitiveIntIterator;
import org.neo4j.kernel.impl.util.PrimitiveLongIterator;

public class StateHandlingStatementOperations
implements KeyReadOperations,
KeyWriteOperations,
EntityOperations,
SchemaReadOperations,
SchemaWriteOperations {
    private final StoreReadLayer storeLayer;
    private final LegacyPropertyTrackers legacyPropertyTrackers;
    private final ConstraintIndexCreator constraintIndexCreator;

    public StateHandlingStatementOperations(StoreReadLayer storeLayer, LegacyPropertyTrackers propertyTrackers, ConstraintIndexCreator constraintIndexCreator) {
        this.storeLayer = storeLayer;
        this.legacyPropertyTrackers = propertyTrackers;
        this.constraintIndexCreator = constraintIndexCreator;
    }

    @Override
    public void nodeDelete(KernelStatement state, long nodeId) {
        this.legacyPropertyTrackers.nodeDelete(nodeId);
        state.txState().nodeDoDelete(nodeId);
    }

    @Override
    public void relationshipDelete(KernelStatement state, long relationshipId) {
        this.legacyPropertyTrackers.relationshipDelete(relationshipId);
        state.txState().relationshipDoDelete(relationshipId);
    }

    @Override
    public boolean nodeHasLabel(KernelStatement state, long nodeId, int labelId) throws EntityNotFoundException {
        if (state.hasTxStateWithChanges()) {
            if (state.txState().nodeIsDeletedInThisTx(nodeId)) {
                return false;
            }
            if (state.txState().nodeIsAddedInThisTx(nodeId)) {
                TxState.UpdateTriState labelState = state.txState().labelState(nodeId, labelId);
                return labelState.isTouched() && labelState.isAdded();
            }
            TxState.UpdateTriState labelState = state.txState().labelState(nodeId, labelId);
            if (labelState.isTouched()) {
                return labelState.isAdded();
            }
        }
        return this.storeLayer.nodeHasLabel(state, nodeId, labelId);
    }

    @Override
    public PrimitiveIntIterator nodeGetLabels(KernelStatement state, long nodeId) throws EntityNotFoundException {
        if (state.hasTxStateWithChanges()) {
            if (state.txState().nodeIsDeletedInThisTx(nodeId)) {
                return IteratorUtil.emptyPrimitiveIntIterator();
            }
            if (state.txState().nodeIsAddedInThisTx(nodeId)) {
                return IteratorUtil.toPrimitiveIntIterator(state.txState().nodeStateLabelDiffSets(nodeId).getAdded().iterator());
            }
            return state.txState().nodeStateLabelDiffSets(nodeId).applyPrimitiveIntIterator(this.storeLayer.nodeGetLabels(state, nodeId));
        }
        return this.storeLayer.nodeGetLabels(state, nodeId);
    }

    @Override
    public boolean nodeAddLabel(KernelStatement state, long nodeId, int labelId) throws EntityNotFoundException {
        if (this.nodeHasLabel(state, nodeId, labelId)) {
            return false;
        }
        state.txState().nodeDoAddLabel(labelId, nodeId);
        return true;
    }

    @Override
    public boolean nodeRemoveLabel(KernelStatement state, long nodeId, int labelId) throws EntityNotFoundException {
        if (!this.nodeHasLabel(state, nodeId, labelId)) {
            return false;
        }
        state.txState().nodeDoRemoveLabel(labelId, nodeId);
        return true;
    }

    @Override
    public PrimitiveLongIterator nodesGetForLabel(KernelStatement state, int labelId) {
        if (state.hasTxStateWithChanges()) {
            PrimitiveLongIterator wLabelChanges = state.txState().nodesWithLabelChanged(labelId).applyPrimitiveLongIterator(this.storeLayer.nodesGetForLabel(state, labelId));
            return state.txState().nodesDeletedInTx().applyPrimitiveLongIterator(wLabelChanges);
        }
        return this.storeLayer.nodesGetForLabel(state, labelId);
    }

    @Override
    public IndexDescriptor indexCreate(KernelStatement state, int labelId, int propertyKey) {
        IndexDescriptor rule = new IndexDescriptor(labelId, propertyKey);
        state.txState().indexRuleDoAdd(rule);
        return rule;
    }

    @Override
    public void indexDrop(KernelStatement state, IndexDescriptor descriptor) throws DropIndexFailureException {
        state.txState().indexDoDrop(descriptor);
    }

    @Override
    public void uniqueIndexDrop(KernelStatement state, IndexDescriptor descriptor) throws DropIndexFailureException {
        state.txState().constraintIndexDoDrop(descriptor);
    }

    @Override
    public UniquenessConstraint uniquenessConstraintCreate(KernelStatement state, int labelId, int propertyKeyId) throws CreateConstraintFailureException {
        UniquenessConstraint constraint = new UniquenessConstraint(labelId, propertyKeyId);
        try {
            IndexDescriptor index = new IndexDescriptor(labelId, propertyKeyId);
            if (state.txState().constraintIndexDoUnRemove(index)) {
                state.txState().constraintIndexDiffSetsByLabel(labelId).unRemove(index);
                if (!state.txState().constraintDoUnRemove(constraint)) {
                    state.txState().constraintsChangesForLabel(labelId).unRemove(constraint);
                    state.txState().constraintDoAdd(constraint, state.txState().indexCreatedForConstraint(constraint));
                }
            } else {
                Iterator<UniquenessConstraint> it = this.storeLayer.constraintsGetForLabelAndPropertyKey(state, labelId, propertyKeyId);
                while (it.hasNext()) {
                    if (!it.next().equals(labelId, propertyKeyId)) continue;
                    return constraint;
                }
                long indexId = this.constraintIndexCreator.createUniquenessConstraintIndex(state, this, labelId, propertyKeyId);
                state.txState().constraintDoAdd(constraint, indexId);
            }
            return constraint;
        }
        catch (TransactionalException | ConstraintVerificationFailedKernelException | DropIndexFailureException e) {
            throw new CreateConstraintFailureException(constraint, (Throwable)e);
        }
    }

    @Override
    public Iterator<UniquenessConstraint> constraintsGetForLabelAndPropertyKey(KernelStatement state, int labelId, int propertyKeyId) {
        return this.applyConstraintsDiff(state, this.storeLayer.constraintsGetForLabelAndPropertyKey(state, labelId, propertyKeyId), labelId, propertyKeyId);
    }

    @Override
    public Iterator<UniquenessConstraint> constraintsGetForLabel(KernelStatement state, int labelId) {
        return this.applyConstraintsDiff(state, this.storeLayer.constraintsGetForLabel(state, labelId), labelId);
    }

    @Override
    public Iterator<UniquenessConstraint> constraintsGetAll(KernelStatement state) {
        return this.applyConstraintsDiff(state, this.storeLayer.constraintsGetAll(state));
    }

    private Iterator<UniquenessConstraint> applyConstraintsDiff(KernelStatement state, Iterator<UniquenessConstraint> constraints, int labelId, int propertyKeyId) {
        DiffSets<UniquenessConstraint> diff;
        if (state.hasTxStateWithChanges() && (diff = state.txState().constraintsChangesForLabelAndProperty(labelId, propertyKeyId)) != null) {
            return diff.apply(constraints);
        }
        return constraints;
    }

    private Iterator<UniquenessConstraint> applyConstraintsDiff(KernelStatement state, Iterator<UniquenessConstraint> constraints, int labelId) {
        DiffSets<UniquenessConstraint> diff;
        if (state.hasTxStateWithChanges() && (diff = state.txState().constraintsChangesForLabel(labelId)) != null) {
            return diff.apply(constraints);
        }
        return constraints;
    }

    private Iterator<UniquenessConstraint> applyConstraintsDiff(KernelStatement state, Iterator<UniquenessConstraint> constraints) {
        DiffSets<UniquenessConstraint> diff;
        if (state.hasTxStateWithChanges() && (diff = state.txState().constraintsChanges()) != null) {
            return diff.apply(constraints);
        }
        return constraints;
    }

    @Override
    public void constraintDrop(KernelStatement state, UniquenessConstraint constraint) {
        state.txState().constraintDoDrop(constraint);
    }

    @Override
    public IndexDescriptor indexesGetForLabelAndPropertyKey(KernelStatement state, int labelId, int propertyKey) throws SchemaRuleNotFoundException {
        Iterable<Object> committedRules;
        try {
            committedRules = Iterables.option(this.storeLayer.indexesGetForLabelAndPropertyKey(state, labelId, propertyKey));
        }
        catch (SchemaRuleNotFoundException e) {
            committedRules = Collections.emptyList();
        }
        DiffSets<IndexDescriptor> ruleDiffSet = state.txState().indexDiffSetsByLabel(labelId);
        Iterator<Object> rules = state.hasTxStateWithChanges() ? ruleDiffSet.apply(committedRules.iterator()) : committedRules.iterator();
        IndexDescriptor single = (IndexDescriptor)IteratorUtil.singleOrNull(rules);
        if (single == null) {
            throw new SchemaRuleNotFoundException("Index rule for label:" + labelId + " and property:" + propertyKey + " not found");
        }
        return single;
    }

    @Override
    public InternalIndexState indexGetState(KernelStatement state, IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        if (state.hasTxStateWithChanges()) {
            if (this.checkIndexState(descriptor, state.txState().indexDiffSetsByLabel(descriptor.getLabelId()))) {
                return InternalIndexState.POPULATING;
            }
            if (this.checkIndexState(descriptor, state.txState().constraintIndexDiffSetsByLabel(descriptor.getLabelId()))) {
                return InternalIndexState.POPULATING;
            }
        }
        return this.storeLayer.indexGetState(state, descriptor);
    }

    private boolean checkIndexState(IndexDescriptor indexRule, DiffSets<IndexDescriptor> diffSet) throws IndexNotFoundKernelException {
        if (diffSet.isAdded(indexRule)) {
            return true;
        }
        if (diffSet.isRemoved(indexRule)) {
            throw new IndexNotFoundKernelException(String.format("Index for label id %d on property id %d has been dropped in this transaction.", indexRule.getLabelId(), indexRule.getPropertyKeyId()));
        }
        return false;
    }

    @Override
    public Iterator<IndexDescriptor> indexesGetForLabel(KernelStatement state, int labelId) {
        if (state.hasTxStateWithChanges()) {
            return state.txState().indexDiffSetsByLabel(labelId).apply(this.storeLayer.indexesGetForLabel(state, labelId));
        }
        return this.storeLayer.indexesGetForLabel(state, labelId);
    }

    @Override
    public Iterator<IndexDescriptor> indexesGetAll(KernelStatement state) {
        if (state.hasTxStateWithChanges()) {
            return state.txState().indexChanges().apply(this.storeLayer.indexesGetAll(state));
        }
        return this.storeLayer.indexesGetAll(state);
    }

    @Override
    public Iterator<IndexDescriptor> uniqueIndexesGetForLabel(KernelStatement state, int labelId) {
        if (state.hasTxStateWithChanges()) {
            return state.txState().constraintIndexDiffSetsByLabel(labelId).apply(this.storeLayer.uniqueIndexesGetForLabel(state, labelId));
        }
        return this.storeLayer.uniqueIndexesGetForLabel(state, labelId);
    }

    @Override
    public Iterator<IndexDescriptor> uniqueIndexesGetAll(KernelStatement state) {
        if (state.hasTxStateWithChanges()) {
            return state.txState().constraintIndexChanges().apply(this.storeLayer.uniqueIndexesGetAll(state));
        }
        return this.storeLayer.uniqueIndexesGetAll(state);
    }

    @Override
    public long nodeGetUniqueFromIndexLookup(KernelStatement state, IndexDescriptor index, Object value) throws IndexNotFoundKernelException, IndexBrokenKernelException {
        PrimitiveLongIterator committed = this.storeLayer.nodeGetUniqueFromIndexLookup(state, index, value);
        PrimitiveLongIterator exactMatches = this.filterExactIndexMatches(state, index, value, committed);
        PrimitiveLongIterator changeFilteredMatches = this.filterIndexStateChanges(state, index, value, exactMatches);
        return IteratorUtil.single(changeFilteredMatches, -1L);
    }

    @Override
    public PrimitiveLongIterator nodesGetFromIndexLookup(KernelStatement state, IndexDescriptor index, Object value) throws IndexNotFoundKernelException {
        PrimitiveLongIterator committed = this.storeLayer.nodesGetFromIndexLookup(state, index, value);
        PrimitiveLongIterator exactMatches = this.filterExactIndexMatches(state, index, value, committed);
        PrimitiveLongIterator changeFilteredMatches = this.filterIndexStateChanges(state, index, value, exactMatches);
        return changeFilteredMatches;
    }

    private PrimitiveLongIterator filterExactIndexMatches(KernelStatement state, IndexDescriptor index, Object value, PrimitiveLongIterator committed) {
        if (this.isNumberOrArray(value)) {
            return IteratorUtil.filter(this.exactMatch(state, index.getPropertyKeyId(), value), committed);
        }
        return committed;
    }

    private boolean isNumberOrArray(Object value) {
        return value instanceof Number || value.getClass().isArray();
    }

    private PrimitiveLongPredicate exactMatch(final KernelStatement state, final int propertyKeyId, final Object value) {
        return new PrimitiveLongPredicate(){

            @Override
            public boolean accept(long nodeId) {
                try {
                    return StateHandlingStatementOperations.this.nodeGetProperty(state, nodeId, propertyKeyId).valueEquals(value);
                }
                catch (EntityNotFoundException e) {
                    throw new ThisShouldNotHappenError("Chris", "An index claims a node by id " + nodeId + " has the value. However, it looks like that node does not exist.", e);
                }
            }
        };
    }

    private PrimitiveLongIterator filterIndexStateChanges(KernelStatement state, IndexDescriptor index, Object value, PrimitiveLongIterator nodeIds) {
        if (state.hasTxStateWithChanges()) {
            DiffSets<Long> labelPropertyChanges = this.nodesWithLabelAndPropertyDiffSet(state, index, value);
            DiffSets<Long> deletionChanges = state.txState().nodesDeletedInTx();
            return deletionChanges.applyPrimitiveLongIterator(labelPropertyChanges.applyPrimitiveLongIterator(nodeIds));
        }
        return nodeIds;
    }

    @Override
    public Property nodeSetProperty(KernelStatement state, long nodeId, DefinedProperty property) throws EntityNotFoundException {
        Property existingProperty = this.nodeGetProperty(state, nodeId, property.propertyKeyId());
        if (!existingProperty.isDefined()) {
            this.legacyPropertyTrackers.nodeAddStoreProperty(nodeId, property);
            state.neoStoreTransaction.nodeAddProperty(nodeId, property.propertyKeyId(), property.value());
        } else {
            this.legacyPropertyTrackers.nodeChangeStoreProperty(nodeId, (DefinedProperty)existingProperty, property);
            state.neoStoreTransaction.nodeChangeProperty(nodeId, property.propertyKeyId(), property.value());
        }
        state.txState().nodeDoReplaceProperty(nodeId, existingProperty, property);
        return existingProperty;
    }

    @Override
    public Property relationshipSetProperty(KernelStatement state, long relationshipId, DefinedProperty property) throws EntityNotFoundException {
        Property existingProperty = this.relationshipGetProperty(state, relationshipId, property.propertyKeyId());
        if (!existingProperty.isDefined()) {
            this.legacyPropertyTrackers.relationshipAddStoreProperty(relationshipId, property);
            state.neoStoreTransaction.relAddProperty(relationshipId, property.propertyKeyId(), property.value());
        } else {
            this.legacyPropertyTrackers.relationshipChangeStoreProperty(relationshipId, (DefinedProperty)existingProperty, property);
            state.neoStoreTransaction.relChangeProperty(relationshipId, property.propertyKeyId(), property.value());
        }
        state.txState().relationshipDoReplaceProperty(relationshipId, existingProperty, property);
        return existingProperty;
    }

    @Override
    public Property graphSetProperty(KernelStatement state, DefinedProperty property) {
        Property existingProperty = this.graphGetProperty(state, property.propertyKeyId());
        if (!existingProperty.isDefined()) {
            state.neoStoreTransaction.graphAddProperty(property.propertyKeyId(), property.value());
        } else {
            state.neoStoreTransaction.graphChangeProperty(property.propertyKeyId(), property.value());
        }
        state.txState().graphDoReplaceProperty(existingProperty, property);
        return existingProperty;
    }

    @Override
    public Property nodeRemoveProperty(KernelStatement state, long nodeId, int propertyKeyId) throws EntityNotFoundException {
        Property existingProperty = this.nodeGetProperty(state, nodeId, propertyKeyId);
        if (existingProperty.isDefined()) {
            this.legacyPropertyTrackers.nodeRemoveStoreProperty(nodeId, (DefinedProperty)existingProperty);
            state.neoStoreTransaction.nodeRemoveProperty(nodeId, propertyKeyId);
        }
        state.txState().nodeDoRemoveProperty(nodeId, existingProperty);
        return existingProperty;
    }

    @Override
    public Property relationshipRemoveProperty(KernelStatement state, long relationshipId, int propertyKeyId) throws EntityNotFoundException {
        Property existingProperty = this.relationshipGetProperty(state, relationshipId, propertyKeyId);
        if (existingProperty.isDefined()) {
            this.legacyPropertyTrackers.relationshipRemoveStoreProperty(relationshipId, (DefinedProperty)existingProperty);
            state.neoStoreTransaction.relRemoveProperty(relationshipId, propertyKeyId);
        }
        state.txState().relationshipDoRemoveProperty(relationshipId, existingProperty);
        return existingProperty;
    }

    @Override
    public Property graphRemoveProperty(KernelStatement state, int propertyKeyId) {
        Property existingProperty = this.graphGetProperty(state, propertyKeyId);
        if (existingProperty.isDefined()) {
            state.neoStoreTransaction.graphRemoveProperty(propertyKeyId);
        }
        state.txState().graphDoRemoveProperty(existingProperty);
        return existingProperty;
    }

    @Override
    public PrimitiveLongIterator nodeGetPropertyKeys(KernelStatement state, long nodeId) throws EntityNotFoundException {
        if (state.hasTxStateWithChanges()) {
            return new PropertyKeyIdIterator(this.nodeGetAllProperties(state, nodeId));
        }
        return this.storeLayer.nodeGetPropertyKeys(state, nodeId);
    }

    @Override
    public Property nodeGetProperty(KernelStatement state, long nodeId, int propertyKeyId) throws EntityNotFoundException {
        if (state.hasTxStateWithChanges()) {
            Iterator<DefinedProperty> properties = this.nodeGetAllProperties(state, nodeId);
            while (properties.hasNext()) {
                Property property = properties.next();
                if (property.propertyKeyId() != propertyKeyId) continue;
                return property;
            }
            return Property.noNodeProperty(nodeId, propertyKeyId);
        }
        return this.storeLayer.nodeGetProperty(state, nodeId, propertyKeyId);
    }

    @Override
    public Iterator<DefinedProperty> nodeGetAllProperties(KernelStatement state, long nodeId) throws EntityNotFoundException {
        if (state.hasTxStateWithChanges()) {
            if (state.txState().nodeIsAddedInThisTx(nodeId)) {
                return state.txState().nodePropertyDiffSets(nodeId).getAdded().iterator();
            }
            if (state.txState().nodeIsDeletedInThisTx(nodeId)) {
                throw new IllegalStateException("Node " + nodeId + " has been deleted");
            }
            return state.txState().nodePropertyDiffSets(nodeId).apply(this.storeLayer.nodeGetAllProperties(state, nodeId));
        }
        return this.storeLayer.nodeGetAllProperties(state, nodeId);
    }

    @Override
    public PrimitiveLongIterator relationshipGetPropertyKeys(KernelStatement state, long relationshipId) throws EntityNotFoundException {
        if (state.hasTxStateWithChanges()) {
            return new PropertyKeyIdIterator(this.relationshipGetAllProperties(state, relationshipId));
        }
        return this.storeLayer.relationshipGetPropertyKeys(state, relationshipId);
    }

    @Override
    public Property relationshipGetProperty(KernelStatement state, long relationshipId, int propertyKeyId) throws EntityNotFoundException {
        if (state.hasTxStateWithChanges()) {
            Iterator<DefinedProperty> properties = this.relationshipGetAllProperties(state, relationshipId);
            while (properties.hasNext()) {
                Property property = properties.next();
                if (property.propertyKeyId() != propertyKeyId) continue;
                return property;
            }
            return Property.noRelationshipProperty(relationshipId, propertyKeyId);
        }
        return this.storeLayer.relationshipGetProperty(state, relationshipId, propertyKeyId);
    }

    @Override
    public Iterator<DefinedProperty> relationshipGetAllProperties(KernelStatement state, long relationshipId) throws EntityNotFoundException {
        if (state.hasTxStateWithChanges()) {
            if (state.txState().relationshipIsAddedInThisTx(relationshipId)) {
                return state.txState().relationshipPropertyDiffSets(relationshipId).getAdded().iterator();
            }
            if (state.txState().relationshipIsDeletedInThisTx(relationshipId)) {
                throw new IllegalStateException("Relationship " + relationshipId + " has been deleted");
            }
            return state.txState().relationshipPropertyDiffSets(relationshipId).apply(this.storeLayer.relationshipGetAllProperties(state, relationshipId));
        }
        return this.storeLayer.relationshipGetAllProperties(state, relationshipId);
    }

    @Override
    public PrimitiveLongIterator graphGetPropertyKeys(KernelStatement state) {
        if (state.hasTxStateWithChanges()) {
            return new PropertyKeyIdIterator(this.graphGetAllProperties(state));
        }
        return this.storeLayer.graphGetPropertyKeys(state);
    }

    @Override
    public Property graphGetProperty(KernelStatement state, int propertyKeyId) {
        Iterator<DefinedProperty> properties = this.graphGetAllProperties(state);
        while (properties.hasNext()) {
            Property property = properties.next();
            if (property.propertyKeyId() != propertyKeyId) continue;
            return property;
        }
        return Property.noGraphProperty(propertyKeyId);
    }

    @Override
    public Iterator<DefinedProperty> graphGetAllProperties(KernelStatement state) {
        if (state.hasTxStateWithChanges()) {
            return state.txState().graphPropertyDiffSets().apply(this.storeLayer.graphGetAllProperties(state));
        }
        return this.storeLayer.graphGetAllProperties(state);
    }

    private DiffSets<Long> nodesWithLabelAndPropertyDiffSet(KernelStatement state, IndexDescriptor index, Object value) {
        TxState txState = state.txState();
        int labelId = index.getLabelId();
        int propertyKeyId = index.getPropertyKeyId();
        DiffSets<Long> diff = txState.nodesWithChangedProperty(propertyKeyId, value);
        HasLabelFilter hasLabel = new HasLabelFilter(state, labelId);
        diff = diff.filter(hasLabel);
        HasPropertyFilter hasPropertyFilter = new HasPropertyFilter(state, propertyKeyId, value);
        Iterator<Long> addedNodesWithLabel = txState.nodesWithLabelAdded(labelId).iterator();
        diff.addAll(Iterables.filter(hasPropertyFilter, addedNodesWithLabel));
        Set<Long> removedNodesWithLabel = txState.nodesWithLabelChanged(index.getLabelId()).getRemoved();
        diff.removeAll(Iterables.filter(hasPropertyFilter, removedNodesWithLabel.iterator()));
        return diff;
    }

    private long nodeIfNotDeleted(long nodeId, TxState txState) {
        return txState.nodeIsDeletedInThisTx(nodeId) ? -1L : nodeId;
    }

    @Override
    public Long indexGetOwningUniquenessConstraintId(KernelStatement state, IndexDescriptor index) throws SchemaRuleNotFoundException {
        return this.storeLayer.indexGetOwningUniquenessConstraintId(state, index);
    }

    @Override
    public long indexGetCommittedId(KernelStatement state, IndexDescriptor index, SchemaStorage.IndexRuleKind kind) throws SchemaRuleNotFoundException {
        return this.storeLayer.indexGetCommittedId(state, index, kind);
    }

    @Override
    public String indexGetFailure(Statement state, IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        return this.storeLayer.indexGetFailure(state, descriptor);
    }

    @Override
    public int labelGetForName(Statement state, String labelName) {
        return this.storeLayer.labelGetForName(labelName);
    }

    @Override
    public String labelGetName(Statement state, int labelId) throws LabelNotFoundKernelException {
        return this.storeLayer.labelGetName(labelId);
    }

    @Override
    public int propertyKeyGetForName(Statement state, String propertyKeyName) {
        return this.storeLayer.propertyKeyGetForName(propertyKeyName);
    }

    @Override
    public String propertyKeyGetName(Statement state, int propertyKeyId) throws PropertyKeyIdNotFoundKernelException {
        return this.storeLayer.propertyKeyGetName(propertyKeyId);
    }

    @Override
    public Iterator<Token> propertyKeyGetAllTokens(Statement state) {
        return this.storeLayer.propertyKeyGetAllTokens();
    }

    @Override
    public Iterator<Token> labelsGetAllTokens(Statement state) {
        return this.storeLayer.labelsGetAllTokens();
    }

    @Override
    public int relationshipTypeGetForName(Statement state, String relationshipTypeName) {
        return this.storeLayer.relationshipTypeGetForName(relationshipTypeName);
    }

    @Override
    public String relationshipTypeGetName(Statement state, int relationshipTypeId) throws RelationshipTypeIdNotFoundKernelException {
        return this.storeLayer.relationshipTypeGetName(relationshipTypeId);
    }

    @Override
    public int labelGetOrCreateForName(Statement state, String labelName) throws IllegalTokenNameException, TooManyLabelsException {
        return this.storeLayer.labelGetOrCreateForName(labelName);
    }

    @Override
    public int propertyKeyGetOrCreateForName(Statement state, String propertyKeyName) throws IllegalTokenNameException {
        return this.storeLayer.propertyKeyGetOrCreateForName(propertyKeyName);
    }

    @Override
    public int relationshipTypeGetOrCreateForName(Statement state, String relationshipTypeName) throws IllegalTokenNameException {
        return this.storeLayer.relationshipTypeGetOrCreateForName(relationshipTypeName);
    }

    private class HasLabelFilter
    implements Predicate<Long> {
        private final int labelId;
        private final KernelStatement state;

        public HasLabelFilter(KernelStatement state, int labelId) {
            this.state = state;
            this.labelId = labelId;
        }

        @Override
        public boolean accept(Long nodeId) {
            try {
                return StateHandlingStatementOperations.this.nodeHasLabel(this.state, nodeId, this.labelId);
            }
            catch (EntityNotFoundException e) {
                return false;
            }
        }
    }

    private class HasPropertyFilter
    implements Predicate<Long> {
        private final Object value;
        private final int propertyKeyId;
        private final KernelStatement state;

        public HasPropertyFilter(KernelStatement state, int propertyKeyId, Object value) {
            this.state = state;
            this.value = value;
            this.propertyKeyId = propertyKeyId;
        }

        @Override
        public boolean accept(Long nodeId) {
            try {
                if (this.state.hasTxStateWithChanges() && this.state.txState().nodeIsDeletedInThisTx(nodeId)) {
                    return false;
                }
                Property property = StateHandlingStatementOperations.this.nodeGetProperty(this.state, nodeId, this.propertyKeyId);
                return property.isDefined() && property.valueEquals(this.value);
            }
            catch (EntityNotFoundException e) {
                return false;
            }
        }
    }
}

