/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.dialect;

import org.hibernate.LockMode;
import org.hibernate.dialect.lock.LockingStrategy;
import org.hibernate.engine.spi.QueryParameters;
import org.hibernate.ogm.datastore.spi.Association;
import org.hibernate.ogm.datastore.spi.AssociationContext;
import org.hibernate.ogm.datastore.spi.Tuple;
import org.hibernate.ogm.datastore.spi.TupleContext;
import org.hibernate.ogm.dialect.BatchableGridDialect;
import org.hibernate.ogm.dialect.batch.OperationsQueue;
import org.hibernate.ogm.dialect.batch.RemoveAssociationOperation;
import org.hibernate.ogm.dialect.batch.RemoveTupleOperation;
import org.hibernate.ogm.dialect.batch.UpdateAssociationOperation;
import org.hibernate.ogm.dialect.batch.UpdateTupleOperation;
import org.hibernate.ogm.grid.AssociationKey;
import org.hibernate.ogm.grid.EntityKey;
import org.hibernate.ogm.grid.EntityKeyMetadata;
import org.hibernate.ogm.grid.RowKey;
import org.hibernate.ogm.id.spi.NextValueRequest;
import org.hibernate.ogm.loader.nativeloader.BackendCustomQuery;
import org.hibernate.ogm.massindex.batchindexing.Consumer;
import org.hibernate.ogm.query.spi.ParameterMetadataBuilder;
import org.hibernate.ogm.type.GridType;
import org.hibernate.ogm.util.ClosableIterator;
import org.hibernate.persister.entity.Lockable;
import org.hibernate.type.Type;

public class BatchOperationsDelegator
implements BatchableGridDialect {
    private final ThreadLocal<OperationsQueue> operationQueueLocal = new ThreadLocal();
    private final BatchableGridDialect dialect;

    public BatchOperationsDelegator(BatchableGridDialect dialect) {
        this.dialect = dialect;
    }

    public void prepareBatch() {
        this.operationQueueLocal.set(new OperationsQueue());
    }

    private boolean isBatchDisabled() {
        return this.getOperationQueue().isClosed();
    }

    public void clearBatch() {
        this.operationQueueLocal.remove();
    }

    private OperationsQueue getOperationQueue() {
        OperationsQueue operationsQueue = this.operationQueueLocal.get();
        if (operationsQueue == null) {
            return OperationsQueue.CLOSED_QUEUE;
        }
        return operationsQueue;
    }

    public void executeBatch() {
        this.executeBatch(this.getOperationQueue());
    }

    @Override
    public void executeBatch(OperationsQueue queue) {
        this.dialect.executeBatch(this.getOperationQueue());
    }

    @Override
    public LockingStrategy getLockingStrategy(Lockable lockable, LockMode lockMode) {
        return this.dialect.getLockingStrategy(lockable, lockMode);
    }

    @Override
    public Tuple getTuple(EntityKey key, TupleContext tupleContext) {
        TupleContext contextWithQueue = new TupleContext(tupleContext.getSelectableColumns(), tupleContext.getOptionsContext(), this.getOperationQueue());
        return this.dialect.getTuple(key, contextWithQueue);
    }

    @Override
    public Tuple createTuple(EntityKey key, TupleContext tupleContext) {
        return this.dialect.createTuple(key, tupleContext);
    }

    @Override
    public void updateTuple(Tuple tuple, EntityKey key, TupleContext tupleContext) {
        if (this.isBatchDisabled()) {
            this.dialect.updateTuple(tuple, key, tupleContext);
        } else {
            this.getOperationQueue().add(new UpdateTupleOperation(tuple, key, tupleContext));
        }
    }

    @Override
    public void removeTuple(EntityKey key, TupleContext tupleContext) {
        if (this.isBatchDisabled()) {
            this.dialect.removeTuple(key, tupleContext);
        } else {
            this.getOperationQueue().add(new RemoveTupleOperation(key, tupleContext));
        }
    }

    @Override
    public Association getAssociation(AssociationKey key, AssociationContext associationContext) {
        associationContext.setOperationsQueue(this.getOperationQueue());
        return this.dialect.getAssociation(key, associationContext);
    }

    @Override
    public Association createAssociation(AssociationKey key, AssociationContext associationContext) {
        return this.dialect.createAssociation(key, associationContext);
    }

    @Override
    public void updateAssociation(Association association, AssociationKey key, AssociationContext associationContext) {
        if (this.isBatchDisabled()) {
            this.dialect.updateAssociation(association, key, associationContext);
        } else {
            this.getOperationQueue().add(new UpdateAssociationOperation(association, key, associationContext));
        }
    }

    @Override
    public void removeAssociation(AssociationKey key, AssociationContext associationContext) {
        if (this.isBatchDisabled()) {
            this.dialect.removeAssociation(key, associationContext);
        } else {
            this.getOperationQueue().add(new RemoveAssociationOperation(key, associationContext));
        }
    }

    @Override
    public Tuple createTupleAssociation(AssociationKey associationKey, RowKey rowKey) {
        return this.dialect.createTupleAssociation(associationKey, rowKey);
    }

    @Override
    public Number nextValue(NextValueRequest request) {
        return this.dialect.nextValue(request);
    }

    @Override
    public boolean supportsSequences() {
        return false;
    }

    @Override
    public GridType overrideType(Type type) {
        return this.dialect.overrideType(type);
    }

    @Override
    public void forEachTuple(Consumer consumer, EntityKeyMetadata ... entityKeyMetadatas) {
        this.dialect.forEachTuple(consumer, entityKeyMetadatas);
    }

    @Override
    public ClosableIterator<Tuple> executeBackendQuery(BackendCustomQuery customQuery, QueryParameters queryParameters) {
        return this.dialect.executeBackendQuery(customQuery, queryParameters);
    }

    @Override
    public boolean isStoredInEntityStructure(AssociationKey associationKey, AssociationContext associationContext) {
        return this.dialect.isStoredInEntityStructure(associationKey, associationContext);
    }

    @Override
    public ParameterMetadataBuilder getParameterMetadataBuilder() {
        return this.dialect.getParameterMetadataBuilder();
    }
}

