/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.grid;

import java.util.Arrays;
import org.hibernate.ogm.grid.IdSourceKeyMetadata;
import org.hibernate.ogm.grid.Key;

public class IdSourceKey
implements Key {
    private final IdSourceKeyMetadata metadata;
    private final String[] columnNames;
    private final Object[] columnValues;
    private final int hashCode;

    private IdSourceKey(IdSourceKeyMetadata metadata, Object[] columnValues) {
        String[] stringArray;
        this.metadata = metadata;
        if (metadata.getKeyColumnName() != null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = metadata.getKeyColumnName();
        } else {
            stringArray = null;
        }
        this.columnNames = stringArray;
        this.columnValues = columnValues;
        this.hashCode = this.calculateHashCode();
    }

    public static IdSourceKey forTable(IdSourceKeyMetadata metadata, String segmentName) {
        return new IdSourceKey(metadata, new Object[]{segmentName});
    }

    public static IdSourceKey forSequence(IdSourceKeyMetadata metadata) {
        return new IdSourceKey(metadata, null);
    }

    public IdSourceKeyMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public String getTable() {
        return this.metadata.getName();
    }

    @Override
    public String[] getColumnNames() {
        return this.columnNames;
    }

    @Override
    public Object[] getColumnValues() {
        return this.columnValues;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IdSourceKey other = (IdSourceKey)obj;
        if (!Arrays.equals(this.columnValues, other.columnValues)) {
            return false;
        }
        return !(this.metadata == null ? other.metadata != null : !this.metadata.equals(other.metadata));
    }

    public String toString() {
        return "IdSourceKey [metadata=" + this.metadata + ", columnNames=" + Arrays.toString(this.columnNames) + ", columnValues=" + Arrays.toString(this.columnValues) + "]";
    }

    private int calculateHashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.columnValues);
        result = 31 * result + (this.metadata == null ? 0 : this.metadata.hashCode());
        return result;
    }
}

