/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.id.impl;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.id.Configurable;
import org.hibernate.id.IdentifierGeneratorHelper;
import org.hibernate.id.IntegralDataTypeHolder;
import org.hibernate.id.enhanced.AccessCallback;
import org.hibernate.id.enhanced.Optimizer;
import org.hibernate.id.enhanced.OptimizerFactory;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.jdbc.AbstractReturningWork;
import org.hibernate.jdbc.WorkExecutorVisitable;
import org.hibernate.ogm.dialect.GridDialect;
import org.hibernate.ogm.dialect.impl.OgmDialect;
import org.hibernate.ogm.grid.IdSourceKey;
import org.hibernate.ogm.id.spi.NextValueRequest;
import org.hibernate.ogm.id.spi.PersistentNoSqlIdentifierGenerator;
import org.hibernate.type.Type;

public abstract class OgmGeneratorBase
implements PersistentNoSqlIdentifierGenerator,
Configurable {
    public static final String OPT_PARAM = "optimizer";
    public static final String INITIAL_PARAM = "initial_value";
    public static final int DEFAULT_INITIAL_VALUE = 1;
    public static final String INCREMENT_PARAM = "increment_size";
    public static final int DEFAULT_INCREMENT_SIZE = 1;
    private Type identifierType;
    private Optimizer optimizer;
    private int initialValue;
    private int incrementSize;
    private GridDialect gridDialect;

    public void configure(Type type, Properties params, Dialect dialect) throws MappingException {
        this.identifierType = type;
        this.incrementSize = this.determineIncrementSize(params);
        this.initialValue = this.determineInitialValue(params);
        String defaultPooledOptimizerStrategy = ConfigurationHelper.getBoolean((String)"hibernate.id.optimizer.pooled.prefer_lo", (Map)params, (boolean)false) ? "pooled-lo" : "pooled";
        String defaultOptimizerStrategy = this.incrementSize <= 1 ? OptimizerFactory.NONE : defaultPooledOptimizerStrategy;
        String optimizationStrategy = ConfigurationHelper.getString((String)OPT_PARAM, (Map)params, (String)defaultOptimizerStrategy);
        this.optimizer = OptimizerFactory.buildOptimizer((String)optimizationStrategy, (Class)this.identifierType.getReturnedClass(), (int)this.incrementSize, (long)ConfigurationHelper.getInt((String)INITIAL_PARAM, (Map)params, (int)-1));
        this.gridDialect = ((OgmDialect)dialect).getGridDialect();
    }

    public final int getInitialValue() {
        return this.initialValue;
    }

    public final int getIncrementSize() {
        return this.incrementSize;
    }

    protected abstract IdSourceKey getGeneratorKey(SessionImplementor var1);

    protected GridDialect getGridDialect() {
        return this.gridDialect;
    }

    public synchronized Serializable generate(final SessionImplementor session, Object obj) {
        return this.optimizer.generate(new AccessCallback(){

            public IntegralDataTypeHolder getNextValue() {
                return (IntegralDataTypeHolder)OgmGeneratorBase.this.doWorkInIsolationTransaction(session);
            }

            public String getTenantIdentifier() {
                return session.getTenantIdentifier();
            }
        });
    }

    private Serializable doWorkInIsolationTransaction(final SessionImplementor session) throws HibernateException {
        boolean workInTransaction = false;
        class Work
        extends AbstractReturningWork<IntegralDataTypeHolder> {
            private final SessionImplementor localSession;

            Work() {
                this.localSession = session;
            }

            public IntegralDataTypeHolder execute(Connection connection) throws SQLException {
                try {
                    return OgmGeneratorBase.this.doWorkInCurrentTransactionIfAny(this.localSession);
                }
                catch (RuntimeException sqle) {
                    throw new HibernateException("Could not get or update next value", (Throwable)sqle);
                }
            }
        }
        Work work = new Work();
        Serializable generatedValue = (Serializable)session.getTransactionCoordinator().getTransaction().createIsolationDelegate().delegateWork((WorkExecutorVisitable)work, workInTransaction);
        return generatedValue;
    }

    private IntegralDataTypeHolder doWorkInCurrentTransactionIfAny(SessionImplementor session) {
        IdSourceKey key = this.getGeneratorKey(session);
        Number nextValue = this.gridDialect.nextValue(new NextValueRequest(key, this.optimizer.applyIncrementSizeToSourceValues() ? this.incrementSize : 1, this.initialValue));
        IntegralDataTypeHolder value = IdentifierGeneratorHelper.getIntegralDataTypeHolder((Class)this.identifierType.getReturnedClass());
        value.initialize(nextValue.longValue());
        return value;
    }

    private int determineIncrementSize(Properties params) {
        return ConfigurationHelper.getInt((String)INCREMENT_PARAM, (Map)params, (int)1);
    }

    private int determineInitialValue(Properties params) {
        return ConfigurationHelper.getInt((String)INITIAL_PARAM, (Map)params, (int)1);
    }
}

