/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.persister;

import java.io.Serializable;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.ogm.datastore.spi.Association;
import org.hibernate.ogm.datastore.spi.Tuple;
import org.hibernate.ogm.dialect.GridDialect;
import org.hibernate.ogm.grid.AssociationKeyMetadata;
import org.hibernate.ogm.grid.RowKey;
import org.hibernate.ogm.grid.impl.RowKeyBuilder;
import org.hibernate.ogm.persister.OgmEntityPersister;
import org.hibernate.ogm.type.GridType;
import org.hibernate.ogm.util.impl.AssociationPersister;
import org.hibernate.ogm.util.impl.Log;
import org.hibernate.ogm.util.impl.LoggerFactory;
import org.hibernate.ogm.util.impl.LogicalPhysicalConverterHelper;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.tuple.entity.EntityMetamodel;
import org.hibernate.type.Type;

class EntityDehydrator {
    private static final Log log = LoggerFactory.make();
    private Tuple resultset;
    private Object[] fields;
    private boolean[] includeProperties;
    private boolean[][] includeColumns;
    private int tableIndex;
    private Serializable id;
    private SessionImplementor session;
    private GridType[] gridPropertyTypes;
    private OgmEntityPersister persister;
    private boolean addPropertyMetadata = true;
    private boolean dehydrate = true;
    private boolean removePropertyMetadata = true;
    private GridType gridIdentifierType;
    private GridDialect gridDialect;

    EntityDehydrator() {
    }

    public EntityDehydrator persister(OgmEntityPersister persister) {
        this.persister = persister;
        return this;
    }

    public EntityDehydrator gridPropertyTypes(GridType[] gridPropertyTypes) {
        this.gridPropertyTypes = gridPropertyTypes;
        return this;
    }

    public EntityDehydrator gridIdentifierType(GridType gridIdentifierType) {
        this.gridIdentifierType = gridIdentifierType;
        return this;
    }

    public EntityDehydrator resultset(Tuple resultset) {
        this.resultset = resultset;
        return this;
    }

    public EntityDehydrator fields(Object[] fields) {
        this.fields = fields;
        return this;
    }

    public EntityDehydrator includeProperties(boolean[] includeProperties) {
        this.includeProperties = includeProperties;
        return this;
    }

    public EntityDehydrator includeColumns(boolean[][] includeColumns) {
        this.includeColumns = includeColumns;
        return this;
    }

    public EntityDehydrator tableIndex(int tableIndex) {
        this.tableIndex = tableIndex;
        return this;
    }

    public EntityDehydrator id(Serializable id) {
        this.id = id;
        return this;
    }

    public EntityDehydrator session(SessionImplementor session) {
        this.session = session;
        return this;
    }

    public EntityDehydrator gridDialect(GridDialect gridDialect) {
        this.gridDialect = gridDialect;
        return this;
    }

    public EntityDehydrator onlyRemovePropertyMetadata() {
        this.addPropertyMetadata = false;
        this.dehydrate = false;
        this.removePropertyMetadata = true;
        return this;
    }

    public void dehydrate() {
        if (log.isTraceEnabled()) {
            log.trace("Dehydrating entity: " + MessageHelper.infoString((EntityPersister)this.persister, (Object)this.id, (SessionFactoryImplementor)this.persister.getFactory()));
        }
        EntityMetamodel entityMetamodel = this.persister.getEntityMetamodel();
        boolean[] uniqueness = this.persister.getPropertyUniqueness();
        Type[] propertyTypes = this.persister.getPropertyTypes();
        for (int propertyIndex = 0; propertyIndex < entityMetamodel.getPropertySpan(); ++propertyIndex) {
            Object[] newColumnValues;
            Object[] oldColumnValues;
            boolean createMetadata;
            if (!this.persister.isPropertyOfTable(propertyIndex, this.tableIndex)) continue;
            Type propertyType = propertyTypes[propertyIndex];
            boolean isStarToOne = propertyType.isAssociationType() && !propertyType.isCollectionType();
            boolean bl = createMetadata = isStarToOne || uniqueness[propertyIndex];
            if (this.removePropertyMetadata && createMetadata && !this.isEmptyOrAllColumnsNull(oldColumnValues = LogicalPhysicalConverterHelper.getColumnValuesFromResultset(this.resultset, this.persister.getPropertyColumnNames(propertyIndex)))) {
                this.doRemovePropertyMetadata(this.tableIndex, propertyIndex, oldColumnValues);
            }
            if (this.dehydrate && this.includeProperties[propertyIndex]) {
                this.gridPropertyTypes[propertyIndex].nullSafeSet(this.resultset, this.fields[propertyIndex], this.persister.getPropertyColumnNames(propertyIndex), this.includeColumns[propertyIndex], this.session);
            }
            if (!this.addPropertyMetadata || !createMetadata || this.isEmptyOrAllColumnsNull(newColumnValues = LogicalPhysicalConverterHelper.getColumnValuesFromResultset(this.resultset, this.persister.getPropertyColumnNames(propertyIndex)))) continue;
            this.doAddPropertyMetadata(this.tableIndex, propertyIndex, newColumnValues);
        }
    }

    private void doAddPropertyMetadata(int tableIndex, int propertyIndex, Object[] newColumnValue) {
        String[] propertyColumnNames = this.persister.getPropertyColumnNames(propertyIndex);
        String[] rowKeyColumnNames = EntityDehydrator.buildRowKeyColumnNamesForStarToOne(this.persister, propertyColumnNames);
        AssociationKeyMetadata associationKeyMetadata = new AssociationKeyMetadata(this.persister.getTableName(tableIndex), propertyColumnNames, rowKeyColumnNames);
        AssociationPersister associationPersister = new AssociationPersister(this.persister.getPropertyTypes()[propertyIndex].getReturnedClass()).hostingEntity(this.getReferencedEntity(propertyIndex)).gridDialect(this.gridDialect).associationKeyMetadata(associationKeyMetadata).keyColumnValues(newColumnValue).session(this.session).propertyType(this.persister.getPropertyTypes()[propertyIndex]);
        Tuple tuple = new Tuple();
        String[] identifierColumnNames = this.persister.getIdentifierColumnNames();
        this.gridIdentifierType.nullSafeSet(tuple, this.id, identifierColumnNames, this.session);
        this.gridPropertyTypes[propertyIndex].nullSafeSet(tuple, this.fields[propertyIndex], propertyColumnNames, this.includeColumns[propertyIndex], this.session);
        Object[] columnValues = LogicalPhysicalConverterHelper.getColumnValuesFromResultset(tuple, rowKeyColumnNames);
        RowKey rowKey = new RowKey(this.persister.getTableName(), rowKeyColumnNames, columnValues);
        Tuple assocEntryTuple = associationPersister.createAndPutAssociationTuple(rowKey);
        for (String column : tuple.getColumnNames()) {
            assocEntryTuple.put(column, tuple.get(column));
        }
        associationPersister.flushToCache();
    }

    public static String[] buildRowKeyColumnNamesForStarToOne(OgmEntityPersister persister, String[] keyColumnNames) {
        String[] identifierColumnNames = persister.getIdentifierColumnNames();
        int length = identifierColumnNames.length + keyColumnNames.length;
        String[] rowKeyColumnNames = new String[length];
        System.arraycopy(identifierColumnNames, 0, rowKeyColumnNames, 0, identifierColumnNames.length);
        System.arraycopy(keyColumnNames, 0, rowKeyColumnNames, identifierColumnNames.length, keyColumnNames.length);
        return rowKeyColumnNames;
    }

    private void doRemovePropertyMetadata(int tableIndex, int propertyIndex, Object[] oldColumnValue) {
        String[] propertyColumnNames = this.persister.getPropertyColumnNames(propertyIndex);
        String[] rowKeyColumnNames = EntityDehydrator.buildRowKeyColumnNamesForStarToOne(this.persister, propertyColumnNames);
        AssociationKeyMetadata associationKeyMetadata = new AssociationKeyMetadata(this.persister.getTableName(tableIndex), propertyColumnNames, rowKeyColumnNames);
        AssociationPersister associationPersister = new AssociationPersister(this.persister.getPropertyTypes()[propertyIndex].getReturnedClass()).hostingEntity(this.getReferencedEntity(propertyIndex)).gridDialect(this.gridDialect).associationKeyMetadata(associationKeyMetadata).keyColumnValues(oldColumnValue).session(this.session).propertyType(this.persister.getPropertyTypes()[propertyIndex]);
        Tuple tupleKey = new Tuple();
        for (int index = 0; index < propertyColumnNames.length; ++index) {
            tupleKey.put(propertyColumnNames[index], oldColumnValue[index]);
        }
        this.gridIdentifierType.nullSafeSet(tupleKey, this.id, this.persister.getIdentifierColumnNames(), this.session);
        Association propertyValues = associationPersister.getAssociation();
        if (propertyValues != null) {
            RowKey matchingTuple = new RowKeyBuilder().tableName(this.persister.getTableName()).addColumns(EntityDehydrator.buildRowKeyColumnNamesForStarToOne(this.persister, propertyColumnNames)).values(tupleKey).build();
            associationPersister.getAssociation().remove(matchingTuple);
            associationPersister.flushToCache();
        }
    }

    private Object getReferencedEntity(int propertyIndex) {
        GridType propertyType = this.gridPropertyTypes[propertyIndex];
        Serializable id = (Serializable)propertyType.hydrate(this.resultset, this.persister.getPropertyColumnNames(propertyIndex), this.session, null);
        if (id != null) {
            EntityPersister hostingEntityPersister = this.session.getFactory().getEntityPersister(propertyType.getReturnedClass().getName());
            return this.session.getPersistenceContext().getEntity(this.session.generateEntityKey(id, hostingEntityPersister));
        }
        return null;
    }

    private boolean isEmptyOrAllColumnsNull(Object[] objects) {
        for (Object object : objects) {
            if (object == null) continue;
            return false;
        }
        return true;
    }
}

