/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.query.impl;

import org.hibernate.engine.query.spi.ParameterMetadata;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.collections.BoundedConcurrentHashMap;
import org.hibernate.ogm.dialect.GridDialect;
import org.hibernate.ogm.query.spi.ParameterMetadataBuilder;
import org.hibernate.ogm.util.configurationreader.impl.ConfigurationPropertyReader;

public class NoSqlQueryParameterMetadataCache {
    private final BoundedConcurrentHashMap<String, ParameterMetadata> parameterMetadataCache;
    private final SessionFactoryImplementor sessionFactory;
    private final ParameterMetadataBuilder parameterMetadataBuilder;

    public NoSqlQueryParameterMetadataCache(SessionFactoryImplementor factory) {
        this.sessionFactory = factory;
        Integer maxParameterMetadataCount = new ConfigurationPropertyReader(factory.getProperties()).property("hibernate.query.plan_parameter_metadata_max_size", Integer.TYPE).withDefault(128).getValue();
        this.parameterMetadataCache = new BoundedConcurrentHashMap(maxParameterMetadataCount.intValue(), 20, BoundedConcurrentHashMap.Eviction.LIRS);
        this.parameterMetadataBuilder = ((GridDialect)this.sessionFactory.getServiceRegistry().getService(GridDialect.class)).getParameterMetadataBuilder();
    }

    public ParameterMetadata getParameterMetadata(String noSqlQuery) {
        ParameterMetadata cached;
        ParameterMetadata metadata = (ParameterMetadata)this.parameterMetadataCache.get((Object)noSqlQuery);
        if (metadata == null && (cached = (ParameterMetadata)this.parameterMetadataCache.putIfAbsent((Object)noSqlQuery, (Object)(metadata = this.parameterMetadataBuilder.buildParameterMetadata(noSqlQuery)))) != null) {
            metadata = cached;
        }
        return metadata;
    }
}

