/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.service.impl;

import org.hibernate.SessionFactoryObserver;
import org.hibernate.boot.registry.StandardServiceInitiator;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.cfg.Configuration;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.event.service.spi.DuplicationStrategy;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.EventType;
import org.hibernate.integrator.spi.Integrator;
import org.hibernate.integrator.spi.ServiceContributingIntegrator;
import org.hibernate.metamodel.source.MetadataImplementor;
import org.hibernate.ogm.cfg.impl.Version;
import org.hibernate.ogm.datastore.impl.DatastoreProviderInitiator;
import org.hibernate.ogm.dialect.BatchOperationsDelegator;
import org.hibernate.ogm.dialect.GridDialect;
import org.hibernate.ogm.dialect.GridDialectLogger;
import org.hibernate.ogm.dialect.impl.GridDialectInitiator;
import org.hibernate.ogm.dialect.impl.OgmDialectFactoryInitiator;
import org.hibernate.ogm.jdbc.OgmConnectionProviderInitiator;
import org.hibernate.ogm.jpa.impl.OgmPersisterClassResolverInitiator;
import org.hibernate.ogm.options.navigation.impl.OptionsServiceInitiator;
import org.hibernate.ogm.service.impl.AutoFlushBatchManagerEventListener;
import org.hibernate.ogm.service.impl.ConfigurationService;
import org.hibernate.ogm.service.impl.ConfigurationServiceInitiator;
import org.hibernate.ogm.service.impl.FlushBatchManagerEventListener;
import org.hibernate.ogm.service.impl.OgmJdbcServicesInitiator;
import org.hibernate.ogm.service.impl.OgmSessionFactoryServiceRegistryFactoryInitiator;
import org.hibernate.ogm.service.impl.SchemaInitializingObserver;
import org.hibernate.ogm.transaction.impl.OgmJtaPlatformInitiator;
import org.hibernate.ogm.transaction.impl.OgmTransactionFactoryInitiator;
import org.hibernate.ogm.type.impl.TypeTranslatorInitiator;
import org.hibernate.service.spi.SessionFactoryServiceRegistry;

public class OgmIntegrator
implements Integrator,
ServiceContributingIntegrator {
    public void integrate(Configuration configuration, SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
        this.doIntegrate(configuration, sessionFactory, serviceRegistry);
    }

    public void integrate(MetadataImplementor metadata, SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
        this.doIntegrate(null, sessionFactory, serviceRegistry);
    }

    private void doIntegrate(Configuration configuration, SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
        if (!((ConfigurationService)serviceRegistry.getService(ConfigurationService.class)).isOgmOn()) {
            return;
        }
        Version.touch();
        sessionFactory.addObserver((SessionFactoryObserver)new SchemaInitializingObserver(configuration));
        this.attachBatchListenersIfRequired(serviceRegistry);
    }

    private void attachBatchListenersIfRequired(SessionFactoryServiceRegistry serviceRegistry) {
        GridDialect gridDialect = (GridDialect)serviceRegistry.getService(GridDialect.class);
        BatchOperationsDelegator batchDelegator = this.asBatchDelegatorOrNull(gridDialect);
        if (batchDelegator != null) {
            EventListenerRegistry eventListenerRegistry = (EventListenerRegistry)serviceRegistry.getService(EventListenerRegistry.class);
            this.addListeners(eventListenerRegistry, batchDelegator);
        }
    }

    public void disintegrate(SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
    }

    public void prepareServices(StandardServiceRegistryBuilder serviceRegistryBuilder) {
        serviceRegistryBuilder.addInitiator((StandardServiceInitiator)OgmSessionFactoryServiceRegistryFactoryInitiator.INSTANCE);
        serviceRegistryBuilder.addInitiator((StandardServiceInitiator)ConfigurationServiceInitiator.INSTANCE);
        serviceRegistryBuilder.addInitiator((StandardServiceInitiator)OgmPersisterClassResolverInitiator.INSTANCE);
        serviceRegistryBuilder.addInitiator((StandardServiceInitiator)OgmConnectionProviderInitiator.INSTANCE);
        serviceRegistryBuilder.addInitiator((StandardServiceInitiator)OgmDialectFactoryInitiator.INSTANCE);
        serviceRegistryBuilder.addInitiator((StandardServiceInitiator)OgmTransactionFactoryInitiator.INSTANCE);
        serviceRegistryBuilder.addInitiator((StandardServiceInitiator)OgmJtaPlatformInitiator.INSTANCE);
        serviceRegistryBuilder.addInitiator((StandardServiceInitiator)OgmJdbcServicesInitiator.INSTANCE);
        serviceRegistryBuilder.addInitiator((StandardServiceInitiator)DatastoreProviderInitiator.INSTANCE);
        serviceRegistryBuilder.addInitiator((StandardServiceInitiator)OptionsServiceInitiator.INSTANCE);
        serviceRegistryBuilder.addInitiator((StandardServiceInitiator)TypeTranslatorInitiator.INSTANCE);
        serviceRegistryBuilder.addInitiator((StandardServiceInitiator)GridDialectInitiator.INSTANCE);
    }

    private BatchOperationsDelegator asBatchDelegatorOrNull(GridDialect gridDialect) {
        if (gridDialect instanceof GridDialectLogger) {
            gridDialect = ((GridDialectLogger)gridDialect).getGridDialect();
        }
        return (BatchOperationsDelegator)(gridDialect instanceof BatchOperationsDelegator ? gridDialect : null);
    }

    private void addListeners(EventListenerRegistry eventListenerRegistry, BatchOperationsDelegator gridDialect) {
        eventListenerRegistry.addDuplicationStrategy((DuplicationStrategy)new FlushBatchManagerEventListener.FlushDuplicationStrategy());
        eventListenerRegistry.addDuplicationStrategy((DuplicationStrategy)new AutoFlushBatchManagerEventListener.AutoFlushDuplicationStrategy());
        eventListenerRegistry.getEventListenerGroup(EventType.FLUSH).appendListener((Object)new FlushBatchManagerEventListener(gridDialect));
        eventListenerRegistry.getEventListenerGroup(EventType.AUTO_FLUSH).appendListener((Object)new AutoFlushBatchManagerEventListener(gridDialect));
    }
}

