/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.type.descriptor;

import java.util.Calendar;
import javax.xml.bind.DatatypeConverter;
import org.hibernate.type.descriptor.java.CalendarDateTypeDescriptor;

public class Iso8601CalendarTypeDescriptor
extends CalendarDateTypeDescriptor {
    public static final Iso8601CalendarTypeDescriptor DATE = new Iso8601CalendarTypeDescriptor(Type.DATE);
    public static final Iso8601CalendarTypeDescriptor TIME = new Iso8601CalendarTypeDescriptor(Type.TIME);
    public static final Iso8601CalendarTypeDescriptor DATE_TIME = new Iso8601CalendarTypeDescriptor(Type.DATE_TIME);
    private final Type type;

    private Iso8601CalendarTypeDescriptor(Type type) {
        this.type = type;
    }

    public Calendar fromString(String string) {
        return this.type.fromString(string);
    }

    public String toString(Calendar value) {
        return this.type.toString(value);
    }

    public boolean areEqual(Calendar one, Calendar another) {
        if (one == another) {
            return true;
        }
        if (one == null || another == null) {
            return false;
        }
        return one.getTimeZone().getRawOffset() == another.getTimeZone().getRawOffset() && one.getTime() == another.getTime();
    }

    private static enum Type {
        DATE{

            @Override
            public Calendar fromString(String string) {
                return DatatypeConverter.parseDate((String)string);
            }

            @Override
            public String toString(Calendar value) {
                return DatatypeConverter.printDate((Calendar)value);
            }
        }
        ,
        TIME{

            @Override
            public Calendar fromString(String string) {
                return DatatypeConverter.parseTime((String)string);
            }

            @Override
            public String toString(Calendar value) {
                return DatatypeConverter.printTime((Calendar)value);
            }
        }
        ,
        DATE_TIME{

            @Override
            public Calendar fromString(String string) {
                return DatatypeConverter.parseDateTime((String)string);
            }

            @Override
            public String toString(Calendar value) {
                return DatatypeConverter.printDateTime((Calendar)value);
            }
        };


        public abstract Calendar fromString(String var1);

        public abstract String toString(Calendar var1);
    }
}

