/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j.dialect.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.internal.util.collections.BoundedConcurrentHashMap;
import org.hibernate.ogm.datastore.neo4j.dialect.impl.NodeLabel;
import org.hibernate.ogm.grid.IdSourceKey;
import org.hibernate.ogm.grid.IdSourceKeyMetadata;
import org.hibernate.ogm.id.impl.OgmSequenceGenerator;
import org.hibernate.ogm.id.impl.OgmTableGenerator;
import org.hibernate.ogm.id.spi.PersistentNoSqlIdentifierGenerator;
import org.neo4j.cypher.javacompat.ExecutionEngine;
import org.neo4j.cypher.javacompat.ExecutionResult;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Lock;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.ConstraintType;

public class Neo4jSequenceGenerator {
    private static final String INITIAL_VALUE_QUERY_PARAM = "initialValue";
    private static final String SEQUENCE_NAME_QUERY_PARAM = "sequenceName";
    private static final String SEQUENCE_NAME_PROPERTY = "sequence_name";
    private static final String SEQUENCE_VALUE_PROPERTY = "next_val";
    private static final String SEQUENCE_CREATION_QUERY = "MERGE (n:" + NodeLabel.SEQUENCE.name() + " {" + "sequence_name" + ": {sequenceName}} ) ON CREATE SET n." + "next_val" + " = {initialValue} RETURN n";
    private static final String SEQUENCE_VALUE_QUERY = "MATCH (n:" + NodeLabel.SEQUENCE.name() + ") WHERE n." + "sequence_name" + " = {sequenceName} RETURN n";
    private final BoundedConcurrentHashMap<String, String> queryCache;
    private final GraphDatabaseService neo4jDb;
    private final ExecutionEngine engine;

    public Neo4jSequenceGenerator(GraphDatabaseService neo4jDb, int sequenceCacheMaxSize) {
        this.neo4jDb = neo4jDb;
        this.engine = new ExecutionEngine(neo4jDb);
        this.queryCache = new BoundedConcurrentHashMap(sequenceCacheMaxSize, 20, BoundedConcurrentHashMap.Eviction.LIRS);
    }

    public void createSequences(Set<PersistentNoSqlIdentifierGenerator> identifierGenerators) {
        this.addUniqueConstraints(identifierGenerators);
        this.addSequences(identifierGenerators);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addUniqueConstraints(Set<PersistentNoSqlIdentifierGenerator> identifierGenerators) {
        Transaction tx = null;
        try {
            tx = this.neo4jDb.beginTx();
            for (IdentifierGenerator identifierGenerator : identifierGenerators) {
                this.addUniqueConstraint(identifierGenerator);
            }
            tx.success();
        }
        finally {
            tx.close();
        }
    }

    private void addUniqueConstraint(IdentifierGenerator identifierGenerator) {
        if (identifierGenerator instanceof OgmSequenceGenerator) {
            this.addUniqueConstraintForSequence(((OgmSequenceGenerator)identifierGenerator).getGeneratorKeyMetadata());
        } else if (identifierGenerator instanceof OgmTableGenerator) {
            this.addUniqueConstraintForTableBasedSequence(((OgmTableGenerator)identifierGenerator).getGeneratorKeyMetadata());
        }
    }

    private void addUniqueConstraintForSequence(IdSourceKeyMetadata idSourceKeyMetadata) {
        if (this.isMissingUniqueConstraint(NodeLabel.SEQUENCE)) {
            this.neo4jDb.schema().constraintFor((Label)NodeLabel.SEQUENCE).assertPropertyIsUnique(SEQUENCE_NAME_PROPERTY).create();
        }
    }

    private void addUniqueConstraintForTableBasedSequence(IdSourceKeyMetadata generatorKeyMetadata) {
        Label generatorKeyLabel = DynamicLabel.label((String)generatorKeyMetadata.getName());
        if (this.isMissingUniqueConstraint(generatorKeyLabel)) {
            this.neo4jDb.schema().constraintFor(generatorKeyLabel).assertPropertyIsUnique(generatorKeyMetadata.getKeyColumnName()).create();
        }
    }

    private boolean isMissingUniqueConstraint(Label generatorKeyLabel) {
        Iterable constraints = this.neo4jDb.schema().getConstraints(generatorKeyLabel);
        for (ConstraintDefinition constraint : constraints) {
            if (!constraint.isConstraintType(ConstraintType.UNIQUENESS)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSequences(Set<PersistentNoSqlIdentifierGenerator> identifierGenerators) {
        Transaction tx = null;
        try {
            tx = this.neo4jDb.beginTx();
            for (IdentifierGenerator identifierGenerator : identifierGenerators) {
                this.addSequence(identifierGenerator);
            }
            tx.success();
        }
        finally {
            tx.close();
        }
    }

    private void addSequence(IdentifierGenerator identifierGenerator) {
        if (identifierGenerator instanceof OgmSequenceGenerator) {
            OgmSequenceGenerator sequenceGenerator = (OgmSequenceGenerator)identifierGenerator;
            this.addSequence(sequenceGenerator.getGeneratorKeyMetadata(), sequenceGenerator.getInitialValue());
        } else if (identifierGenerator instanceof OgmTableGenerator) {
            OgmTableGenerator sequenceGenerator = (OgmTableGenerator)identifierGenerator;
            this.addTableSequence(sequenceGenerator.getGeneratorKeyMetadata(), sequenceGenerator.getSegmentValue(), sequenceGenerator.getInitialValue());
        }
    }

    private void addTableSequence(IdSourceKeyMetadata idSourceKeyMetadata, String sequenceName, int initialValue) {
        Label generatorKeyLabel = DynamicLabel.label((String)idSourceKeyMetadata.getName());
        String query = "MERGE (n" + this.labels(generatorKeyLabel.name(), NodeLabel.TABLE_BASED_SEQUENCE.name()) + " { " + idSourceKeyMetadata.getKeyColumnName() + ": {" + SEQUENCE_NAME_QUERY_PARAM + "}} ) ON CREATE SET n." + idSourceKeyMetadata.getValueColumnName() + " = {" + INITIAL_VALUE_QUERY_PARAM + "} RETURN n";
        this.engine.execute(query, this.params(sequenceName, initialValue));
    }

    private void addSequence(IdSourceKeyMetadata idSourceKeyMetadata, int initialValue) {
        this.engine.execute(SEQUENCE_CREATION_QUERY, this.params(idSourceKeyMetadata.getName(), initialValue));
    }

    private Map<String, Object> params(String sequenceName, int initialValue) {
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put(INITIAL_VALUE_QUERY_PARAM, initialValue);
        params.put(SEQUENCE_NAME_QUERY_PARAM, sequenceName);
        return params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int nextValue(IdSourceKey idSourceKey, int increment) {
        Transaction tx = this.neo4jDb.beginTx();
        Lock lock = null;
        try {
            Node sequence = this.getSequence(idSourceKey);
            lock = tx.acquireWriteLock((PropertyContainer)sequence);
            int nextValue = this.updateSequenceValue(idSourceKey, sequence, increment);
            tx.success();
            lock.release();
            int n = nextValue;
            return n;
        }
        finally {
            tx.close();
        }
    }

    private Node getSequence(IdSourceKey idSourceKey) {
        String updateSequenceQuery = this.getQuery(idSourceKey);
        ExecutionResult result = this.engine.execute(updateSequenceQuery, Collections.singletonMap(SEQUENCE_NAME_QUERY_PARAM, this.sequenceName(idSourceKey)));
        ResourceIterator column = result.columnAs("n");
        Node node = null;
        if (column.hasNext()) {
            node = (Node)column.next();
        }
        column.close();
        return node;
    }

    private String getQuery(IdSourceKey idSourceKey) {
        return idSourceKey.getMetadata().getType() == IdSourceKeyMetadata.IdSourceType.TABLE ? this.getTableQuery(idSourceKey) : SEQUENCE_VALUE_QUERY;
    }

    private String getTableQuery(IdSourceKey idSourceKey) {
        String query = (String)this.queryCache.get((Object)idSourceKey.getTable());
        if (query == null) {
            query = "MATCH (n" + this.labels(idSourceKey.getTable(), NodeLabel.TABLE_BASED_SEQUENCE.name()) + ") WHERE n." + idSourceKey.getMetadata().getKeyColumnName() + " = {" + SEQUENCE_NAME_QUERY_PARAM + "} RETURN n";
            String cached = (String)this.queryCache.putIfAbsent((Object)idSourceKey.getTable(), (Object)query);
            if (cached != null) {
                query = cached;
            }
        }
        return query;
    }

    private String labels(String ... labels) {
        StringBuilder builder = new StringBuilder();
        for (String label : labels) {
            builder.append(":`");
            builder.append(label);
            builder.append("`");
        }
        return builder.toString();
    }

    private String sequenceName(IdSourceKey key) {
        return key.getMetadata().getType() == IdSourceKeyMetadata.IdSourceType.SEQUENCE ? key.getMetadata().getName() : (String)key.getColumnValues()[0];
    }

    private int updateSequenceValue(IdSourceKey idSourceKey, Node sequence, int increment) {
        String valueProperty = idSourceKey.getMetadata().getType() == IdSourceKeyMetadata.IdSourceType.TABLE ? idSourceKey.getMetadata().getValueColumnName() : SEQUENCE_VALUE_PROPERTY;
        int currentValue = (Integer)sequence.getProperty(valueProperty);
        int updatedValue = currentValue + increment;
        sequence.setProperty(valueProperty, (Object)updatedValue);
        return currentValue;
    }
}

