/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j.dialect.impl;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.ogm.type.GridType;
import org.hibernate.ogm.type.StringCalendarDateType;
import org.hibernate.ogm.type.StringDateTypeDescriptor;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;

public class Neo4jTypeConverter {
    public static final Neo4jTypeConverter INSTANCE = new Neo4jTypeConverter();
    private static final Map<Type, GridType> conversionMap = Neo4jTypeConverter.createGridTypeConversionMap();

    private static Map<Type, GridType> createGridTypeConversionMap() {
        HashMap<Type, GridType> conversion = new HashMap<Type, GridType>();
        conversion.put((Type)StandardBasicTypes.CALENDAR, (GridType)StringCalendarDateType.INSTANCE);
        conversion.put((Type)StandardBasicTypes.CALENDAR_DATE, (GridType)StringCalendarDateType.INSTANCE);
        conversion.put((Type)StandardBasicTypes.DATE, (GridType)StringDateTypeDescriptor.INSTANCE);
        conversion.put((Type)StandardBasicTypes.TIME, (GridType)StringDateTypeDescriptor.INSTANCE);
        conversion.put((Type)StandardBasicTypes.TIMESTAMP, (GridType)StringDateTypeDescriptor.INSTANCE);
        return conversion;
    }

    public GridType convert(Type type) {
        return conversionMap.get(type);
    }
}

