/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j.query.parsing.impl;

import java.util.Map;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.engine.query.spi.ParameterMetadata;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.hql.QueryParser;
import org.hibernate.hql.ast.spi.AstProcessingChain;
import org.hibernate.hql.ast.spi.EntityNamesResolver;
import org.hibernate.ogm.OgmSession;
import org.hibernate.ogm.datastore.neo4j.query.parsing.impl.Neo4jProcessingChain;
import org.hibernate.ogm.datastore.neo4j.query.parsing.impl.Neo4jQueryParsingResult;
import org.hibernate.ogm.query.NoSQLQuery;
import org.hibernate.ogm.query.impl.NoSQLQueryImpl;
import org.hibernate.ogm.service.impl.BaseQueryParserService;
import org.hibernate.ogm.service.impl.SessionFactoryEntityNamesResolver;
import org.hibernate.ogm.util.impl.Log;
import org.hibernate.ogm.util.impl.LoggerFactory;

public class Neo4jBasedQueryParserService
extends BaseQueryParserService {
    private static final Log log = LoggerFactory.make();
    private volatile SessionFactoryEntityNamesResolver entityNamesResolver;

    public Query getParsedQueryExecutor(OgmSession session, String queryString, Map<String, Object> namedParameters) {
        QueryParser queryParser = new QueryParser();
        Neo4jProcessingChain processingChain = this.createProcessingChain((Session)session, this.unwrap(namedParameters));
        Neo4jQueryParsingResult result = (Neo4jQueryParsingResult)queryParser.parseQuery(queryString, (AstProcessingChain)processingChain);
        log.createdQuery(queryString, (Object)result);
        NoSQLQuery query = this.nosqlQuery(session, result);
        return query;
    }

    private NoSQLQuery nosqlQuery(OgmSession session, Neo4jQueryParsingResult result) {
        NoSQLQueryImpl query = new NoSQLQueryImpl(result.getQuery(), (SessionImplementor)session, new ParameterMetadata(null, null));
        if (this.hasProjections(result)) {
            for (String field : result.getProjections()) {
                query.addScalar(field);
            }
        } else {
            query.addEntity(result.getEntityType());
        }
        return query;
    }

    private boolean hasProjections(Neo4jQueryParsingResult result) {
        return result.getProjections() != null && !result.getProjections().isEmpty();
    }

    private Neo4jProcessingChain createProcessingChain(Session session, Map<String, Object> namedParameters) {
        EntityNamesResolver entityNamesResolver = this.getDefinedEntityNames(session.getSessionFactory());
        return new Neo4jProcessingChain((SessionFactoryImplementor)session.getSessionFactory(), entityNamesResolver, namedParameters);
    }

    private EntityNamesResolver getDefinedEntityNames(SessionFactory sessionFactory) {
        if (this.entityNamesResolver == null) {
            this.entityNamesResolver = new SessionFactoryEntityNamesResolver(sessionFactory);
        }
        return this.entityNamesResolver;
    }
}

