/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.ehcache.dialect.impl;

import java.io.Serializable;
import java.util.Arrays;
import org.hibernate.ogm.grid.AssociationKey;
import org.hibernate.ogm.grid.EntityKey;
import org.hibernate.ogm.grid.IdSourceKey;
import org.hibernate.ogm.grid.Key;
import org.hibernate.ogm.grid.RowKey;

public class SerializableKey
implements Serializable {
    private static final int ENTITY_KEY = 1;
    private static final int ASSOCIATION_KEY = 2;
    private static final int ROW_KEY = 3;
    private static final int ID_GENERATOR_KEY = 4;
    private final String table;
    private final String[] columnNames;
    private final Object[] columnValues;
    private final int type;

    public SerializableKey(Key key) {
        this.table = key.getTable();
        this.columnNames = key.getColumnNames();
        this.columnValues = key.getColumnValues();
        if (key instanceof EntityKey) {
            this.type = 1;
        } else if (key instanceof AssociationKey) {
            this.type = 2;
        } else if (key instanceof RowKey) {
            this.type = 3;
        } else if (key instanceof IdSourceKey) {
            this.type = 4;
        } else {
            throw new IllegalArgumentException("Unsupported key type: " + key);
        }
    }

    public String getTable() {
        return this.table;
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public Object[] getColumnValues() {
        return this.columnValues;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.columnNames);
        result = 31 * result + Arrays.hashCode(this.columnValues);
        result = 31 * result + (this.table == null ? 0 : this.table.hashCode());
        result = 31 * result + this.type;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SerializableKey other = (SerializableKey)obj;
        if (!Arrays.equals(this.columnNames, other.columnNames)) {
            return false;
        }
        if (!Arrays.equals(this.columnValues, other.columnValues)) {
            return false;
        }
        if (this.table == null ? other.table != null : !this.table.equals(other.table)) {
            return false;
        }
        return this.type == other.type;
    }

    public String toString() {
        return "SerializableKey [table=" + this.table + ", columnNames=" + Arrays.toString(this.columnNames) + ", columnValues=" + Arrays.toString(this.columnValues) + ", type=" + this.type + "]";
    }
}

