/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.mongodb.dialect.impl;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.Set;
import org.hibernate.ogm.datastore.document.association.spi.AssociationRow;
import org.hibernate.ogm.datastore.document.association.spi.SingleColumnAwareAssociationRowFactory;

public class MongoDBAssociationRowFactory
extends SingleColumnAwareAssociationRowFactory<DBObject> {
    public static final MongoDBAssociationRowFactory INSTANCE = new MongoDBAssociationRowFactory();

    private MongoDBAssociationRowFactory() {
        super(DBObject.class);
    }

    protected DBObject getSingleColumnRow(String columnName, Object value) {
        return new BasicDBObject(columnName, value);
    }

    protected AssociationRow.AssociationRowAccessor<DBObject> getAssociationRowAccessor() {
        return MongoDBAssociationRowAccessor.INSTANCE;
    }

    private static class MongoDBAssociationRowAccessor
    implements AssociationRow.AssociationRowAccessor<DBObject> {
        private static final MongoDBAssociationRowAccessor INSTANCE = new MongoDBAssociationRowAccessor();

        private MongoDBAssociationRowAccessor() {
        }

        public Set<String> getColumnNames(DBObject row) {
            return row.keySet();
        }

        public Object get(DBObject row, String column) {
            return row.get(column);
        }
    }
}

