/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.hibernate.AssertionFailure;
import org.hibernate.LockMode;
import org.hibernate.dialect.lock.LockingStrategy;
import org.hibernate.engine.spi.QueryParameters;
import org.hibernate.engine.spi.TypedValue;
import org.hibernate.ogm.datastore.neo4j.dialect.impl.CypherCRUD;
import org.hibernate.ogm.datastore.neo4j.dialect.impl.MapsTupleIterator;
import org.hibernate.ogm.datastore.neo4j.dialect.impl.Neo4jAssociationSnapshot;
import org.hibernate.ogm.datastore.neo4j.dialect.impl.Neo4jSequenceGenerator;
import org.hibernate.ogm.datastore.neo4j.dialect.impl.Neo4jTupleAssociationSnapshot;
import org.hibernate.ogm.datastore.neo4j.dialect.impl.Neo4jTupleSnapshot;
import org.hibernate.ogm.datastore.neo4j.dialect.impl.Neo4jTypeConverter;
import org.hibernate.ogm.datastore.neo4j.dialect.impl.NodeLabel;
import org.hibernate.ogm.datastore.neo4j.dialect.impl.NodesTupleIterator;
import org.hibernate.ogm.datastore.neo4j.impl.Neo4jDatastoreProvider;
import org.hibernate.ogm.datastore.neo4j.logging.impl.GraphLogger;
import org.hibernate.ogm.datastore.neo4j.query.impl.Neo4jParameterMetadataBuilder;
import org.hibernate.ogm.datastore.neo4j.query.parsing.cypherdsl.impl.CypherDSL;
import org.hibernate.ogm.datastore.spi.Association;
import org.hibernate.ogm.datastore.spi.AssociationContext;
import org.hibernate.ogm.datastore.spi.AssociationOperation;
import org.hibernate.ogm.datastore.spi.AssociationSnapshot;
import org.hibernate.ogm.datastore.spi.Tuple;
import org.hibernate.ogm.datastore.spi.TupleContext;
import org.hibernate.ogm.datastore.spi.TupleOperation;
import org.hibernate.ogm.datastore.spi.TupleSnapshot;
import org.hibernate.ogm.dialect.spi.BaseGridDialect;
import org.hibernate.ogm.dialect.spi.QueryableGridDialect;
import org.hibernate.ogm.grid.AssociationKey;
import org.hibernate.ogm.grid.AssociationKind;
import org.hibernate.ogm.grid.EntityKey;
import org.hibernate.ogm.grid.EntityKeyMetadata;
import org.hibernate.ogm.grid.Key;
import org.hibernate.ogm.grid.RowKey;
import org.hibernate.ogm.id.spi.NextValueRequest;
import org.hibernate.ogm.massindex.batchindexing.Consumer;
import org.hibernate.ogm.query.spi.BackendQuery;
import org.hibernate.ogm.query.spi.ParameterMetadataBuilder;
import org.hibernate.ogm.type.GridType;
import org.hibernate.ogm.type.TypeTranslator;
import org.hibernate.ogm.util.ClosableIterator;
import org.hibernate.persister.entity.Lockable;
import org.hibernate.service.spi.ServiceRegistryAwareService;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.type.Type;
import org.neo4j.cypher.javacompat.ExecutionResult;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.ResourceIterator;

public class Neo4jDialect
extends BaseGridDialect
implements QueryableGridDialect<String>,
ServiceRegistryAwareService {
    private final CypherCRUD neo4jCRUD;
    private final Neo4jSequenceGenerator neo4jSequenceGenerator;
    private ServiceRegistryImplementor serviceRegistry;

    public Neo4jDialect(Neo4jDatastoreProvider provider) {
        this.neo4jCRUD = new CypherCRUD(provider.getDataBase());
        this.neo4jSequenceGenerator = provider.getSequenceGenerator();
    }

    public void injectServices(ServiceRegistryImplementor serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    public LockingStrategy getLockingStrategy(Lockable lockable, LockMode lockMode) {
        throw new UnsupportedOperationException("LockMode " + lockMode + " is not supported by the Neo4j GridDialect");
    }

    public Tuple getTuple(EntityKey key, TupleContext context) {
        Node entityNode = this.neo4jCRUD.findNode((Key)key, NodeLabel.ENTITY);
        if (entityNode == null) {
            return null;
        }
        return Neo4jDialect.createTuple(entityNode);
    }

    public Tuple createTuple(EntityKey key, TupleContext tupleContext) {
        Node node = this.neo4jCRUD.createNodeUnlessExists((Key)key, NodeLabel.ENTITY);
        GraphLogger.log("Created node: %1$s", node);
        return Neo4jDialect.createTuple(node);
    }

    private static Tuple createTuple(Node entityNode) {
        return new Tuple((TupleSnapshot)new Neo4jTupleSnapshot(entityNode));
    }

    public void updateTuple(Tuple tuple, EntityKey key, TupleContext tupleContext) {
        Neo4jTupleSnapshot snapshot = (Neo4jTupleSnapshot)tuple.getSnapshot();
        Node node = snapshot.getNode();
        this.applyTupleOperations((PropertyContainer)node, tuple.getOperations());
        GraphLogger.log("Updated node: %1$s", node);
    }

    public void removeTuple(EntityKey key, TupleContext tupleContext) {
        this.neo4jCRUD.remove(key);
    }

    public Tuple createTupleAssociation(AssociationKey associationKey, RowKey rowKey) {
        Relationship relationship = this.createRelationship(associationKey, rowKey);
        GraphLogger.log("Relationship: %1$s", relationship);
        if (relationship == null) {
            return new Tuple();
        }
        return new Tuple((TupleSnapshot)new Neo4jTupleAssociationSnapshot(relationship, associationKey));
    }

    private Relationship createRelationship(AssociationKey associationKey, RowKey rowKey) {
        switch (associationKey.getAssociationKind()) {
            case EMBEDDED_COLLECTION: {
                return this.createRelationshipWithEmbeddedNode(associationKey, rowKey);
            }
            case ASSOCIATION: {
                return this.findOrCreateRelationshipWithEntityNode(associationKey, rowKey);
            }
        }
        throw new AssertionFailure("Unrecognized associationKind: " + associationKey.getAssociationKind());
    }

    private Relationship createRelationshipWithEmbeddedNode(AssociationKey associationKey, RowKey rowKey) {
        Node embeddedNode = this.neo4jCRUD.createNode((Key)rowKey.getEntityKey(), NodeLabel.EMBEDDED);
        Relationship relationship = this.createRelationshipWithTargetNode(associationKey, rowKey, embeddedNode);
        this.applyProperties(associationKey, rowKey, relationship);
        return relationship;
    }

    private Relationship findOrCreateRelationshipWithEntityNode(AssociationKey associationKey, RowKey rowKey) {
        EntityKey targetKey = rowKey.getEntityKey();
        if (targetKey == null) {
            return null;
        }
        Relationship relationship = this.neo4jCRUD.findRelationship(associationKey, rowKey);
        if (relationship != null) {
            return relationship;
        }
        Node targetNode = this.neo4jCRUD.findNode((Key)targetKey, NodeLabel.ENTITY);
        return this.createRelationshipWithTargetNode(associationKey, rowKey, targetNode);
    }

    private void applyProperties(AssociationKey associationKey, RowKey rowKey, Relationship relationship) {
        String[] indexColumns = associationKey.getMetadata().getRowKeyIndexColumnNames();
        for (int i = 0; i < indexColumns.length; ++i) {
            String propertyName = indexColumns[i];
            Object propertyValue = rowKey.getColumnValue(propertyName);
            relationship.setProperty(propertyName, propertyValue);
        }
    }

    private Relationship createRelationshipWithTargetNode(AssociationKey associationKey, RowKey rowKey, Node targetNode) {
        Node ownerNode = this.neo4jCRUD.findNode((Key)associationKey.getEntityKey(), NodeLabel.ENTITY);
        Relationship relationship = ownerNode.createRelationshipTo(targetNode, CypherCRUD.relationshipType(associationKey));
        this.applyProperties(associationKey, rowKey, relationship);
        return relationship;
    }

    public Association getAssociation(AssociationKey associationKey, AssociationContext associationContext) {
        Node entityNode = this.neo4jCRUD.findNode((Key)associationKey.getEntityKey(), NodeLabel.ENTITY);
        GraphLogger.log("Found owner node: %1$s", entityNode);
        if (entityNode == null) {
            return null;
        }
        return new Association((AssociationSnapshot)new Neo4jAssociationSnapshot(entityNode, associationKey));
    }

    public Association createAssociation(AssociationKey associationKey, AssociationContext associationContext) {
        return new Association();
    }

    public void updateAssociation(Association association, AssociationKey key, AssociationContext associationContext) {
        for (AssociationOperation action : association.getOperations()) {
            this.applyAssociationOperation(key, action, associationContext);
        }
    }

    public boolean isStoredInEntityStructure(AssociationKey associationKey, AssociationContext associationContext) {
        return false;
    }

    public Number nextValue(NextValueRequest request) {
        return this.neo4jSequenceGenerator.nextValue(request.getKey(), request.getIncrement());
    }

    public boolean supportsSequences() {
        return true;
    }

    public GridType overrideType(Type type) {
        return Neo4jTypeConverter.INSTANCE.convert(type);
    }

    public void removeAssociation(AssociationKey key, AssociationContext associationContext) {
        if (key != null) {
            this.neo4jCRUD.remove(key);
        }
    }

    private void applyAssociationOperation(AssociationKey key, AssociationOperation operation, AssociationContext associationContext) {
        switch (operation.getType()) {
            case CLEAR: {
                this.removeAssociation(key, associationContext);
                break;
            }
            case PUT: {
                this.putAssociationOperation(key, operation);
                break;
            }
            case PUT_NULL: {
                this.removeAssociationOperation(key, operation);
                break;
            }
            case REMOVE: {
                this.removeAssociationOperation(key, operation);
            }
        }
    }

    private void putAssociationOperation(AssociationKey associationKey, AssociationOperation action) {
        Relationship relationship;
        if (associationKey.getAssociationKind() == AssociationKind.EMBEDDED_COLLECTION && (relationship = this.neo4jCRUD.findRelationship(associationKey, action.getKey())) != null) {
            for (TupleOperation operation : action.getValue().getOperations()) {
                if (this.contains(associationKey.getMetadata().getRowKeyColumnNames(), operation.getColumn())) continue;
                this.applyOperation((PropertyContainer)relationship.getEndNode(), operation);
            }
            GraphLogger.log("Updated relationship: %1$s", relationship);
        }
    }

    private boolean contains(String[] columnNames, String column) {
        for (String each : columnNames) {
            if (!each.equals(column)) continue;
            return true;
        }
        return false;
    }

    private void removeAssociationOperation(AssociationKey associationKey, AssociationOperation action) {
        this.neo4jCRUD.remove(associationKey, action.getKey());
    }

    private void applyTupleOperations(PropertyContainer propertyContainer, Set<TupleOperation> operations) {
        for (TupleOperation operation : operations) {
            this.applyOperation(propertyContainer, operation);
        }
    }

    private void applyOperation(PropertyContainer node, TupleOperation operation) {
        switch (operation.getType()) {
            case PUT: {
                this.putTupleOperation(node, operation);
                break;
            }
            case PUT_NULL: {
                this.removeTupleOperation(node, operation);
                break;
            }
            case REMOVE: {
                this.removeTupleOperation(node, operation);
            }
        }
    }

    private void removeTupleOperation(PropertyContainer node, TupleOperation operation) {
        if (node.hasProperty(operation.getColumn())) {
            node.removeProperty(operation.getColumn());
        }
    }

    private void putTupleOperation(PropertyContainer node, TupleOperation operation) {
        node.setProperty(operation.getColumn(), operation.getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEachTuple(Consumer consumer, EntityKeyMetadata ... entityKeyMetadatas) {
        for (EntityKeyMetadata entityKeyMetadata : entityKeyMetadatas) {
            ResourceIterator<Node> queryNodes = this.neo4jCRUD.findNodes(entityKeyMetadata.getTable());
            try {
                while (queryNodes.hasNext()) {
                    Node next = (Node)queryNodes.next();
                    Tuple tuple = Neo4jDialect.createTuple(next);
                    consumer.consume(tuple);
                }
            }
            finally {
                queryNodes.close();
            }
        }
    }

    public ClosableIterator<Tuple> executeBackendQuery(BackendQuery<String> backendQuery, QueryParameters queryParameters) {
        Map<String, Object> parameters = this.getNamedParameterValuesConvertedByGridType(queryParameters);
        String nativeQuery = this.buildNativeQuery(backendQuery, queryParameters);
        ExecutionResult result = this.neo4jCRUD.executeQuery(nativeQuery, parameters);
        if (backendQuery.getSingleEntityKeyMetadataOrNull() != null) {
            return new NodesTupleIterator(result);
        }
        return new MapsTupleIterator(result);
    }

    public String parseNativeQuery(String nativeQuery) {
        return nativeQuery;
    }

    private String buildNativeQuery(BackendQuery<String> customQuery, QueryParameters queryParameters) {
        StringBuilder nativeQuery = new StringBuilder((String)customQuery.getQuery());
        this.applyFirstRow(queryParameters, nativeQuery);
        this.applyMaxRows(queryParameters, nativeQuery);
        return nativeQuery.toString();
    }

    private void applyFirstRow(QueryParameters queryParameters, StringBuilder nativeQuery) {
        Integer firstRow = queryParameters.getRowSelection().getFirstRow();
        if (firstRow != null) {
            CypherDSL.skip(nativeQuery, firstRow);
        }
    }

    private void applyMaxRows(QueryParameters queryParameters, StringBuilder nativeQuery) {
        Integer maxRows = queryParameters.getRowSelection().getMaxRows();
        if (maxRows != null) {
            CypherDSL.limit(nativeQuery, maxRows);
        }
    }

    private Map<String, Object> getNamedParameterValuesConvertedByGridType(QueryParameters queryParameters) {
        HashMap<String, Object> parameterValues = new HashMap<String, Object>(queryParameters.getNamedParameters().size());
        Tuple dummy = new Tuple();
        TypeTranslator typeTranslator = (TypeTranslator)this.serviceRegistry.getService(TypeTranslator.class);
        for (Map.Entry parameter : queryParameters.getNamedParameters().entrySet()) {
            GridType gridType = typeTranslator.getType(((TypedValue)parameter.getValue()).getType());
            gridType.nullSafeSet(dummy, ((TypedValue)parameter.getValue()).getValue(), new String[]{(String)parameter.getKey()}, null);
            parameterValues.put((String)parameter.getKey(), dummy.get((String)parameter.getKey()));
        }
        return parameterValues;
    }

    public ParameterMetadataBuilder getParameterMetadataBuilder() {
        return new Neo4jParameterMetadataBuilder();
    }
}

