/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j.dialect.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.hibernate.ogm.datastore.neo4j.dialect.impl.CypherCRUD;
import org.hibernate.ogm.datastore.neo4j.dialect.impl.Neo4jTupleAssociationSnapshot;
import org.hibernate.ogm.datastore.spi.AssociationSnapshot;
import org.hibernate.ogm.datastore.spi.Tuple;
import org.hibernate.ogm.datastore.spi.TupleSnapshot;
import org.hibernate.ogm.grid.AssociationKey;
import org.hibernate.ogm.grid.RowKey;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;

public final class Neo4jAssociationSnapshot
implements AssociationSnapshot {
    private final Map<RowKey, Tuple> tuples = new HashMap<RowKey, Tuple>();

    public Neo4jAssociationSnapshot(Node ownerNode, AssociationKey associationKey) {
        for (Relationship relationship : this.relationships(ownerNode, associationKey)) {
            Neo4jTupleAssociationSnapshot snapshot = new Neo4jTupleAssociationSnapshot(relationship, associationKey);
            RowKey rowKey = this.convert(associationKey, snapshot);
            this.tuples.put(rowKey, new Tuple((TupleSnapshot)snapshot));
        }
    }

    public Tuple get(RowKey rowKey) {
        Tuple tuple = this.tuples.get(rowKey);
        return tuple;
    }

    public boolean containsKey(RowKey rowKey) {
        return this.tuples.containsKey(rowKey);
    }

    public int size() {
        return this.tuples.size();
    }

    public Set<RowKey> getRowKeys() {
        return this.tuples.keySet();
    }

    private Iterable<Relationship> relationships(Node ownerNode, AssociationKey associationKey) {
        return ownerNode.getRelationships(Direction.BOTH, new RelationshipType[]{CypherCRUD.relationshipType(associationKey)});
    }

    private RowKey convert(AssociationKey associationKey, Neo4jTupleAssociationSnapshot snapshot) {
        String[] columnNames = associationKey.getMetadata().getRowKeyColumnNames();
        Object[] values = new Object[columnNames.length];
        for (int i = 0; i < columnNames.length; ++i) {
            values[i] = snapshot.get(columnNames[i]);
        }
        return new RowKey(associationKey.getTable(), columnNames, values, null);
    }
}

